/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.jetspeed.aggregator.PortletContent;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.portlet.HeadElement;
import org.apache.jetspeed.util.KeyValue;

public class HeadElementsUtils {
    private HeadElementsUtils() {
    }

    public static void aggregateHeadElements(List<KeyValue<String, HeadElement>> aggregatedHeadElements, ContentFragment contentFragment) {
        PortletContent portletContent;
        List childContentFragments = contentFragment.getFragments();
        if (childContentFragments != null && !childContentFragments.isEmpty()) {
            for (ContentFragment child : childContentFragments) {
                if ("hidden".equals(contentFragment.getState())) continue;
                HeadElementsUtils.aggregateHeadElements(aggregatedHeadElements, child);
            }
        }
        if ((portletContent = contentFragment.getPortletContent()) != null) {
            HeadElementsUtils.aggregateHeadElements(aggregatedHeadElements, portletContent.getHeadElements());
        }
    }

    public static void aggregateHeadElements(List<KeyValue<String, HeadElement>> aggregatedHeadElements, List<KeyValue<String, HeadElement>> headElements) {
        if (!headElements.isEmpty()) {
            int insertionIndex = 0;
            for (KeyValue<String, HeadElement> kvPair : headElements) {
                int offset = aggregatedHeadElements.indexOf(kvPair);
                if (offset != -1) {
                    insertionIndex = offset + 1;
                    continue;
                }
                aggregatedHeadElements.add(insertionIndex++, kvPair);
            }
        }
    }

    public static void mergeHeadElementsByHint(List<KeyValue<String, HeadElement>> headElements) {
        HashMap<String, HeadElement> firstElementByMergeHint = new HashMap<String, HeadElement>();
        HashMap<String, Set<String>> mergedTextContents = new HashMap<String, Set<String>>();
        Iterator<KeyValue<String, HeadElement>> it = headElements.iterator();
        while (it.hasNext()) {
            Set<String> textContentSet;
            KeyValue<String, HeadElement> kvPair = it.next();
            HeadElement element = (HeadElement)kvPair.getValue();
            if (!element.hasAttribute("org.apache.portals.portal.page.head.element.contribution.merge.hint")) continue;
            String mergeHint = element.getAttribute("org.apache.portals.portal.page.head.element.contribution.merge.hint");
            String textContent = element.getTextContent();
            if (textContent != null) {
                textContent = textContent.trim();
            }
            if (firstElementByMergeHint.containsKey(mergeHint)) {
                if (textContent != null && !"".equals(textContent)) {
                    textContentSet = (Set)mergedTextContents.get(mergeHint);
                    textContentSet.add(textContent);
                }
                it.remove();
                continue;
            }
            firstElementByMergeHint.put(mergeHint, element);
            textContentSet = new TreeSet();
            mergedTextContents.put(mergeHint, textContentSet);
            if (textContent == null || "".equals(textContent)) continue;
            textContentSet.add(textContent);
        }
        for (Map.Entry entry : firstElementByMergeHint.entrySet()) {
            String mergeHint = (String)entry.getKey();
            HeadElement firstElement = (HeadElement)entry.getValue();
            Set textContentSet = (Set)mergedTextContents.get(mergeHint);
            StringBuilder sb = new StringBuilder(80);
            boolean firstDone = false;
            for (String textContent : textContentSet) {
                if (firstDone) {
                    sb.append("\r\n");
                } else {
                    firstDone = true;
                }
                sb.append(textContent);
            }
            firstElement.setTextContent(sb.toString());
        }
    }
}

