/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.apache.jetspeed.util.BaseObjectProxy;

public class DelegatingObjectProxy
extends BaseObjectProxy {
    protected Object[] delegatorObjects;
    protected Class[] proxyInterfaces;
    protected Map<Method, ObjectMethodPair> delegatorObjectMethodPairCache = new HashMap<Method, ObjectMethodPair>();

    public static Object createProxy(Class[] proxyInterfaces, Object ... delegatorObjects) {
        if (proxyInterfaces == null || proxyInterfaces.length == 0) {
            throw new IllegalArgumentException("No proxy interface.");
        }
        if (delegatorObjects == null || delegatorObjects.length == 0) {
            throw new IllegalArgumentException("No delegator object.");
        }
        return DelegatingObjectProxy.createProxy(proxyInterfaces, delegatorObjects[0].getClass().getClassLoader(), delegatorObjects);
    }

    public static Object createProxy(Class[] proxyInterfaces, ClassLoader classLoader, Object ... delegatorObjects) {
        if (proxyInterfaces == null || proxyInterfaces.length == 0) {
            throw new IllegalArgumentException("No proxy interface.");
        }
        if (delegatorObjects == null || delegatorObjects.length == 0) {
            throw new IllegalArgumentException("No delegator object.");
        }
        DelegatingObjectProxy handler = new DelegatingObjectProxy(proxyInterfaces, delegatorObjects);
        return Proxy.newProxyInstance(classLoader, proxyInterfaces, (InvocationHandler)handler);
    }

    public DelegatingObjectProxy(Class[] proxyInterfaces, Object ... delegatorObjects) {
        this.proxyInterfaces = proxyInterfaces;
        this.delegatorObjects = delegatorObjects;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class targetProxyInterface = null;
        Class<?> declaringClass = method.getDeclaringClass();
        for (Class proxyInterface : this.proxyInterfaces) {
            if (declaringClass != proxyInterface) continue;
            targetProxyInterface = proxyInterface;
            break;
        }
        try {
            if (targetProxyInterface != null) {
                ObjectMethodPair targetObjectMethodPair = this.findDelegatorObjectMethodPair(targetProxyInterface, method);
                return targetObjectMethodPair.method.invoke(targetObjectMethodPair.object, args);
            }
            return super.invoke(proxy, method, args);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    private ObjectMethodPair findDelegatorObjectMethodPair(Class proxyInterface, Method method) throws SecurityException, NoSuchMethodException {
        ObjectMethodPair objectMethodPair = this.delegatorObjectMethodPairCache.get(method);
        if (objectMethodPair == null) {
            Method delegatorMethod = null;
            Class targetType = null;
            for (Object delegatorObject : this.delegatorObjects) {
                targetType = delegatorObject.getClass();
                if (proxyInterface.isAssignableFrom(targetType)) {
                    targetType = proxyInterface;
                }
                try {
                    delegatorMethod = targetType.getMethod(method.getName(), method.getParameterTypes());
                }
                catch (Throwable th) {
                    // empty catch block
                }
                if (delegatorMethod == null) continue;
                objectMethodPair = new ObjectMethodPair(delegatorObject, delegatorMethod);
                this.delegatorObjectMethodPairCache.put(method, objectMethodPair);
                break;
            }
            if (objectMethodPair == null) {
                throw new NoSuchMethodException(method.toString());
            }
        }
        return objectMethodPair;
    }

    private class ObjectMethodPair {
        Object object;
        Method method;

        ObjectMethodPair(Object object, Method method) {
            this.object = object;
            this.method = method;
        }
    }
}

