/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container.session;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import org.apache.jetspeed.container.session.PortalSessionMonitor;
import org.apache.jetspeed.container.session.PortalSessionsManager;
import org.apache.jetspeed.container.session.PortletApplicationSessionMonitor;
import org.apache.jetspeed.services.JetspeedPortletServices;
import org.apache.jetspeed.services.PortletServices;

public class PortletApplicationSessionMonitorImpl
implements PortletApplicationSessionMonitor {
    private static final long serialVersionUID = -6729032046828426324L;
    private String contextPath;
    private String portalSessionId;
    private long portalSessionKey;
    private transient HttpSession session;
    private boolean forceInvalidate;

    public PortletApplicationSessionMonitorImpl(String contextPath, String portalSessionId, long portalSessionKey) {
        this(contextPath, portalSessionId, portalSessionKey, true);
    }

    public PortletApplicationSessionMonitorImpl(String contextPath, String portalSessionId, long portalSessionKey, boolean forceInvalidate) {
        this.contextPath = contextPath;
        this.portalSessionId = portalSessionId;
        this.portalSessionKey = portalSessionKey;
        this.forceInvalidate = forceInvalidate;
    }

    public long getPortalSessionKey() {
        return this.portalSessionKey;
    }

    public String getPortalSessionId() {
        return this.portalSessionId;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void invalidateSession() {
        if (this.session != null) {
            HttpSession thisSession = this.session;
            this.session = null;
            if (this.forceInvalidate) {
                try {
                    thisSession.invalidate();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void valueBound(HttpSessionBindingEvent event) {
        this.session = event.getSession();
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        if (this.session != null) {
            PortalSessionsManager manager = this.getManager();
            if (manager != null) {
                manager.sessionDestroyed((PortletApplicationSessionMonitor)this);
            }
            this.session = null;
        }
    }

    public void sessionDidActivate(HttpSessionEvent event) {
        this.session = event.getSession();
        PortalSessionsManager manager = this.getManager();
        if (manager != null) {
            manager.sessionDidActivate((PortletApplicationSessionMonitor)this);
        }
    }

    public void sessionWillPassivate(HttpSessionEvent event) {
        PortalSessionsManager manager = this.getManager();
        if (manager != null) {
            manager.sessionWillPassivate((PortletApplicationSessionMonitor)this);
        }
        this.session = null;
    }

    public void syncPortalSessionId(PortalSessionMonitor psm) {
        if (psm != null && psm.getSessionKey() == this.getPortalSessionKey()) {
            this.portalSessionId = psm.getSessionId();
        }
    }

    private PortalSessionsManager getManager() {
        PortletServices services = JetspeedPortletServices.getSingleton();
        if (services != null) {
            return (PortalSessionsManager)services.getService(PortalSessionsManager.SERVICE_NAME);
        }
        return null;
    }
}

