/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.apache.jetspeed.util.AbstractFileSystemHelper;
import org.apache.jetspeed.util.FileSystemHelper;

public class DirectoryHelper
extends AbstractFileSystemHelper
implements FileSystemHelper {
    protected File directory;

    public DirectoryHelper(File directory) {
        if (!directory.exists()) {
            directory.mkdirs();
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("DirectoryHelper(File) requires directory not a file.");
        }
        this.directory = directory;
    }

    public void copyFrom(File srcDirectory) throws IOException {
        this.copyFrom(srcDirectory, new FileFilter(){

            public boolean accept(File pathname) {
                return true;
            }
        });
    }

    public void copyFrom(File srcDirectory, FileFilter fileFilter) throws IOException {
        if (!srcDirectory.isDirectory()) {
            throw new IllegalArgumentException("DirectoryHelper.copyFrom(File) requires directory not a file.");
        }
        this.copyFiles(srcDirectory, this.directory, fileFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyFiles(File srcDir, File dstDir, FileFilter fileFilter) throws IOException {
        AbstractInterruptibleChannel srcChannel = null;
        AbstractInterruptibleChannel dstChannel = null;
        try {
            File[] children = srcDir.listFiles(fileFilter);
            for (int i = 0; i < children.length; ++i) {
                File child = children[i];
                if (child.isFile()) {
                    File toFile = new File(dstDir, child.getName());
                    toFile.createNewFile();
                    srcChannel = new FileInputStream(child).getChannel();
                    dstChannel = new FileOutputStream(toFile).getChannel();
                    ((FileChannel)dstChannel).transferFrom((ReadableByteChannel)((Object)srcChannel), 0L, ((FileChannel)srcChannel).size());
                    srcChannel.close();
                    dstChannel.close();
                    continue;
                }
                File newSubDir = new File(dstDir, child.getName());
                newSubDir.mkdir();
                this.copyFiles(child, newSubDir, fileFilter);
            }
        }
        finally {
            if (srcChannel != null && srcChannel.isOpen()) {
                try {
                    srcChannel.close();
                }
                catch (Exception e) {}
            }
            if (dstChannel != null && dstChannel.isOpen()) {
                try {
                    dstChannel.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public boolean remove() {
        return this.doRemove(this.directory);
    }

    protected boolean doRemove(File file) {
        if (file.isDirectory()) {
            String[] children = file.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = this.doRemove(new File(file, children[i]));
                if (success) continue;
                return false;
            }
        }
        return file.delete();
    }

    public File getRootDirectory() {
        return this.directory;
    }

    public void close() {
    }

    public String getSourcePath() {
        return this.getRootDirectory().getAbsolutePath();
    }
}

