/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlet;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventPortlet;
import javax.portlet.GenericPortlet;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceServingPortlet;
import javax.portlet.UnavailableException;
import javax.portlet.WindowState;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.container.JetspeedPortletConfig;
import org.apache.jetspeed.factory.PortletFactory;
import org.apache.jetspeed.factory.PortletInstance;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.om.portlet.Supports;
import org.apache.jetspeed.portlet.SupportsHeaderPhase;
import org.apache.jetspeed.util.BaseObjectProxy;
import org.apache.jetspeed.util.GenericPortletUtils;

public class PortletObjectProxy
extends BaseObjectProxy {
    private static Method renderMethod;
    private static Method processActionMethod;
    private Object portletObject;
    private PortletInstance customConfigModePortletInstance;
    private PortletInstance customPreviewModePortletInstance;
    private boolean genericPortletInvocable;
    private Method portletDoEditMethod;
    private boolean autoSwitchEditDefaultsModeToEditMode;
    private boolean autoSwitchConfigMode;
    private String customConfigModePortletUniqueName;
    private boolean autoSwitchPreviewMode;
    private String customPreviewModePortletUniqueName;
    private List<Supports> supports;

    public static Object createProxy(Object proxiedObject, boolean autoSwitchEditDefaultsModeToEditMode, boolean autoSwitchConfigMode, String customConfigModePortletUniqueName) {
        return PortletObjectProxy.createProxy(proxiedObject, autoSwitchEditDefaultsModeToEditMode, autoSwitchConfigMode, customConfigModePortletUniqueName, false, null);
    }

    public static Object createProxy(Object proxiedObject, boolean autoSwitchEditDefaultsModeToEditMode, boolean autoSwitchConfigMode, String customConfigModePortletUniqueName, boolean autoSwitchPreviewMode, String customPreviewModePortletUniqueName) {
        HashSet interfaces = new HashSet();
        interfaces.add(Portlet.class);
        Class<?> current = proxiedObject.getClass();
        while (current != null) {
            try {
                Class<?>[] currentInterfaces = current.getInterfaces();
                for (int i = 0; i < currentInterfaces.length; ++i) {
                    if (currentInterfaces[i] == Portlet.class) continue;
                    interfaces.add(currentInterfaces[i]);
                }
                current = current.getSuperclass();
            }
            catch (Exception e) {
                current = null;
            }
        }
        Class<?> proxiedClass = proxiedObject.getClass();
        ClassLoader classLoader = proxiedClass.getClassLoader();
        PortletObjectProxy handler = new PortletObjectProxy(proxiedObject, autoSwitchEditDefaultsModeToEditMode, autoSwitchConfigMode, customConfigModePortletUniqueName, autoSwitchPreviewMode, customPreviewModePortletUniqueName);
        return Proxy.newProxyInstance(classLoader, interfaces.toArray(new Class[interfaces.size()]), (InvocationHandler)handler);
    }

    private PortletObjectProxy(Object portletObject, boolean autoSwitchEditDefaultsModeToEditMode, boolean autoSwitchConfigMode, String customConfigModePortletUniqueName, boolean autoSwitchPreviewMode, String customPreviewModePortletUniqueName) {
        this.portletObject = portletObject;
        this.autoSwitchEditDefaultsModeToEditMode = autoSwitchEditDefaultsModeToEditMode;
        this.autoSwitchConfigMode = autoSwitchConfigMode;
        this.customConfigModePortletUniqueName = customConfigModePortletUniqueName;
        this.autoSwitchPreviewMode = autoSwitchPreviewMode;
        this.customPreviewModePortletUniqueName = customPreviewModePortletUniqueName;
        if (portletObject instanceof GenericPortlet) {
            this.portletDoEditMethod = GenericPortletUtils.getRenderModeHelperMethod((GenericPortlet)portletObject, PortletMode.EDIT);
            if (this.portletDoEditMethod != null) {
                this.genericPortletInvocable = true;
            }
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        Class<?> declaringClass = method.getDeclaringClass();
        try {
            if (declaringClass == Portlet.class || declaringClass == ResourceServingPortlet.class || declaringClass == EventPortlet.class) {
                if (renderMethod.equals(method)) {
                    this.proxyRender((RenderRequest)args[0], (RenderResponse)args[1]);
                    return null;
                }
                if (processActionMethod.equals(method)) {
                    this.proxyProcessAction((ActionRequest)args[0], (ActionResponse)args[1]);
                } else {
                    result = method.invoke(this.portletObject, args);
                }
            } else {
                result = declaringClass == SupportsHeaderPhase.class ? method.invoke(this.portletObject, args) : super.invoke(proxy, method, args);
            }
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
        return result;
    }

    protected void proxyRender(RenderRequest request, RenderResponse response) throws PortletException, IOException, Exception {
        PortletMode mode = request.getPortletMode();
        boolean autoSwitchConfigMode = false;
        boolean autoSwitchToEditMode = false;
        boolean autoSwitchPreviewMode = false;
        if (this.autoSwitchConfigMode && JetspeedActions.CONFIG_MODE.equals((Object)mode)) {
            autoSwitchConfigMode = true;
        }
        if (this.autoSwitchEditDefaultsModeToEditMode && this.genericPortletInvocable && JetspeedActions.EDIT_DEFAULTS_MODE.equals((Object)mode) && !this.isSupportingPortletMode((GenericPortlet)this.portletObject, JetspeedActions.EDIT_DEFAULTS_MODE)) {
            autoSwitchToEditMode = true;
        }
        if (this.autoSwitchPreviewMode && JetspeedActions.PREVIEW_MODE.equals((Object)mode) && !this.isSupportingPortletMode((GenericPortlet)this.portletObject, JetspeedActions.PREVIEW_MODE)) {
            autoSwitchPreviewMode = true;
        }
        if (autoSwitchConfigMode) {
            try {
                if (this.customConfigModePortletInstance == null) {
                    this.customConfigModePortletInstance = this.getPortletInstance(this.customConfigModePortletUniqueName);
                }
                this.customConfigModePortletInstance.render(request, response);
            }
            catch (UnavailableException e) {
                this.customConfigModePortletInstance = this.getPortletInstance(this.customConfigModePortletUniqueName);
                this.customConfigModePortletInstance.render(request, response);
            }
        } else if (autoSwitchToEditMode) {
            GenericPortlet genericPortlet = (GenericPortlet)this.portletObject;
            WindowState state = request.getWindowState();
            if (!WindowState.MINIMIZED.equals((Object)state)) {
                String title = genericPortlet.getPortletConfig().getResourceBundle(request.getLocale()).getString("javax.portlet.title");
                response.setTitle(title);
                this.portletDoEditMethod.invoke((Object)genericPortlet, request, response);
            }
        } else if (autoSwitchPreviewMode) {
            try {
                if (this.customPreviewModePortletInstance == null) {
                    this.customPreviewModePortletInstance = this.getPortletInstance(this.customPreviewModePortletUniqueName);
                }
                this.customPreviewModePortletInstance.render(request, response);
            }
            catch (UnavailableException e) {
                this.customPreviewModePortletInstance = this.getPortletInstance(this.customPreviewModePortletUniqueName);
                this.customPreviewModePortletInstance.render(request, response);
            }
        } else {
            ((Portlet)this.portletObject).render(request, response);
        }
    }

    protected void proxyProcessAction(ActionRequest request, ActionResponse response) throws PortletException, IOException, Exception {
        PortletMode mode = request.getPortletMode();
        boolean autoSwitchConfigMode = false;
        if (this.autoSwitchConfigMode && JetspeedActions.CONFIG_MODE.equals((Object)mode)) {
            autoSwitchConfigMode = true;
        }
        if (autoSwitchConfigMode) {
            try {
                if (this.customConfigModePortletInstance == null) {
                    this.customConfigModePortletInstance = this.getPortletInstance(this.customConfigModePortletUniqueName);
                }
                this.customConfigModePortletInstance.processAction(request, response);
            }
            catch (UnavailableException e) {
                this.customConfigModePortletInstance = this.getPortletInstance(this.customConfigModePortletUniqueName);
                this.customConfigModePortletInstance.processAction(request, response);
            }
        } else {
            ((Portlet)this.portletObject).processAction(request, response);
        }
    }

    private boolean isSupportingPortletMode(GenericPortlet portlet, PortletMode portletMode) {
        if (this.supports == null) {
            try {
                JetspeedPortletConfig config = (JetspeedPortletConfig)portlet.getPortletConfig();
                PortletDefinition portletDef = config.getPortletDefinition();
                this.supports = portletDef.getSupports();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.supports != null) {
            String portletModeName = portletMode.toString();
            for (Supports s : this.supports) {
                if (!s.getPortletModes().contains(portletModeName)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private PortletInstance getPortletInstance(String portletUniqueName) throws PortletException {
        PortletRegistry registry = (PortletRegistry)Jetspeed.getComponentManager().getComponent((Object)"portletRegistry");
        PortletFactory portletFactory = (PortletFactory)Jetspeed.getComponentManager().getComponent((Object)"portletFactory");
        ServletContext portalAppContext = ((ServletConfig)Jetspeed.getComponentManager().getComponent((Object)"ServletConfig")).getServletContext();
        PortletDefinition portletDef = registry.getPortletDefinitionByUniqueName(portletUniqueName, true);
        PortletApplication portletApp = portletDef.getApplication();
        ServletContext portletAppContext = portalAppContext.getContext(portletApp.getContextPath());
        return portletFactory.getPortletInstance(portletAppContext, portletDef, false);
    }

    static {
        try {
            renderMethod = Portlet.class.getMethod("render", RenderRequest.class, RenderResponse.class);
            processActionMethod = Portlet.class.getMethod("processAction", ActionRequest.class, ActionResponse.class);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
    }
}

