/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.portlet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.jetspeed.om.portlet.GenericMetadata;
import org.apache.jetspeed.om.portlet.LocalizedField;
import org.apache.jetspeed.util.ArgUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericMetadataImpl
implements GenericMetadata {
    private Collection<LocalizedField> fields = null;
    private transient Map<String, Collection<LocalizedField>> fieldMap = null;
    private transient Map<String, Map<Locale, LocalizedField>> localizedText = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Collection<LocalizedField>> getFieldMap(boolean create) {
        if (this.fieldMap == null && create) {
            GenericMetadataImpl genericMetadataImpl = this;
            synchronized (genericMetadataImpl) {
                if (this.fieldMap == null) {
                    this.fieldMap = new HashMap<String, Collection<LocalizedField>>();
                }
            }
        }
        return this.fieldMap;
    }

    private void addFieldMap(LocalizedField field) {
        String fieldMapKey;
        Map<String, Collection<LocalizedField>> fieldMap = this.getFieldMap(true);
        Collection<LocalizedField> fields = fieldMap.get(fieldMapKey = field.getName());
        if (fields == null) {
            fields = new ArrayList<LocalizedField>();
            fieldMap.put(fieldMapKey, fields);
        }
        fields.add(field);
    }

    public void addField(Locale locale, String name, String value) {
        LocalizedField field = this.createLocalizedField();
        field.setName(name);
        field.setValue(value);
        field.setLocale(locale);
        this.addField(field);
    }

    public void addField(LocalizedField field) {
        if (this.fields == null) {
            this.fields = new ArrayList<LocalizedField>();
        }
        this.fields.add(field);
        this.addFieldMap(field);
    }

    public Collection<LocalizedField> getFields(String name) {
        Map<String, Collection<LocalizedField>> fieldMap = this.getFieldMap(false);
        return fieldMap != null ? fieldMap.get(name) : null;
    }

    public void setFields(String name, Collection<LocalizedField> values) {
        Map<String, Collection<LocalizedField>> fieldMap = this.getFieldMap(false);
        if (fieldMap != null) {
            fieldMap.remove(name);
        }
        Iterator<LocalizedField> fieldIter = this.fields.iterator();
        while (fieldIter.hasNext()) {
            LocalizedField field = fieldIter.next();
            if (field == null || field.getName() == null || !field.getName().equals(name)) continue;
            fieldIter.remove();
        }
        if (values != null) {
            for (LocalizedField field : values) {
                this.addFieldMap(field);
            }
            this.fields.addAll(values);
        }
    }

    public Collection<LocalizedField> getFields() {
        return this.fields;
    }

    public void setFields(Collection<LocalizedField> fields) {
        this.fields = fields;
        Map<String, Collection<LocalizedField>> fieldMap = this.getFieldMap(false);
        if (fieldMap != null) {
            fieldMap.clear();
        }
        if (fields != null) {
            for (LocalizedField field : fields) {
                if (field.getName() == null) continue;
                this.addFieldMap(field);
            }
        }
    }

    public void copyFields(Collection<LocalizedField> fields) {
        Map<String, Collection<LocalizedField>> fieldMap;
        if (this.fields != null && !this.fields.isEmpty()) {
            if (fields != null) {
                this.fields.retainAll(fields);
            } else {
                this.fields = null;
            }
        }
        if (fields != null && !fields.isEmpty()) {
            if (this.fields == null) {
                this.fields = new ArrayList<LocalizedField>();
            }
            for (LocalizedField field : fields) {
                if (this.fields.contains(field)) continue;
                this.addField(field.getLocale(), field.getName(), field.getValue());
            }
        }
        if ((fieldMap = this.getFieldMap(false)) != null) {
            fieldMap.clear();
        }
        if (this.fields != null) {
            for (LocalizedField field : this.fields) {
                this.addFieldMap(field);
            }
        }
    }

    public String getText(String name, Locale locale) {
        Collection<LocalizedField> fields;
        Map<Locale, LocalizedField> namedLocalizedText;
        ArgUtil.assertNotNull(String.class, name, this, "getText(String, Locale)");
        ArgUtil.assertNotNull(Locale.class, locale, this, "getText(String, Locale)");
        Map<Locale, LocalizedField> map = namedLocalizedText = this.localizedText != null ? this.localizedText.get(name) : null;
        if (namedLocalizedText == null && this.getFields() != null && (fields = this.getFields(name)) != null && !fields.isEmpty()) {
            namedLocalizedText = new HashMap<Locale, LocalizedField>(this.getFields().size());
            if (this.localizedText == null) {
                this.localizedText = Collections.synchronizedMap(new HashMap(this.getFields().size()));
            }
            this.localizedText.put(name, namedLocalizedText);
            for (LocalizedField field : fields) {
                namedLocalizedText.put(field.getLocale(), field);
            }
        }
        if (namedLocalizedText != null && !namedLocalizedText.isEmpty()) {
            if (namedLocalizedText.containsKey(locale)) {
                return namedLocalizedText.get(locale).getValue().trim();
            }
            Locale languageOnly = new Locale(locale.getLanguage());
            if (namedLocalizedText.containsKey(languageOnly)) {
                return namedLocalizedText.get(languageOnly).getValue().trim();
            }
        }
        return null;
    }
}

