/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;

public class Path
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 6890966283704092945L;
    public static final String PATH_SEPERATOR = "/";
    private static final String[] EMPTY_SEGMENTS = new String[0];
    private static HashMap childrenMap = new HashMap();
    private final String path;
    private final String[] segments;
    private final String fileName;
    private final String baseName;
    private final String fileExtension;
    private final String queryString;
    private final int hashCode;

    public Path() {
        this.segments = EMPTY_SEGMENTS;
        this.fileName = null;
        this.baseName = null;
        this.fileExtension = null;
        this.queryString = null;
        this.hashCode = 0;
        this.path = "";
    }

    private Path(Path parent, String childSegment, boolean pathOnly) {
        this(parent, Path.splitPath(childSegment), pathOnly);
    }

    private Path(Path parent, String[] children, boolean pathOnly) {
        int code = 0;
        if (!pathOnly) {
            this.fileName = parent.fileName;
            this.baseName = parent.baseName;
            this.fileExtension = parent.fileExtension;
            this.queryString = parent.queryString;
            if (this.queryString != null) {
                code += this.queryString.hashCode();
            }
        } else {
            this.fileName = null;
            this.baseName = null;
            this.fileExtension = null;
            this.queryString = null;
        }
        int size = parent.segments.length;
        if (pathOnly && parent.fileName != null) {
            --size;
        }
        int index = 0;
        this.segments = new String[size + children.length];
        for (index = 0; index < size; ++index) {
            this.segments[index] = parent.segments[index];
            code += this.segments[index].hashCode();
        }
        int i = 0;
        while (i < children.length) {
            this.segments[index] = children[i];
            code += this.segments[index].hashCode();
            ++i;
            ++index;
        }
        if (this.fileName != null && !pathOnly) {
            this.segments[index] = this.fileName;
            code += this.segments[index].hashCode();
        }
        this.hashCode = code;
        this.path = this.buildPath();
    }

    private Path(Path parent) {
        this.fileName = parent.fileName;
        this.baseName = parent.baseName;
        this.fileExtension = parent.fileExtension;
        this.queryString = parent.queryString;
        this.segments = new String[parent.segments.length - 1];
        int code = 0;
        for (int i = 0; i < parent.segments.length - 2; ++i) {
            this.segments[i] = parent.segments[i];
            code += this.segments.hashCode();
        }
        if (this.fileName != null) {
            this.segments[this.segments.length - 1] = this.fileName;
        } else if (parent.segments.length > 1) {
            this.segments[this.segments.length - 1] = parent.segments[parent.segments.length - 2];
        }
        if (this.segments.length > 0) {
            code += this.segments[this.segments.length - 1].hashCode();
        }
        if (this.queryString != null) {
            code += this.queryString.hashCode();
        }
        this.hashCode = code;
        this.path = this.buildPath();
    }

    private Path(String[] segments, int offset, int count) {
        this.segments = new String[count];
        int code = 0;
        for (int i = 0; i < count; ++i) {
            this.segments[i] = segments[offset + i];
            code += segments[offset + i].hashCode();
        }
        this.hashCode = code;
        if (count > 0) {
            this.fileName = this.segments[count - 1];
            int extIndex = this.fileName.lastIndexOf(46);
            if (extIndex > -1) {
                this.baseName = this.fileName.substring(0, extIndex);
                this.fileExtension = this.fileName.substring(extIndex);
            } else {
                this.baseName = this.fileName;
                this.fileExtension = "";
            }
        } else {
            this.fileName = null;
            this.baseName = null;
            this.fileExtension = null;
        }
        this.queryString = null;
        this.path = this.buildPath();
    }

    public Path(String path) {
        String tmp = path.replace('\\', '/');
        if (!tmp.startsWith(PATH_SEPERATOR)) {
            tmp = PATH_SEPERATOR + tmp;
        }
        this.path = tmp;
        if (path.equals(PATH_SEPERATOR)) {
            this.segments = new String[]{""};
            this.fileName = null;
            this.baseName = null;
            this.fileExtension = null;
            this.queryString = null;
            this.hashCode = 0;
        } else {
            int queryStart = path.indexOf(63);
            int len = queryStart > -1 ? queryStart : path.length();
            this.segments = Path.split(path, 0, len, '/');
            int code = 0;
            for (int i = 0; i < this.segments.length; ++i) {
                code += this.segments[i].hashCode();
            }
            String tmpFileName = null;
            if (queryStart > 1 && path.length() > queryStart + 1) {
                this.queryString = path.substring(queryStart + 1);
                code += this.queryString.hashCode();
            } else {
                this.queryString = null;
            }
            this.hashCode = code;
            int extIndex = -1;
            if (this.segments.length > 0) {
                tmpFileName = this.segments[this.segments.length - 1];
                extIndex = tmpFileName.lastIndexOf(46);
            }
            if (extIndex > -1) {
                this.fileName = tmpFileName;
                this.baseName = tmpFileName.substring(0, extIndex);
                this.fileExtension = tmpFileName.substring(extIndex);
            } else {
                this.fileName = null;
                this.baseName = null;
                this.fileExtension = null;
            }
        }
    }

    private static String[] splitPath(String path) {
        String[] children = null;
        if ((path = path.replace('\\', '/')).startsWith(PATH_SEPERATOR)) {
            path = PATH_SEPERATOR + path;
        }
        if (path.equals(PATH_SEPERATOR)) {
            children = new String[]{""};
        } else {
            int index = path.indexOf(63);
            int len = index > -1 ? index : path.length();
            children = Path.split(path, 0, len, '/');
        }
        return children;
    }

    public String getSegment(int i) {
        return this.segments[i];
    }

    public Path addSegment(String segment) {
        return new Path(this, segment, false);
    }

    public Path getSubPath(int beginAtSegment) {
        return new Path(this.segments, beginAtSegment, this.segments.length - beginAtSegment);
    }

    public Path getSubPath(int beginAtSegment, int endSegment) {
        return new Path(this.segments, beginAtSegment, endSegment - beginAtSegment);
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public int length() {
        return this.segments.length;
    }

    public String toString() {
        return this.path;
    }

    private String buildPath() {
        int len = 0;
        for (int i = 0; i < this.segments.length; ++i) {
            len += this.segments[i].length() + 1;
        }
        if (this.queryString != null) {
            len += this.queryString.length() + 1;
        }
        char[] buffer = new char[len];
        int index = 0;
        for (int i = 0; i < this.segments.length; ++i) {
            buffer[index++] = 47;
            len = this.segments[i].length();
            this.segments[i].getChars(0, len, buffer, index);
            index += len;
        }
        if (this.queryString != null) {
            buffer[index++] = 63;
            len = this.queryString.length();
            this.queryString.getChars(0, len, buffer, index);
        }
        return new String(buffer);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Path) {
            Path other = (Path)obj;
            if (other.queryString != null && other.queryString.equals(this.queryString) || other.queryString == null && this.queryString == null) {
                return Arrays.equals(other.segments, this.segments);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public Path removeLastPathSegment() {
        if (this.fileName != null && this.segments.length == 1 || this.segments.length == 0) {
            return this;
        }
        return new Path(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path getChild(String childPath) {
        HashMap hashMap = childrenMap;
        synchronized (hashMap) {
            Path child = null;
            HashMap<String, Path> children = (HashMap<String, Path>)childrenMap.get(this.path);
            if (children == null) {
                children = new HashMap<String, Path>();
                childrenMap.put(this.path, children);
            } else {
                child = (Path)children.get(childPath);
            }
            if (child == null) {
                child = this.segments.length == 0 ? new Path(childPath) : new Path(this, childPath, true);
                children.put(childPath, child);
            }
            return child;
        }
    }

    public Path getChild(Path childPath) {
        return this.getChild(childPath.path);
    }

    private static String[] split(String str, int start, int length, char separator) {
        char[] buffer = str.toCharArray();
        int tokens = 0;
        boolean token = false;
        for (int i = start; i < length; ++i) {
            if (buffer[i] == separator) {
                token = false;
                continue;
            }
            if (token) continue;
            ++tokens;
            token = true;
        }
        String[] result = new String[tokens];
        if (tokens > 0) {
            int begin = start;
            int end = start;
            token = false;
            tokens = 0;
            for (int i = start; i < length; ++i) {
                if (buffer[i] == separator) {
                    if (!token) continue;
                    result[tokens++] = new String(buffer, begin, end);
                    token = false;
                    continue;
                }
                if (!token) {
                    token = true;
                    begin = i;
                    end = 1;
                    continue;
                }
                ++end;
            }
            if (token) {
                result[tokens] = new String(buffer, begin, end);
            }
        }
        return result;
    }
}

