/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security;

import java.security.Principal;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.jetspeed.security.JetspeedPrincipal;
import org.apache.jetspeed.security.UserCredential;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubjectHelper {
    public static Principal getPrincipal(Subject subject, Class<? extends Principal> classe) {
        Principal principal = null;
        Set<Principal> principalList = subject.getPrincipals();
        if (principalList != null) {
            for (Principal p : subject.getPrincipals()) {
                if (!classe.isInstance(p)) continue;
                principal = p;
                break;
            }
        }
        return principal;
    }

    public static Principal getBestPrincipal(Subject subject, Class<? extends Principal> classe) {
        Principal principal = null;
        for (Principal p : subject.getPrincipals()) {
            if (classe.isInstance(p)) {
                principal = p;
                break;
            }
            if (principal != null) continue;
            principal = p;
        }
        return principal;
    }

    public static Principal getBestPrincipal(Principal[] principals, Class<? extends Principal> classe) {
        Principal principal = null;
        for (int i = 0; i < principals.length; ++i) {
            Principal p = principals[i];
            if (classe.isInstance(p)) {
                principal = p;
                break;
            }
            if (principal != null) continue;
            principal = p;
        }
        return principal;
    }

    public static List<Principal> getPrincipals(Subject subject, Class<? extends Principal> classe) {
        LinkedList<Principal> result = new LinkedList<Principal>();
        for (Principal p : subject.getPrincipals()) {
            if (!classe.isInstance(p)) continue;
            result.add(p);
        }
        return result;
    }

    public static List<JetspeedPrincipal> getPrincipals(Subject subject, String jptName) {
        LinkedList<JetspeedPrincipal> result = new LinkedList<JetspeedPrincipal>();
        for (Principal p : subject.getPrincipals()) {
            JetspeedPrincipal jp;
            if (!(p instanceof JetspeedPrincipal) || !(jp = (JetspeedPrincipal)p).getType().getName().equals(jptName)) continue;
            result.add(jp);
        }
        return result;
    }

    public static Principal getPrincipal(Subject subject, Class<? extends Principal> classe, String name) {
        for (Principal p : subject.getPrincipals()) {
            if (!classe.isInstance(p) || !p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public static UserCredential getUserCredential(Subject subject) {
        for (Object o : subject.getPrivateCredentials()) {
            if (!(o instanceof UserCredential)) continue;
            return (UserCredential)o;
        }
        return null;
    }
}

