/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security;

import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.jetspeed.security.AuthenticatedUser;
import org.apache.jetspeed.security.PrincipalsSet;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserSubjectPrincipalImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JetspeedSubjectFactory {
    public static Subject createSubject(AuthenticatedUser user, Set<Principal> principals) {
        return JetspeedSubjectFactory.createSubject(user.getUser(), user.getPublicCredentials(), user.getPrivateCredentials(), principals);
    }

    public static Subject createSubject(User user, Set<Object> publicCredentials, Set<Object> privateCredentials, Set<Principal> principals) {
        UserSubjectPrincipalImpl userPrincipal = new UserSubjectPrincipalImpl(user);
        Set<User> subjectPrincipals = principals == null || principals.isEmpty() ? new HashSet() : new PrincipalsSet();
        subjectPrincipals.add((User)userPrincipal);
        subjectPrincipals.add(user);
        if (principals != null) {
            subjectPrincipals.addAll(principals);
        }
        Set<Object> pubCred = publicCredentials == null || publicCredentials.isEmpty() ? Collections.EMPTY_SET : new HashSet<Object>(publicCredentials);
        Set<Object> privCred = privateCredentials == null || privateCredentials.isEmpty() ? Collections.EMPTY_SET : new HashSet<Object>(privateCredentials);
        Subject subject = new Subject(true, subjectPrincipals, pubCred, privCred);
        userPrincipal.setSubject(subject);
        return subject;
    }
}

