/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.layout;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.jetspeed.om.page.Fragment;
import org.apache.jetspeed.portlets.layout.EmptyLayoutLocationException;
import org.apache.jetspeed.portlets.layout.FragmentNotInLayoutException;
import org.apache.jetspeed.portlets.layout.InvalidLayoutLocationException;
import org.apache.jetspeed.portlets.layout.LayoutCoordinate;
import org.apache.jetspeed.portlets.layout.LayoutError;
import org.apache.jetspeed.portlets.layout.LayoutEvent;
import org.apache.jetspeed.portlets.layout.LayoutEventException;
import org.apache.jetspeed.portlets.layout.LayoutEventListener;

public class ColumnLayout
implements Serializable {
    private static final double PERCENTAGE_WIDTH_GUTTER = 0.01;
    private static final DecimalFormat PERCENTAGE_WIDTH_FORMAT = new DecimalFormat("0.00'%'", new DecimalFormatSymbols(Locale.ENGLISH));
    private final int numberOfColumns;
    private final SortedMap columns;
    private final String[] columnWidths;
    private final int[] nextRowNumber;
    private final Map coordinates;
    private final List eventListeners;

    public ColumnLayout(int numberOfColumns, String layoutType, String[] columnWidths) {
        int i;
        this.numberOfColumns = numberOfColumns;
        this.columnWidths = columnWidths;
        this.eventListeners = new ArrayList();
        this.columns = new TreeMap();
        this.coordinates = new HashMap();
        for (i = 0; i < numberOfColumns; ++i) {
            this.columns.put(new Integer(i), new TreeMap());
        }
        this.nextRowNumber = new int[numberOfColumns];
        for (i = 0; i < numberOfColumns; ++i) {
            this.nextRowNumber[i] = 0;
        }
    }

    public ColumnLayout(int numberOfColumns, String layoutType, Collection fragments, String[] columnWidths) throws LayoutEventException {
        this(numberOfColumns, layoutType, columnWidths);
        Iterator fragmentsItr = fragments.iterator();
        try {
            while (fragmentsItr.hasNext()) {
                Fragment fragment = (Fragment)fragmentsItr.next();
                this.doAdd(this.getColumn(fragment), this.getRow(this.getColumn(fragment), fragment), fragment);
            }
        }
        catch (InvalidLayoutLocationException e) {
            throw new LayoutError("A malformed fragment could not be adjusted.", (Throwable)((Object)e));
        }
    }

    public void addFragment(Fragment fragment) throws LayoutEventException {
        try {
            this.doAdd(this.getColumn(fragment), this.getRow(this.getColumn(fragment), fragment), fragment);
            LayoutCoordinate coordinate = this.getCoordinate(fragment);
            this.processEvent(new LayoutEvent(0, fragment, coordinate, coordinate));
        }
        catch (InvalidLayoutLocationException e) {
            throw new LayoutError("A malformed fragment could not be adjusted.", (Throwable)((Object)e));
        }
        catch (FragmentNotInLayoutException e) {
            throw new LayoutError("Failed to add coordinate to this ColumnLayout.", (Throwable)((Object)e));
        }
    }

    public void addLayoutEventListener(LayoutEventListener eventListener) {
        this.eventListeners.add(eventListener);
    }

    public Collection getColumn(int columnNumber) throws InvalidLayoutLocationException {
        return Collections.unmodifiableCollection(this.getColumnMap(columnNumber).values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getColumnWidth(int columnNumber) {
        if (this.columnWidths != null && columnNumber < this.numberOfColumns) {
            int percentIndex;
            String columnWidth = this.columnWidths[columnNumber];
            if (this.numberOfColumns > 1 && columnNumber == this.numberOfColumns - 1 && (percentIndex = columnWidth.lastIndexOf(37)) > 0) {
                try {
                    double width = Double.parseDouble(columnWidth.substring(0, percentIndex).trim());
                    DecimalFormat decimalFormat = PERCENTAGE_WIDTH_FORMAT;
                    synchronized (decimalFormat) {
                        columnWidth = PERCENTAGE_WIDTH_FORMAT.format(width - 0.01);
                    }
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            return columnWidth;
        }
        return "0";
    }

    public String getColumnFloat(int columnNumber) {
        if (this.numberOfColumns > 1 && columnNumber < this.numberOfColumns) {
            if (columnNumber == this.numberOfColumns - 1) {
                return "right";
            }
            return "left";
        }
        return "none";
    }

    public Collection getColumns() {
        ArrayList columnList = new ArrayList(this.getNumberOfColumns());
        Iterator itr = this.columns.values().iterator();
        while (itr.hasNext()) {
            columnList.add(Collections.unmodifiableCollection(((Map)itr.next()).values()));
        }
        return Collections.unmodifiableCollection(columnList);
    }

    public int getLastRowNumber(int columnNumber) {
        return this.nextRowNumber[columnNumber] - 1;
    }

    public Collection getFragments() {
        return Collections.unmodifiableCollection(this.coordinates.keySet());
    }

    public Fragment getFragmentAt(int columnNumber, int rowNumber) throws EmptyLayoutLocationException, InvalidLayoutLocationException {
        Integer rowInteger;
        SortedMap column = this.getColumnMap(columnNumber);
        if (column.containsKey(rowInteger = new Integer(rowNumber))) {
            return (Fragment)column.get(rowInteger);
        }
        throw new EmptyLayoutLocationException(columnNumber, rowNumber);
    }

    public Fragment getFragmentAt(LayoutCoordinate coodinate) throws EmptyLayoutLocationException, InvalidLayoutLocationException {
        return this.getFragmentAt(coodinate.getX(), coodinate.getY());
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public Collection getLastColumn() {
        try {
            return Collections.unmodifiableCollection(this.getColumnMap(this.numberOfColumns - 1).values());
        }
        catch (InvalidLayoutLocationException e) {
            throw new LayoutError("It appears this layout is corrupt and cannot correctly identify its last column.", (Throwable)((Object)e));
        }
    }

    public Collection getFirstColumn() {
        try {
            return Collections.unmodifiableCollection(this.getColumnMap(0).values());
        }
        catch (InvalidLayoutLocationException e) {
            throw new LayoutError("It appears this layout is corrupt and cannot correctly identify its first column.", (Throwable)((Object)e));
        }
    }

    public void moveRight(Fragment fragment) throws FragmentNotInLayoutException, LayoutEventException {
        LayoutCoordinate coordinate = this.getCoordinate(fragment);
        LayoutCoordinate newCoordinate = new LayoutCoordinate(coordinate.getX() + 1, coordinate.getY());
        if (newCoordinate.getX() < this.numberOfColumns) {
            try {
                this.doMove(fragment, coordinate, newCoordinate);
                this.processEvent(new LayoutEvent(4, fragment, coordinate, newCoordinate));
                try {
                    Fragment fragmentBelow = this.getFragmentAt(new LayoutCoordinate(coordinate.getX(), coordinate.getY() + 1));
                    this.moveUp(fragmentBelow);
                }
                catch (EmptyLayoutLocationException e) {}
            }
            catch (InvalidLayoutLocationException e) {
                throw new LayoutError("It appears this layout is corrupt and cannot correctly identify valid column locations.", (Throwable)((Object)e));
            }
        }
    }

    public void moveLeft(Fragment fragment) throws FragmentNotInLayoutException, LayoutEventException {
        LayoutCoordinate coordinate = this.getCoordinate(fragment);
        LayoutCoordinate newCoordinate = new LayoutCoordinate(coordinate.getX() - 1, coordinate.getY());
        if (newCoordinate.getX() >= 0) {
            try {
                this.doMove(fragment, coordinate, newCoordinate);
                this.processEvent(new LayoutEvent(3, fragment, coordinate, newCoordinate));
                try {
                    Fragment fragmentBelow = this.getFragmentAt(new LayoutCoordinate(coordinate.getX(), coordinate.getY() + 1));
                    this.moveUp(fragmentBelow);
                }
                catch (EmptyLayoutLocationException e) {}
            }
            catch (InvalidLayoutLocationException e) {
                throw new LayoutError("It appears this layout is corrupt and cannot correctly identify valid column locations.", (Throwable)((Object)e));
            }
        }
    }

    public void moveUp(Fragment fragment) throws FragmentNotInLayoutException, LayoutEventException {
        LayoutCoordinate coordinate = this.getCoordinate(fragment);
        LayoutCoordinate aboveLayoutCoordinate = new LayoutCoordinate(coordinate.getX(), coordinate.getY() - 1);
        LayoutCoordinate newCoordinate = aboveLayoutCoordinate;
        if (newCoordinate.getY() >= 0) {
            try {
                try {
                    this.getFragmentAt(aboveLayoutCoordinate);
                    this.doMove(fragment, coordinate, newCoordinate);
                    this.processEvent(new LayoutEvent(1, fragment, coordinate, newCoordinate));
                }
                catch (EmptyLayoutLocationException e) {
                    this.doMove(fragment, coordinate, newCoordinate);
                    this.processEvent(new LayoutEvent(1, fragment, coordinate, newCoordinate));
                    if (coordinate.getY() == this.nextRowNumber[coordinate.getX()] - 1) {
                        this.nextRowNumber[coordinate.getX()] = coordinate.getX();
                    }
                    try {
                        Fragment fragmentBelow = this.getFragmentAt(new LayoutCoordinate(coordinate.getX(), coordinate.getY() + 1));
                        this.moveUp(fragmentBelow);
                    }
                    catch (EmptyLayoutLocationException e1) {}
                }
            }
            catch (InvalidLayoutLocationException e) {
                throw new LayoutError("It appears this layout is corrupt and cannot correctly identify valid column locations.", (Throwable)((Object)e));
            }
        }
    }

    public void moveDown(Fragment fragment) throws FragmentNotInLayoutException, LayoutEventException {
        LayoutCoordinate coordinate = this.getCoordinate(fragment);
        LayoutCoordinate newCoordinate = new LayoutCoordinate(coordinate.getX(), coordinate.getY() + 1);
        if (newCoordinate.getY() < this.nextRowNumber[coordinate.getX()]) {
            try {
                try {
                    LayoutCoordinate aboveCoord = new LayoutCoordinate(coordinate.getX(), coordinate.getY() + 1);
                    Fragment fragmentBelow = this.getFragmentAt(aboveCoord);
                    this.doMove(fragmentBelow, aboveCoord, coordinate);
                    this.processEvent(new LayoutEvent(1, fragmentBelow, aboveCoord, coordinate));
                }
                catch (EmptyLayoutLocationException e) {
                    this.doMove(fragment, coordinate, newCoordinate);
                    this.processEvent(new LayoutEvent(2, fragment, coordinate, newCoordinate));
                }
            }
            catch (InvalidLayoutLocationException e) {
                throw new LayoutError("It appears this layout is corrupt and cannot correctly identify valid column locations.", (Throwable)((Object)e));
            }
        }
    }

    protected void doMove(Fragment fragment, LayoutCoordinate oldCoordinate, LayoutCoordinate newCoordinate) throws InvalidLayoutLocationException, LayoutEventException {
        SortedMap oldColumn = this.getColumnMap(oldCoordinate.getX());
        oldColumn.remove(new Integer(oldCoordinate.getY()));
        this.coordinates.remove(fragment);
        this.doAdd(newCoordinate.getX(), newCoordinate.getY(), fragment);
    }

    public LayoutCoordinate getCoordinate(Fragment fragment) throws FragmentNotInLayoutException {
        if (this.coordinates.containsKey(fragment)) {
            return (LayoutCoordinate)this.coordinates.get(fragment);
        }
        throw new FragmentNotInLayoutException(fragment);
    }

    protected void doAdd(int columnNumber, int rowNumber, Fragment fragment) throws InvalidLayoutLocationException, LayoutEventException {
        SortedMap column = this.getColumnMap(columnNumber);
        Integer rowInteger = new Integer(rowNumber);
        LayoutCoordinate targetCoordinate = new LayoutCoordinate(columnNumber, rowNumber);
        if (column.containsKey(rowInteger)) {
            Fragment existingFragment = (Fragment)column.get(rowInteger);
            column.put(rowInteger, fragment);
            this.coordinates.put(fragment, targetCoordinate);
            this.doAdd(columnNumber, ++rowNumber, existingFragment);
            LayoutCoordinate oneDownCoordinate = new LayoutCoordinate(targetCoordinate.getX(), targetCoordinate.getY() + 1);
            this.processEvent(new LayoutEvent(2, existingFragment, targetCoordinate, oneDownCoordinate));
        } else {
            column.put(rowInteger, fragment);
            this.coordinates.put(fragment, targetCoordinate);
            if (++rowNumber > this.nextRowNumber[columnNumber]) {
                this.nextRowNumber[columnNumber] = rowNumber;
            }
        }
    }

    protected final SortedMap getColumnMap(int columnNumber) throws InvalidLayoutLocationException {
        Integer columnNumberIneteger = new Integer(columnNumber);
        if (this.columns.containsKey(columnNumberIneteger)) {
            return (SortedMap)this.columns.get(columnNumberIneteger);
        }
        throw new InvalidLayoutLocationException(columnNumber);
    }

    protected final int getRow(int currentColumn, Fragment fragment) {
        String propertyValue = fragment.getProperty("row");
        if (propertyValue != null) {
            return Integer.parseInt(propertyValue);
        }
        return this.nextRowNumber[currentColumn];
    }

    protected final int getColumn(Fragment fragment) {
        String propertyValue = fragment.getProperty("column");
        if (propertyValue != null) {
            int columnNumber = Integer.parseInt(propertyValue);
            if (columnNumber >= this.numberOfColumns) {
                columnNumber = this.numberOfColumns - 1;
            } else if (columnNumber < 0) {
                columnNumber = 0;
            }
            return columnNumber;
        }
        return this.numberOfColumns - 1;
    }

    protected final void processEvent(LayoutEvent event) throws LayoutEventException {
        for (LayoutEventListener eventListener : this.eventListeners) {
            eventListener.handleEvent(event);
        }
    }
}

