/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.container;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Timer;
import java.util.TimerTask;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventPortlet;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceServingPortlet;
import javax.portlet.UnavailableException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.container.FilterManager;
import org.apache.jetspeed.container.JetspeedPortletConfig;
import org.apache.jetspeed.container.PortletWindow;
import org.apache.jetspeed.container.session.PortalSessionsManager;
import org.apache.jetspeed.factory.PortletInstance;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.services.JetspeedPortletServices;
import org.apache.jetspeed.services.PortletServices;
import org.apache.jetspeed.tools.pamanager.PortletApplicationManagement;
import org.apache.jetspeed.util.DirectoryHelper;
import org.apache.jetspeed.util.FileSystemHelper;
import org.apache.pluto.container.PortletMimeResponseContext;

public class JetspeedContainerServlet
extends HttpServlet {
    private static final long serialVersionUID = -7900846019170204195L;
    private boolean started = false;
    private PortalSessionsManager psm;
    Timer startTimer = null;
    String contextName;
    String contextPath;
    private static final String JCS = "JetspeedContainerServlet: ";
    private static final String INIT_START_MSG = "JetspeedContainerServlet: starting initialization of Portlet Application at: ";
    private static final String TRY_START_MSG = "JetspeedContainerServlet: attemping to start Portlet Application at: ";
    private static final String STARTED_MSG = "JetspeedContainerServlet: started Portlet Application at: ";
    private static final String INIT_FAILED_MSG = "JetspeedContainerServlet: initialization failed for Portlet Application at: ";
    private static final String INIT_DONE_MSG = "JetspeedContainerServlet: initialization done for Portlet Application at: ";
    private static final String STOP_MSG = "JetspeedContainerServlet: shutting down portlet application at: ";
    private static final String STOP_FAILED_MSG = "JetspeedContainerServlet: shutting down error for portlet application at: ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void init(ServletConfig config) throws ServletException {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        synchronized (clazz) {
            super.init(config);
            ServletContext context = this.getServletContext();
            this.started = false;
            this.startTimer = null;
            this.contextName = config.getInitParameter("contextName");
            this.contextPath = config.getInitParameter("contextPath");
            if (null == this.contextName || this.contextName.length() == 0) {
                this.contextName = null;
                throw new ServletException("JetspeedContainerServlet: Portlet Application contextName not supplied in Init Parameters.");
            }
            if (null == this.contextPath || this.contextPath.length() == 0) {
                this.contextPath = "/" + this.contextName;
            } else if (!this.contextPath.startsWith("/")) {
                throw new ServletException("JetspeedContainerServlet: Portlet Application contextPath must start with a  \"/\".");
            }
            String paDir = context.getRealPath("/");
            if (paDir == null) {
                throw new ServletException("JetspeedContainerServlet:  Initialization of PortletApplication at " + this.contextName + " without access to its real path not supported");
            }
            context.log(INIT_START_MSG + this.contextName);
            System.out.println(INIT_START_MSG + this.contextName);
            try {
                this.startPortletApplication(context, paDir, Thread.currentThread().getContextClassLoader());
            }
            catch (Exception e) {
                String message = INIT_FAILED_MSG + this.contextName;
                context.log(message, (Throwable)e);
                System.err.println(message);
                throw new ServletException(message, (Throwable)e);
            }
            context.log(INIT_DONE_MSG + this.contextName);
            System.out.println(INIT_DONE_MSG + this.contextName);
        }
    }

    private void startPortletApplication(final ServletContext context, final String paDir, final ClassLoader paClassLoader) {
        final String START_DELAYED_MSG = "JetspeedContainerServlet: Could not yet start portlet application at: " + this.contextName + ". Starting back ground thread to start when the portal comes online.";
        context.log(START_DELAYED_MSG);
        this.startTimer = new Timer(true);
        this.startTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String string = JetspeedContainerServlet.this.contextName;
                synchronized (string) {
                    if (JetspeedContainerServlet.this.startTimer != null) {
                        if (JetspeedContainerServlet.this.attemptStart(context, JetspeedContainerServlet.this.contextName, JetspeedContainerServlet.this.contextPath, paDir, paClassLoader)) {
                            JetspeedContainerServlet.this.startTimer.cancel();
                            JetspeedContainerServlet.this.startTimer = null;
                        } else {
                            context.log(START_DELAYED_MSG);
                        }
                    }
                }
            }
        }, 1L, 10000L);
    }

    boolean attemptStart(ServletContext context, String contextName, String contextPath, String paDir, ClassLoader paClassLoader) {
        try {
            PortletApplicationManagement pam;
            context.log(TRY_START_MSG + contextPath);
            PortletServices services = JetspeedPortletServices.getSingleton();
            if (services != null && (pam = (PortletApplicationManagement)services.getService("PAM")) != null && pam.isStarted()) {
                DirectoryHelper paDirHelper = new DirectoryHelper(new File(paDir));
                pam.startPortletApplication(contextName, contextPath, (FileSystemHelper)paDirHelper, paClassLoader);
                this.started = true;
                this.psm = (PortalSessionsManager)services.getService(PortalSessionsManager.SERVICE_NAME);
                context.log(STARTED_MSG + contextPath);
                return true;
            }
        }
        catch (Exception e) {
            context.log(INIT_FAILED_MSG + contextPath, (Throwable)e);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block38: {
            boolean destroyPortlet = false;
            RequestContext rc = Jetspeed.getCurrentRequestContext();
            if (rc == null) {
                return;
            }
            PortletWindow window = rc.getCurrentPortletWindow();
            if (window == null) {
                return;
            }
            if (PortletWindow.Action.NOOP.equals((Object)window.getAction())) {
                return;
            }
            try {
                PortletInstance portletInstance = window.getPortletInstance();
                JetspeedPortletConfig portletConfig = portletInstance.getConfig();
                window.getPortletRequestContext().init((PortletConfig)portletConfig, this.getServletContext(), request, response);
                window.getPortletResponseContext().init(request, response);
                FilterManager filterManager = (FilterManager)window.getAttribute("org.apache.jetspeed.portlet.container.filterManager");
                window.removeAttribute("org.apache.jetspeed.portlet.container.filterManager");
                if (PortletWindow.Action.ACTION.equals((Object)window.getAction())) {
                    ActionRequest actionRequest = (ActionRequest)window.getPortletRequest();
                    ActionResponse actionResponse = (ActionResponse)window.getPortletResponse();
                    if (filterManager != null) {
                        filterManager.processFilter(actionRequest, actionResponse, (Portlet)portletInstance, portletConfig.getPortletContext());
                    } else {
                        portletInstance.processAction(actionRequest, actionResponse);
                    }
                } else if (PortletWindow.Action.RENDER.equals((Object)window.getAction())) {
                    RenderRequest renderRequest = (RenderRequest)window.getPortletRequest();
                    RenderResponse renderResponse = (RenderResponse)window.getPortletResponse();
                    if (filterManager != null) {
                        filterManager.processFilter(renderRequest, renderResponse, (Portlet)portletInstance, portletConfig.getPortletContext());
                    } else {
                        portletInstance.render(renderRequest, renderResponse);
                    }
                } else if (PortletWindow.Action.EVENT.equals((Object)window.getAction())) {
                    EventRequest eventRequest = (EventRequest)window.getPortletRequest();
                    EventResponse eventResponse = (EventResponse)window.getPortletResponse();
                    if (filterManager != null) {
                        filterManager.processFilter(eventRequest, eventResponse, (EventPortlet)portletInstance, portletConfig.getPortletContext());
                    } else {
                        portletInstance.processEvent(eventRequest, eventResponse);
                    }
                } else if (PortletWindow.Action.RESOURCE.equals((Object)window.getAction())) {
                    ResourceRequest resourceRequest = (ResourceRequest)window.getPortletRequest();
                    ResourceResponse resourceResponse = (ResourceResponse)window.getPortletResponse();
                    if (filterManager != null) {
                        filterManager.processFilter(resourceRequest, resourceResponse, (ResourceServingPortlet)portletInstance, portletConfig.getPortletContext());
                    } else {
                        portletInstance.serveResource(resourceRequest, resourceResponse);
                    }
                }
                return;
            }
            catch (Throwable t) {
                if (t instanceof UnavailableException) {
                    destroyPortlet = true;
                }
                if (PortletWindow.Action.RENDER.equals((Object)window.getAction()) || PortletWindow.Action.RESOURCE.equals((Object)window.getAction())) {
                    ServletContext context = this.getServletContext();
                    context.log("JetspeedContainerServlet: Error rendering portlet \"" + window.getPortletDefinition().getUniqueName() + "\": " + t.toString(), t);
                    PrintWriter writer = ((PortletMimeResponseContext)window.getPortletResponseContext()).getWriter();
                    if (writer != null) {
                        Throwable cause = t;
                        while (cause.getCause() != null) {
                            cause = cause.getCause();
                        }
                        writer.write("Portlet " + window.getPortletDefinition().getUniqueName() + " not available: " + cause.getMessage());
                    }
                    break block38;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                if (t instanceof ServletException) {
                    throw (ServletException)t;
                }
                throw new ServletException(t);
            }
            finally {
                if (destroyPortlet) {
                    try {
                        window.getPortletInstance().destroy();
                    }
                    catch (Exception e) {}
                }
                if (this.psm != null) {
                    this.psm.checkMonitorSession(this.contextName, rc.getRequest().getSession(), request.getSession(false));
                }
            }
        }
    }

    public final void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doGet(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        if (this.contextName != null) {
            String string = this.contextName;
            synchronized (string) {
                if (this.startTimer != null) {
                    this.startTimer.cancel();
                    this.startTimer = null;
                } else if (this.started) {
                    PortletApplicationManagement pam;
                    this.started = false;
                    PortletServices services = JetspeedPortletServices.getSingleton();
                    if (services != null && (pam = (PortletApplicationManagement)services.getService("PAM")) != null && pam.isStarted()) {
                        this.getServletContext().log(STOP_MSG + this.contextName);
                        try {
                            pam.stopPortletApplication(this.contextName);
                        }
                        catch (Exception e) {
                            this.getServletContext().log(STOP_FAILED_MSG + this.contextName, (Throwable)e);
                        }
                    }
                    this.contextName = null;
                    this.psm = null;
                }
            }
        }
    }
}

