/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security;

import java.security.Permission;
import org.apache.jetspeed.security.FolderPermission;
import org.apache.jetspeed.security.PortalResourcePermission;

public class FragmentPermission
extends PortalResourcePermission {
    public FragmentPermission(String name, String actions) {
        super(name, actions);
    }

    public FragmentPermission(String name, int mask) {
        super(name, mask);
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof FragmentPermission)) {
            return false;
        }
        FragmentPermission fragmentPerm = (FragmentPermission)permission;
        String ruleName = this.getName();
        if (!ruleName.equals("<<ALL FRAGMENTS>>")) {
            String testName = fragmentPerm.getName();
            int testNamesSeparator = testName.lastIndexOf("::");
            if (ruleName.endsWith("::" + FolderPermission.WILD_CHAR_STR) && testNamesSeparator > 0) {
                ruleName = ruleName.substring(0, ruleName.length() - 3);
                testName = testName.substring(0, testNamesSeparator);
            }
            if (!ruleName.startsWith(FolderPermission.FOLDER_SEPARATOR_STR) && testName.startsWith(FolderPermission.FOLDER_SEPARATOR_STR)) {
                int testPathIndex = testName.lastIndexOf(47);
                testName = testName.substring(testPathIndex + 1);
            }
            if (!ruleName.equals(testName)) {
                return false;
            }
        }
        return (this.mask & fragmentPerm.mask) == fragmentPerm.mask;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FragmentPermission)) {
            return false;
        }
        FragmentPermission p = (FragmentPermission)object;
        return p.mask == this.mask && p.getName().equals(this.getName());
    }
}

