/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components.test;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.JexlException;
import org.apache.commons.jexl2.MapContext;
import org.apache.commons.jexl2.Script;
import org.apache.jetspeed.components.JetspeedBeanDefinitionFilter;
import org.apache.jetspeed.components.SpringComponentManager;
import org.apache.jetspeed.security.JSSubject;

public abstract class AbstractJexlSpringTestServer {
    public static final String SCRIPT_RESULT_LINE_PREFIX = "> ";
    public static final String SCRIPT_RESULT_RETURN_VALUE_SEPARATOR = " -> ";
    protected String baseDir;
    protected SpringComponentManager scm;
    protected JexlContext jexlContext;
    protected boolean exit;

    public void initialize() throws Exception {
        JetspeedBeanDefinitionFilter beanDefinitionFilter = new JetspeedBeanDefinitionFilter(this.getBeanDefinitionFilterCategories());
        String[] bootConfigurations = this.getBootConfigurations();
        String[] configurations = this.getConfigurations();
        this.baseDir = System.getProperty("basedir");
        if (this.baseDir == null || this.baseDir.length() == 0) {
            this.baseDir = System.getProperty("user.dir");
        }
        String appRoot = this.baseDir + "/target/test-classes/webapp";
        this.scm = new SpringComponentManager(beanDefinitionFilter, bootConfigurations, configurations, appRoot, false);
        this.scm.start();
        this.jexlContext = new MapContext(this.getContextVars());
    }

    protected abstract String getBeanDefinitionFilterCategories();

    protected String[] getBootConfigurations() {
        return null;
    }

    protected abstract String[] getConfigurations();

    protected abstract Map<String, Object> getContextVars();

    public void terminate() throws Exception {
        this.scm.stop();
    }

    public String execute(String scriptLine) {
        String resultLine = scriptLine;
        try {
            JexlEngine jexl = new JexlEngine();
            jexl.setSilent(false);
            jexl.setLenient(false);
            Script jexlScript = jexl.createScript(scriptLine);
            Object result = jexlScript.execute(this.jexlContext);
            if (result != null) {
                resultLine = resultLine + SCRIPT_RESULT_RETURN_VALUE_SEPARATOR + result;
            }
        }
        catch (JexlException je) {
            resultLine = je.getCause() != null ? resultLine + SCRIPT_RESULT_RETURN_VALUE_SEPARATOR + je.getCause() : resultLine + SCRIPT_RESULT_RETURN_VALUE_SEPARATOR + (Object)((Object)je);
        }
        catch (Exception e) {
            resultLine = resultLine + SCRIPT_RESULT_RETURN_VALUE_SEPARATOR + e;
        }
        return resultLine;
    }

    public void exit() {
        this.exit = true;
    }

    public boolean isExit() {
        return this.exit;
    }

    protected Subject getUserSubject() {
        return null;
    }

    public Throwable run() {
        try {
            this.initialize();
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            PrintWriter out = new PrintWriter(System.out, true);
            do {
                String scriptLine;
                if ((scriptLine = in.readLine()) != null) {
                    scriptLine = scriptLine.trim();
                    String resultLine = "";
                    if (scriptLine.length() > 0) {
                        Subject userSubject = this.getUserSubject();
                        if (userSubject != null) {
                            final String executeScriptLine = scriptLine;
                            final String[] executeResultLine = new String[]{null};
                            Exception executeException = (Exception)JSSubject.doAsPrivileged((Subject)userSubject, (PrivilegedAction)new PrivilegedAction(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public Object run() {
                                    try {
                                        executeResultLine[0] = AbstractJexlSpringTestServer.this.execute(executeScriptLine);
                                        Object var1_1 = null;
                                        return var1_1;
                                    }
                                    catch (Exception e) {
                                        Exception exception = e;
                                        return exception;
                                    }
                                    finally {
                                        JSSubject.clearSubject();
                                    }
                                }
                            }, null);
                            if (executeException != null) {
                                throw executeException;
                            }
                            resultLine = executeResultLine[0];
                        } else {
                            resultLine = this.execute(scriptLine);
                        }
                    }
                    out.println(SCRIPT_RESULT_LINE_PREFIX + resultLine);
                    continue;
                }
                this.exit();
            } while (!this.isExit());
            this.terminate();
            return null;
        }
        catch (Throwable t) {
            return t;
        }
    }
}

