/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components.test;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import org.apache.jetspeed.components.test.AbstractSpringTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJexlSpringTestCase
extends AbstractSpringTestCase {
    protected static final String SCRIPT_RESULT_LINE_PREFIX = "> ";
    protected static final String SCRIPT_RESULT_RETURN_VALUE_SEPARATOR = " -> ";
    private static final long LOGGING_PUMP_WAIT = 50L;
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String osExecutableExtension;
    private String fileSeparator;
    private File javaExecutablePath;
    private String classPathSeparator;
    private File projectDirectoryPath;
    private Map<String, String> systemProperties;
    private String classPath;

    @Override
    protected void setUp() throws Exception {
        this.osExecutableExtension = System.getProperty("os.name").startsWith("Windows") ? ".exe" : "";
        this.fileSeparator = System.getProperty("file.separator");
        this.javaExecutablePath = new File(System.getProperty("java.home") + this.fileSeparator + "bin" + this.fileSeparator + "java" + this.osExecutableExtension);
        this.classPathSeparator = System.getProperty("path.separator");
        this.projectDirectoryPath = new File(System.getProperty("basedir"));
        this.systemProperties = new HashMap<String, String>();
        for (Map.Entry<Object, Object> systemProperty : System.getProperties().entrySet()) {
            String propertyName = systemProperty.getKey().toString();
            String propertyValue = systemProperty.getValue().toString();
            if (!propertyName.startsWith("org.apache.jetspeed.") && !propertyName.startsWith("java.net.") && !propertyName.equals("basedir")) continue;
            this.systemProperties.put(propertyName, propertyValue);
        }
        StringBuilder classPathBuilder = new StringBuilder();
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        AbstractJexlSpringTestCase.assertTrue((boolean)(loader instanceof URLClassLoader));
        URLClassLoader urlLoader = (URLClassLoader)loader;
        AbstractJexlSpringTestCase.assertNotNull((Object)urlLoader.getURLs());
        for (URL pathURL : urlLoader.getURLs()) {
            String path = new File(pathURL.toURI()).getCanonicalPath();
            if (classPathBuilder.length() > 0) {
                classPathBuilder.append(this.classPathSeparator);
            }
            classPathBuilder.append(path);
        }
        this.classPath = classPathBuilder.toString();
        AbstractJexlSpringTestCase.assertTrue((this.classPath.length() > 0 ? 1 : 0) != 0);
        super.setUp();
    }

    @Override
    protected String[] getConfigurations() {
        return null;
    }

    @Override
    protected String getBeanDefinitionFilterCategories() {
        return null;
    }

    protected String testProgramSystemPropertyValueFilter(String propertyName, int index, String propertyValue) {
        return propertyValue;
    }

    protected Map<String, String> testProgramSystemProperties() {
        return new HashMap<String, String>();
    }

    protected void sleep(TestProgram server, long millis) throws IOException, InterruptedException {
        this.sleep(new TestProgram[]{server}, millis);
    }

    protected void sleep(TestProgram server0, TestProgram server1, long millis) throws IOException, InterruptedException {
        this.sleep(new TestProgram[]{server0, server1}, millis);
    }

    protected void sleep(TestProgram server0, TestProgram server1, TestProgram server2, long millis) throws IOException, InterruptedException {
        this.sleep(new TestProgram[]{server0, server1, server2}, millis);
    }

    protected void sleep(TestProgram[] servers, long millis) throws IOException, InterruptedException {
        long sleep;
        for (long slept = 0L; slept < millis; slept += sleep) {
            for (TestProgram server : servers) {
                server.poll();
            }
            sleep = Math.min(millis - slept, 50L);
            Thread.sleep(sleep);
        }
    }

    protected String getResultValue(String result) {
        if (result == null) {
            return null;
        }
        int resultValueIndex = result.indexOf(SCRIPT_RESULT_RETURN_VALUE_SEPARATOR);
        if (resultValueIndex < 0) {
            return null;
        }
        return result.substring(resultValueIndex + SCRIPT_RESULT_RETURN_VALUE_SEPARATOR.length());
    }

    protected static class TestExecuteThread
    extends Thread {
        private TestProgram server;
        private String scriptLine;
        private String result;
        private Exception exception;

        public TestExecuteThread(TestProgram server, String scriptLine) {
            this.server = server;
            this.scriptLine = scriptLine;
        }

        @Override
        public void run() {
            try {
                this.result = this.server.execute(this.scriptLine);
            }
            catch (Exception e) {
                this.exception = e;
            }
        }

        public String getResult() throws Exception {
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.exception != null) {
                throw this.exception;
            }
            return this.result;
        }
    }

    protected class TestProgram {
        private String name;
        private Class<?> mainClass;
        private int index;
        private Process process;
        private BufferedWriter processInput;
        private BufferedReader processOutput;
        private boolean closed;

        public TestProgram(String name, Class<?> mainClass, int index) {
            this.name = name;
            this.mainClass = mainClass;
            this.index = index;
        }

        public synchronized void start() throws IOException {
            String line;
            String propertyValue;
            String propertyName;
            Assert.assertNull((Object)this.process);
            ProcessBuilder launcher = new ProcessBuilder(new String[0]);
            ArrayList<String> commandAndArgs = new ArrayList<String>();
            commandAndArgs.add(AbstractJexlSpringTestCase.this.javaExecutablePath.getCanonicalPath());
            for (Map.Entry entry : AbstractJexlSpringTestCase.this.systemProperties.entrySet()) {
                propertyName = (String)entry.getKey();
                propertyValue = AbstractJexlSpringTestCase.this.testProgramSystemPropertyValueFilter(propertyName, this.index, (String)entry.getValue());
                commandAndArgs.add("-D" + propertyName + "=" + propertyValue);
            }
            for (Map.Entry<Object, Object> entry : AbstractJexlSpringTestCase.this.testProgramSystemProperties().entrySet()) {
                propertyName = (String)entry.getKey();
                propertyValue = AbstractJexlSpringTestCase.this.testProgramSystemPropertyValueFilter(propertyName, this.index, (String)entry.getValue());
                commandAndArgs.add("-D" + propertyName + "=" + propertyValue);
            }
            commandAndArgs.add("-classpath");
            commandAndArgs.add(AbstractJexlSpringTestCase.this.classPath);
            commandAndArgs.add(this.mainClass.getName());
            AbstractJexlSpringTestCase.this.log.info("Launcher command for " + this.name + ": " + commandAndArgs);
            launcher.command(commandAndArgs);
            launcher.directory(AbstractJexlSpringTestCase.this.projectDirectoryPath);
            launcher.redirectErrorStream(true);
            this.process = launcher.start();
            this.processInput = new BufferedWriter(new OutputStreamWriter(this.process.getOutputStream()));
            this.processOutput = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            while (this.processOutput.ready() && (line = this.processOutput.readLine()) != null) {
                this.logProcessLine(line);
            }
        }

        public synchronized void poll() throws IOException {
            String line;
            Assert.assertNotNull((Object)this.process);
            while (this.processOutput.ready() && (line = this.processOutput.readLine()) != null) {
                this.logProcessLine(line);
            }
        }

        public synchronized String execute(String scriptLine) throws IOException {
            String line;
            this.poll();
            this.processInput.write(scriptLine);
            this.processInput.newLine();
            this.processInput.flush();
            String resultLine = null;
            while ((line = this.processOutput.readLine()) != null) {
                if (!line.startsWith(AbstractJexlSpringTestCase.SCRIPT_RESULT_LINE_PREFIX)) {
                    this.logProcessLine(line);
                    continue;
                }
                resultLine = line;
                break;
            }
            if (resultLine == null) {
                throw new IOException("Unexpected EOF from process output");
            }
            return resultLine;
        }

        public synchronized void close() throws IOException {
            this.processInput.close();
            this.closed = true;
        }

        public synchronized void shutdown(final long millis) throws IOException, InterruptedException {
            String line;
            Assert.assertNotNull((Object)this.process);
            Thread destroyThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(millis);
                        if (TestProgram.this.process != null) {
                            AbstractJexlSpringTestCase.this.log.warn("Forcibly stopping " + TestProgram.this.name);
                            TestProgram.this.process.destroy();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, "DestroyThread");
            destroyThread.setDaemon(true);
            destroyThread.start();
            if (!this.closed) {
                this.processInput.close();
            }
            while ((line = this.processOutput.readLine()) != null) {
                this.logProcessLine(line);
            }
            this.process.waitFor();
            this.processOutput.close();
            this.process = null;
            destroyThread.interrupt();
            destroyThread.join();
        }

        private void logProcessLine(String line) {
            if (line.contains("ERROR") || line.contains("Exception") || line.matches("\\s+at\\s.*")) {
                AbstractJexlSpringTestCase.this.log.error("{" + this.name + "} " + line);
            } else {
                AbstractJexlSpringTestCase.this.log.info("{" + this.name + "} " + line);
            }
        }

        public String getName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

