/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components.test;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.jetspeed.components.JetspeedBeanDefinitionFilter;
import org.apache.jetspeed.components.test.AbstractSpringTestCase;

public abstract class AbstractFilteredSpringTestCase
extends AbstractSpringTestCase {
    @Override
    protected Properties getInitProperties() {
        Properties props = new Properties();
        try {
            InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("jetspeed.properties");
            if (is != null) {
                props.load(is);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return props;
    }

    @Override
    protected String[] getConfigurations() {
        return this.getResourcesFromClasspath("assembly");
    }

    @Override
    protected String[] getBootConfigurations() {
        return new String[]{"assembly/boot/datasource.xml"};
    }

    protected String[] getResourcesFromClasspath(String classPathDirectory) {
        ArrayList<String> result = new ArrayList<String>();
        AssemblyFilter filter = new AssemblyFilter();
        try {
            Enumeration<URL> locations = ((Object)((Object)this)).getClass().getClassLoader().getResources(classPathDirectory);
            while (locations.hasMoreElements()) {
                URL url = locations.nextElement();
                File dir = new File(url.getFile());
                String[] assemblies = dir.list(filter);
                if (assemblies == null) continue;
                for (int ix = 0; ix < assemblies.length; ++ix) {
                    assemblies[ix] = classPathDirectory + "/" + assemblies[ix];
                }
                result.addAll(Arrays.asList(assemblies));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result.toArray(new String[0]);
    }

    @Override
    protected String getBeanDefinitionFilterCategories() {
        return null;
    }

    @Override
    protected String getBeanDefinitionFilterCategoryKey() {
        return "default";
    }

    protected String getFilterFile() {
        return "spring-filter.properties";
    }

    @Override
    protected JetspeedBeanDefinitionFilter getBeanDefinitionFilter() throws IOException {
        String categories = this.getBeanDefinitionFilterCategories();
        if (categories == null) {
            return new JetspeedBeanDefinitionFilter(this.getFilterFile(), this.getBeanDefinitionFilterCategoryKey());
        }
        return new JetspeedBeanDefinitionFilter(categories);
    }

    protected class AssemblyFilter
    implements FilenameFilter {
        protected AssemblyFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            if (name.equals("jetspeed-properties.xml")) {
                return false;
            }
            return name.toLowerCase().endsWith(".xml");
        }
    }
}

