/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.jetspeed.components.ComponentManager;
import org.apache.jetspeed.components.FilteringClassPathXmlApplicationContext;
import org.apache.jetspeed.components.FilteringFileSystemXmlApplicationContext;
import org.apache.jetspeed.components.FilteringXmlWebApplicationContext;
import org.apache.jetspeed.components.JetspeedBeanDefinitionFilter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class SpringComponentManager
implements ComponentManager {
    protected ConfigurableApplicationContext appContext;
    private ConfigurableApplicationContext bootCtx;
    protected ArrayList<ApplicationContext> factories;
    private Map<String, Object> preconfiguredBeans;
    private boolean started = false;

    public SpringComponentManager(JetspeedBeanDefinitionFilter filter, String[] bootConfigs, String[] appConfigs, ServletContext servletContext, String appRoot) {
        this(filter, bootConfigs, appConfigs, servletContext, appRoot, null);
    }

    public SpringComponentManager(JetspeedBeanDefinitionFilter filter, String[] bootConfigs, String[] appConfigs, ServletContext servletContext, String appRoot, Properties initProperties) {
        appRoot = appRoot.replace('\\', '/');
        if (initProperties == null) {
            initProperties = new Properties();
        }
        initProperties.setProperty("applicationRoot", appRoot);
        if (!initProperties.containsKey("jetspeedPropertiesPath")) {
            initProperties.put("jetspeedPropertiesPath", appRoot + "/WEB-INF/conf");
        }
        this.bootCtx = bootConfigs != null && bootConfigs.length > 0 ? new FilteringXmlWebApplicationContext(filter, bootConfigs, initProperties, servletContext) : new FileSystemXmlApplicationContext();
        this.appContext = new FilteringXmlWebApplicationContext(filter, appConfigs, initProperties, servletContext, (ApplicationContext)this.bootCtx);
        this.factories = new ArrayList();
        this.factories.add((ApplicationContext)this.appContext);
        servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)this.appContext);
    }

    public SpringComponentManager(JetspeedBeanDefinitionFilter filter, String[] bootConfigs, String[] appConfigs, String appRoot, boolean fileSystem) {
        this(filter, bootConfigs, appConfigs, appRoot, null, fileSystem);
    }

    public SpringComponentManager(JetspeedBeanDefinitionFilter filter, String[] bootConfigs, String[] appConfigs, String appRoot, Properties initProperties, boolean fileSystem) {
        appRoot = appRoot.replace('\\', '/');
        if (initProperties == null) {
            initProperties = new Properties();
        }
        initProperties.setProperty("applicationRoot", appRoot);
        if (!initProperties.containsKey("jetspeedPropertiesPath")) {
            initProperties.put("jetspeedPropertiesPath", appRoot + "/WEB-INF/conf");
        }
        this.bootCtx = bootConfigs != null && bootConfigs.length > 0 ? (fileSystem ? new FilteringFileSystemXmlApplicationContext(filter, bootConfigs, initProperties) : new FilteringClassPathXmlApplicationContext(filter, bootConfigs, initProperties)) : new FileSystemXmlApplicationContext();
        this.appContext = fileSystem ? new FilteringFileSystemXmlApplicationContext(filter, appConfigs, initProperties, (ApplicationContext)this.bootCtx) : new FilteringClassPathXmlApplicationContext(filter, appConfigs, initProperties, (ApplicationContext)this.bootCtx);
        this.factories = new ArrayList();
        this.factories.add((ApplicationContext)this.appContext);
    }

    public boolean containsComponent(Object componentName) {
        if (componentName instanceof Class) {
            return this.appContext.containsBean(((Class)componentName).getName());
        }
        return this.appContext.containsBean(componentName.toString());
    }

    public Object getComponent(Object componentName) {
        if (componentName instanceof Class) {
            return this.appContext.getBean(((Class)componentName).getName());
        }
        return this.appContext.getBean(componentName.toString());
    }

    public boolean containsComponent(Object containerName, Object componentName) {
        return this.containsComponent(componentName);
    }

    public Object getComponent(Object containerName, Object componentName) {
        return this.getComponent(componentName);
    }

    public Object getContainer(String containerName) {
        return this.appContext;
    }

    public Object getRootContainer() {
        return this.appContext;
    }

    public Collection getContainers() {
        return this.factories;
    }

    public void stop() {
        if (this.started) {
            this.appContext.stop();
            this.appContext.close();
            this.bootCtx.stop();
            this.bootCtx.close();
            this.started = false;
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.appContext;
    }

    public void addComponent(String name, Object bean) {
        if (this.preconfiguredBeans == null) {
            this.preconfiguredBeans = new HashMap<String, Object>();
        }
        this.preconfiguredBeans.put(name, bean);
        if (this.started) {
            this.bootCtx.getBeanFactory().registerSingleton(name, bean);
        }
    }

    public void start() {
        this.bootCtx.refresh();
        if (this.preconfiguredBeans != null) {
            for (Map.Entry<String, Object> entry : this.preconfiguredBeans.entrySet()) {
                this.bootCtx.getBeanFactory().registerSingleton(entry.getKey().toString(), entry.getValue());
            }
        }
        this.bootCtx.start();
        this.appContext.refresh();
        this.appContext.start();
        this.started = true;
    }

    public <T> T lookupComponent(String componentName) {
        return (T)(this.appContext == null ? null : this.appContext.getBean(componentName));
    }

    public <T> T lookupComponent(Class componentClass) {
        return (T)(this.appContext == null ? null : this.appContext.getBean(componentClass.getName()));
    }
}

