/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class JetspeedBeanDefinitionFilterMatcher {
    private Set<String> categories;

    public JetspeedBeanDefinitionFilterMatcher(Set<String> categories) {
        this.categories = categories;
    }

    public boolean match(String categoriesMatchExpression) {
        List<String> expression = this.parse(categoriesMatchExpression);
        if (expression != null) {
            return this.evaluate(expression, 0, expression.size());
        }
        return false;
    }

    private List<String> parse(String expression) {
        ArrayList<String> parsedExpression = new ArrayList<String>();
        int parseIndex = 0;
        int parseLimit = expression.length();
        while (true) {
            if (parseIndex < parseLimit && Character.isWhitespace(expression.charAt(parseIndex))) {
                ++parseIndex;
                continue;
            }
            if (parseIndex < parseLimit) {
                char expressionChar;
                if (Character.isLetter(expressionChar = expression.charAt(parseIndex++))) {
                    int parseIdentifierIndex = parseIndex - 1;
                    while (parseIndex < parseLimit && Character.isLetterOrDigit(expression.charAt(parseIndex))) {
                        ++parseIndex;
                    }
                    parsedExpression.add(expression.substring(parseIdentifierIndex, parseIndex));
                } else if (expressionChar == '(') {
                    parsedExpression.add("(");
                } else if (expressionChar == ')') {
                    parsedExpression.add(")");
                } else {
                    throw new RuntimeException("Unable to parse expression: \"" + expression + "\" at position " + (parseIndex - 1));
                }
            }
            if (parseIndex >= parseLimit) break;
        }
        return parsedExpression;
    }

    private boolean evaluate(List<String> expression, int startIndex, int endIndex) {
        int evaluateIndex = startIndex;
        if (evaluateIndex < endIndex) {
            int[] termEndIndex = new int[1];
            boolean left = this.evaluateTerm(expression, evaluateIndex, endIndex, termEndIndex);
            evaluateIndex = termEndIndex[0];
            while (evaluateIndex < endIndex) {
                boolean right;
                String operator;
                String expressionElement = expression.get(evaluateIndex);
                if (expressionElement.equalsIgnoreCase("AND") || expressionElement.equalsIgnoreCase("OR")) {
                    operator = expressionElement;
                    if (++evaluateIndex >= endIndex) {
                        throw new RuntimeException("Unable to parse expression: " + expression);
                    }
                } else {
                    throw new RuntimeException("Unable to parse expression: " + expression);
                }
                expressionElement = expression.get(evaluateIndex);
                if (operator.equalsIgnoreCase("AND")) {
                    right = this.evaluateTerm(expression, evaluateIndex, endIndex, termEndIndex);
                    evaluateIndex = termEndIndex[0];
                    left = left && right;
                    continue;
                }
                if (!operator.equalsIgnoreCase("OR")) continue;
                right = this.evaluate(expression, evaluateIndex, endIndex);
                evaluateIndex = endIndex;
                left = left || right;
            }
            return left;
        }
        throw new RuntimeException("Unable to parse expression: " + expression);
    }

    private boolean evaluateTerm(List<String> expression, int startIndex, int endIndex, int[] termEndIndex) {
        int evaluateIndex = startIndex;
        if (evaluateIndex < endIndex) {
            boolean term;
            boolean invertTerm = false;
            String expressionElement = expression.get(evaluateIndex);
            while (expression.get(evaluateIndex).equalsIgnoreCase("NOT")) {
                boolean bl = invertTerm = !invertTerm;
                if (++evaluateIndex < endIndex) {
                    expressionElement = expression.get(evaluateIndex);
                    continue;
                }
                throw new RuntimeException("Unable to parse expression: " + expression);
            }
            if (expressionElement.equals("(")) {
                int closeIndex = JetspeedBeanDefinitionFilterMatcher.indexOfClose(expression, evaluateIndex, endIndex);
                term = this.evaluate(expression, evaluateIndex + 1, closeIndex);
                evaluateIndex = closeIndex + 1;
            } else if (!(expressionElement.equalsIgnoreCase("AND") || expressionElement.equalsIgnoreCase("OR") || expressionElement.equalsIgnoreCase("NOT") || expressionElement.equalsIgnoreCase(")"))) {
                term = this.categories.contains(expressionElement);
            } else {
                throw new RuntimeException("Unable to parse expression: " + expression);
            }
            termEndIndex[0] = ++evaluateIndex;
            if (invertTerm) {
                term = !term;
            }
            return term;
        }
        throw new RuntimeException("Unable to parse expression: " + expression);
    }

    private static int indexOfClose(List<String> expression, int openIndex, int endIndex) {
        int nestedDepth = 1;
        for (int parseIndex = openIndex + 1; parseIndex < endIndex; ++parseIndex) {
            if (expression.get(parseIndex).equals(")")) {
                if (--nestedDepth != 0) continue;
                return parseIndex;
            }
            if (!expression.get(parseIndex).equals("(")) continue;
            ++nestedDepth;
        }
        throw new RuntimeException("Unmatched parens found in expression: " + expression);
    }
}

