/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components;

import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.util.MethodInvoker;

public class ApplicationEventMethodsInvoker
implements ApplicationListener,
ApplicationContextAware {
    private static Logger log = LoggerFactory.getLogger(ApplicationEventMethodsInvoker.class);
    private AbstractApplicationContext ctx;
    private Map<Class<? extends ApplicationEvent>, List<MethodInvoker>> eventTypeMethodInvokersMap;
    private boolean autoPrepareInvoker = true;

    public ApplicationEventMethodsInvoker(Map<Class<? extends ApplicationEvent>, List<MethodInvoker>> eventTypeMethodInvokersMap) {
        this.eventTypeMethodInvokersMap = eventTypeMethodInvokersMap;
    }

    public void setAutoPrepareInvoker(boolean autoPrepareInvoker) {
        this.autoPrepareInvoker = autoPrepareInvoker;
    }

    public boolean getAutoPrepareInvoker() {
        return this.autoPrepareInvoker;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext instanceof AbstractApplicationContext) {
            this.ctx = (AbstractApplicationContext)applicationContext;
            this.ctx.addApplicationListener((ApplicationListener)this);
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        boolean doIt = false;
        for (AbstractApplicationContext ac = this.ctx; ac != null && !doIt; ac = ac.getParent()) {
            if (event.getSource() != ac) continue;
            doIt = true;
        }
        if (!doIt) {
            return;
        }
        List<MethodInvoker> invokers = this.findMethodInvokersByEvent(event);
        if (invokers != null && !invokers.isEmpty()) {
            for (MethodInvoker invoker : invokers) {
                try {
                    if (this.autoPrepareInvoker && !invoker.isPrepared()) {
                        invoker.prepare();
                    }
                    invoker.invoke();
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.error("Failed to invoke application event callback invoker. " + e, (Throwable)e);
                        continue;
                    }
                    log.error("Failed to invoke application event callback invoker. " + e);
                }
            }
        }
    }

    private List<MethodInvoker> findMethodInvokersByEvent(ApplicationEvent event) {
        if (this.eventTypeMethodInvokersMap != null && event != null) {
            for (Map.Entry<Class<? extends ApplicationEvent>, List<MethodInvoker>> entry : this.eventTypeMethodInvokersMap.entrySet()) {
                String className = entry.getKey().getName();
                try {
                    Class<?> eventClass = Class.forName(className);
                    if (!eventClass.isAssignableFrom(event.getClass())) continue;
                    return entry.getValue();
                }
                catch (Exception e) {
                    log.error("Failed to load application event for given class: " + className);
                }
            }
        }
        return null;
    }
}

