/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.cache.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Statistics;
import org.apache.jetspeed.cache.CacheMonitorState;
import org.apache.jetspeed.cache.JetspeedCacheMonitor;
import org.apache.jetspeed.cache.impl.CacheMonitorStateImpl;

public class JetspeedCacheMonitorImpl
implements JetspeedCacheMonitor {
    private CacheManager cacheManager;
    private boolean calculateObjectCount = false;
    private Map<String, CalculatedState> calculatedStates = Collections.synchronizedMap(new HashMap());

    public JetspeedCacheMonitorImpl(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public List<CacheMonitorState> snapshotStatistics() {
        return this.snapshotAndCalculateStatistics(false);
    }

    public CacheMonitorState snapshotStatistics(String cacheName) {
        return this.snapshotAndCalculateStatistics(cacheName, false);
    }

    public List<CacheMonitorState> calculateStatistics() {
        return this.snapshotAndCalculateStatistics(true);
    }

    public CacheMonitorState calculateStatistics(String cacheName) {
        return this.snapshotAndCalculateStatistics(cacheName, true);
    }

    public void resetStatistics() {
        String[] names;
        for (String name : names = this.cacheManager.getCacheNames()) {
            this.resetStatistics(name);
        }
    }

    public void resetStatistics(String cacheName) {
        Cache cache = this.cacheManager.getCache(cacheName);
        cache.clearStatistics();
        this.calculatedStates.remove(cacheName);
    }

    protected List<CacheMonitorState> snapshotAndCalculateStatistics(boolean calculate) {
        String[] names;
        LinkedList<CacheMonitorState> states = new LinkedList<CacheMonitorState>();
        for (String name : names = this.cacheManager.getCacheNames()) {
            states.add(this.snapshotAndCalculateStatistics(name, calculate));
        }
        return states;
    }

    protected CacheMonitorState snapshotAndCalculateStatistics(String name, boolean calculate) {
        Cache cache = this.cacheManager.getCache(name);
        CacheMonitorStateImpl state = new CacheMonitorStateImpl(name);
        Statistics statistics = cache.getStatistics();
        state.setMemoryStoreSize(cache.getMemoryStoreSize());
        if (calculate) {
            state.setInMemorySize(cache.calculateInMemorySize());
            if (this.calculateObjectCount) {
                state.setObjectCount(statistics.getObjectCount());
            } else {
                state.setObjectCount(0L);
            }
            this.calculatedStates.put(name, new CalculatedState(state.getInMemorySize(), state.getObjectCount()));
        } else {
            CalculatedState cs = this.calculatedStates.get(name);
            if (cs == null) {
                state.setInMemorySize(0L);
                state.setObjectCount(0L);
            } else {
                state.setInMemorySize(cs.inMemorySize);
                state.setObjectCount(cs.objectCount);
            }
        }
        state.setSize(cache.getSize());
        state.setDiskStoreSize(cache.getDiskStoreSize());
        state.setAverageGetTime(statistics.getAverageGetTime());
        state.setCacheHits(statistics.getCacheHits());
        state.setCacheMisses(statistics.getCacheMisses());
        state.setEvictionCount(statistics.getEvictionCount());
        state.setInMemoryHits(statistics.getInMemoryHits());
        state.setOnDiskHits(statistics.getOnDiskHits());
        state.setMaxElementsInMemory(cache.getCacheConfiguration().getMaxElementsInMemory());
        state.setMaxElementsOnDisk(cache.getCacheConfiguration().getMaxElementsOnDisk());
        state.setTimeToIdle(cache.getCacheConfiguration().getTimeToIdleSeconds());
        state.setTimeToLive(cache.getCacheConfiguration().getTimeToLiveSeconds());
        return state;
    }

    protected CacheManager getCacheManager() {
        return this.cacheManager;
    }

    class CalculatedState
    implements Serializable {
        private long inMemorySize;
        private long objectCount;

        CalculatedState(long inMemorySize, long objectCount) {
            this.inMemorySize = inMemorySize;
            this.objectCount = objectCount;
        }
    }
}

