/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.cache.impl;

import java.util.List;
import org.apache.jetspeed.cache.ContentCacheKey;
import org.apache.jetspeed.cache.ContentCacheKeyGenerator;
import org.apache.jetspeed.cache.impl.JetspeedContentCacheKey;
import org.apache.jetspeed.request.RequestContext;

public class JetspeedCacheKeyGenerator
implements ContentCacheKeyGenerator {
    private List segments;
    private boolean cacheBySessionId = true;

    public JetspeedCacheKeyGenerator(List segments) {
        this.segments = segments;
        this.cacheBySessionId = segments.contains("sessionid");
    }

    public ContentCacheKey createCacheKey(RequestContext context, String windowId) {
        JetspeedContentCacheKey key = new JetspeedContentCacheKey(this.segments, context, windowId);
        return key;
    }

    public ContentCacheKey createUserCacheKey(String username, String pipeline, String windowId) {
        JetspeedContentCacheKey key = new JetspeedContentCacheKey();
        key.createFromUser(username, pipeline, windowId);
        return key;
    }

    public ContentCacheKey createSessionCacheKey(String sessionId, String pipeline, String windowId) {
        JetspeedContentCacheKey key = new JetspeedContentCacheKey();
        key.createFromSession(sessionId, pipeline, windowId);
        return key;
    }

    public boolean isCacheBySessionId() {
        return this.cacheBySessionId;
    }

    public boolean isCacheByUsername() {
        return !this.cacheBySessionId;
    }
}

