/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.jetspeed.components.ComponentManager;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class SpringComponentManager
implements ComponentManager {
    protected ConfigurableApplicationContext appContext;
    private ConfigurableApplicationContext bootCtx;
    protected ArrayList factories;
    private Map preconfiguredBeans;
    private boolean started = false;

    public SpringComponentManager(String[] bootConfigs, String[] appConfigs, ServletContext servletContext, String appRoot) {
        File appRootDir = new File(appRoot);
        System.setProperty("applicationRoot", appRootDir.getAbsolutePath());
        if (bootConfigs != null && bootConfigs.length > 0) {
            this.bootCtx = new XmlWebApplicationContext();
            ((XmlWebApplicationContext)this.bootCtx).setServletContext(servletContext);
            ((XmlWebApplicationContext)this.bootCtx).setConfigLocations(bootConfigs);
        } else {
            this.bootCtx = new GenericApplicationContext();
        }
        this.appContext = new XmlWebApplicationContext();
        ((XmlWebApplicationContext)this.appContext).setParent((ApplicationContext)this.bootCtx);
        ((XmlWebApplicationContext)this.appContext).setServletContext(servletContext);
        ((XmlWebApplicationContext)this.appContext).setConfigLocations(appConfigs);
        this.factories = new ArrayList();
        this.factories.add(this.appContext);
        servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)this.appContext);
    }

    public SpringComponentManager(String[] bootConfigs, String[] appConfigs, ServletContext servletContext, String appRoot, Map preconfiguredBeans) {
        this(bootConfigs, appConfigs, servletContext, appRoot);
        this.preconfiguredBeans = preconfiguredBeans;
    }

    public SpringComponentManager(String[] bootConfigs, String[] appConfigs, String appRoot) {
        PropertyPlaceholderConfigurer ppc = new PropertyPlaceholderConfigurer();
        Properties p = new Properties();
        ppc.setProperties(p);
        if (bootConfigs != null && bootConfigs.length > 0) {
            this.bootCtx = new FileSystemXmlApplicationContext(bootConfigs, false);
            this.bootCtx.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)ppc);
            this.bootCtx.refresh();
        } else {
            this.bootCtx = new GenericApplicationContext();
        }
        this.appContext = new FileSystemXmlApplicationContext(appConfigs, false, (ApplicationContext)this.bootCtx);
        this.appContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)ppc);
        this.appContext.refresh();
        this.factories = new ArrayList();
        this.factories.add(this.appContext);
    }

    public Object getComponent(Object componentName) {
        if (componentName instanceof Class) {
            return this.appContext.getBean(((Class)componentName).getName());
        }
        return this.appContext.getBean(componentName.toString());
    }

    public Object getComponent(Object containerName, Object componentName) {
        return this.getComponent(componentName);
    }

    public Object getContainer(String containerName) {
        return this.appContext;
    }

    public Object getRootContainer() {
        return this.appContext;
    }

    public Collection getContainers() {
        return this.factories;
    }

    public void stop() {
        this.appContext.close();
        this.bootCtx.close();
        this.started = false;
    }

    public ApplicationContext getApplicationContext() {
        return this.appContext;
    }

    public void addComponent(String name, Object bean) {
        if (this.preconfiguredBeans == null) {
            this.preconfiguredBeans = new HashMap();
        }
        this.preconfiguredBeans.put(name, bean);
        if (this.started) {
            this.bootCtx.getBeanFactory().registerSingleton(name, bean);
        }
    }

    public void start() {
        this.bootCtx.refresh();
        if (this.preconfiguredBeans != null) {
            Iterator itr = this.preconfiguredBeans.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                this.bootCtx.getBeanFactory().registerSingleton(entry.getKey().toString(), entry.getValue());
            }
        }
        this.appContext.refresh();
        this.started = true;
    }
}

