/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.cache.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class EhCacheConfigResource
extends AbstractResource
implements InitializingBean {
    protected static Log log = LogFactory.getLog((Class)EhCacheConfigResource.class);
    public static final String EHCACHE_CONFIG_RESOURCE_PROP_NAME = "org.apache.jetspeed.ehcache.config.resource";
    public static final String EHCACHE_CONFIG_RESOURCE_DEFAULT = "ehcache.xml";
    public static final String EHCACHE_CONFIG_RESOURCE_DISTRIBUTED_CACHE = "distributed-ehcache.xml";
    public static final String EHCACHE_GROUP_ADDRESS_PROP_NAME = "org.apache.jetspeed.ehcache.group.address";
    public static final String EHCACHE_GROUP_ADDRESS_DEFAULT = "230.0.0.1";
    public static final String EHCACHE_GROUP_PORT_PROP_NAME = "org.apache.jetspeed.ehcache.group.port";
    public static final String EHCACHE_GROUP_PORT_DEFAULT = "4446";
    public static final String EHCACHE_GROUP_TTL_PROP_NAME = "org.apache.jetspeed.ehcache.group.ttl";
    public static final String EHCACHE_GROUP_TTL_DEFAULT = "1";
    public static final String EHCACHE_GROUP_TTL_TEST_DEFAULT = "0";
    public static final String EHCACHE_HOSTNAME_PROP_NAME = "org.apache.jetspeed.ehcache.hostname";
    public static final String EHCACHE_HOSTNAME_DEFAULT = "";
    public static final String EHCACHE_HOSTNAME_TEST_DEFAULT = "localhost";
    public static final String EHCACHE_PORT_PROP_NAME = "org.apache.jetspeed.ehcache.port";
    public static final String EHCACHE_PORT_DEFAULT = "40001";
    public static final String EHCACHE_PAGE_MANAGER_MAX_ELEMENTS_LEGACY_PROP_NAME = "db.page.manager.cache.size";
    public static final String EHCACHE_PAGE_MANAGER_MAX_ELEMENTS_PROP_NAME = "org.apache.jetspeed.ehcache.pagemanager.maxelements";
    public static final String EHCACHE_PAGE_MANAGER_MAX_ELEMENTS_DEFAULT = "128";
    public static final String EHCACHE_PAGE_MANAGER_ELEMENT_TTL_LEGACY_PROP_NAME = "db.page.manager.cache.expire";
    public static final String EHCACHE_PAGE_MANAGER_ELEMENT_TTL_PROP_NAME = "org.apache.jetspeed.ehcache.pagemanager.element.ttl";
    public static final String EHCACHE_PAGE_MANAGER_ELEMENT_TTL_DEFAULT = "150";
    private static EhCacheConfigResource instance;
    private PropertiesConfiguration configuration;
    private String defaultConfigResource;
    private boolean test;
    private String defaultGroupAddress;
    private String defaultGroupPort;
    private String defaultGroupTTL;
    private String defaultHostname;
    private String defaultPort;
    private String defaultPageManagerMaxElements;
    private String defaultPageManagerElementTTL;
    private ClassPathResource classPathResource;

    public static EhCacheConfigResource getInstance(String defaultConfigResource, boolean test) {
        if (instance == null) {
            instance = new EhCacheConfigResource();
            instance.setDefaultConfigResource(defaultConfigResource);
            instance.setTest(test);
            instance.afterPropertiesSet();
        }
        return instance;
    }

    public void afterPropertiesSet() {
        if (this.configuration != null) {
            if (this.configuration.getString(EHCACHE_CONFIG_RESOURCE_PROP_NAME) != null) {
                this.defaultConfigResource = this.configuration.getString(EHCACHE_CONFIG_RESOURCE_PROP_NAME);
            }
            if (this.configuration.getString(EHCACHE_GROUP_ADDRESS_PROP_NAME) != null) {
                this.defaultGroupAddress = this.configuration.getString(EHCACHE_GROUP_ADDRESS_PROP_NAME);
            }
            if (this.configuration.getString(EHCACHE_GROUP_PORT_PROP_NAME) != null) {
                this.defaultGroupPort = this.configuration.getString(EHCACHE_GROUP_PORT_PROP_NAME);
            }
            if (this.configuration.getString(EHCACHE_GROUP_TTL_PROP_NAME) != null) {
                this.defaultGroupTTL = this.configuration.getString(EHCACHE_GROUP_TTL_PROP_NAME);
            }
            if (this.configuration.getString(EHCACHE_HOSTNAME_PROP_NAME) != null) {
                this.defaultHostname = this.configuration.getString(EHCACHE_HOSTNAME_PROP_NAME);
            }
            if (this.configuration.getString(EHCACHE_PORT_PROP_NAME) != null) {
                this.defaultPort = this.configuration.getString(EHCACHE_PORT_PROP_NAME);
            }
            if (this.configuration.getString(EHCACHE_PAGE_MANAGER_MAX_ELEMENTS_PROP_NAME) != null) {
                this.defaultPageManagerMaxElements = this.configuration.getString(EHCACHE_PAGE_MANAGER_MAX_ELEMENTS_PROP_NAME);
            }
            if (this.configuration.getString(EHCACHE_PAGE_MANAGER_ELEMENT_TTL_PROP_NAME) != null) {
                this.defaultPageManagerElementTTL = this.configuration.getString(EHCACHE_PAGE_MANAGER_ELEMENT_TTL_PROP_NAME);
            }
        }
        if (System.getProperty(EHCACHE_CONFIG_RESOURCE_PROP_NAME) == null) {
            System.setProperty(EHCACHE_CONFIG_RESOURCE_PROP_NAME, this.defaultConfigResource != null ? this.defaultConfigResource : EHCACHE_CONFIG_RESOURCE_DEFAULT);
        }
        if (System.getProperty(EHCACHE_GROUP_ADDRESS_PROP_NAME) == null) {
            System.setProperty(EHCACHE_GROUP_ADDRESS_PROP_NAME, this.defaultGroupAddress != null ? this.defaultGroupAddress : EHCACHE_GROUP_ADDRESS_DEFAULT);
        }
        if (System.getProperty(EHCACHE_GROUP_PORT_PROP_NAME) == null) {
            System.setProperty(EHCACHE_GROUP_PORT_PROP_NAME, this.defaultGroupPort != null ? this.defaultGroupPort : EHCACHE_GROUP_PORT_DEFAULT);
        }
        if (System.getProperty(EHCACHE_GROUP_TTL_PROP_NAME) == null) {
            System.setProperty(EHCACHE_GROUP_TTL_PROP_NAME, this.defaultGroupTTL != null ? this.defaultGroupTTL : (this.test ? EHCACHE_GROUP_TTL_TEST_DEFAULT : EHCACHE_GROUP_TTL_DEFAULT));
        }
        if (System.getProperty(EHCACHE_HOSTNAME_PROP_NAME) == null) {
            System.setProperty(EHCACHE_HOSTNAME_PROP_NAME, this.defaultHostname != null ? this.defaultHostname : (this.test ? EHCACHE_HOSTNAME_TEST_DEFAULT : EHCACHE_HOSTNAME_DEFAULT));
        }
        if (System.getProperty(EHCACHE_PORT_PROP_NAME) == null) {
            System.setProperty(EHCACHE_PORT_PROP_NAME, this.defaultPort != null ? this.defaultPort : EHCACHE_PORT_DEFAULT);
        }
        if (System.getProperty(EHCACHE_PAGE_MANAGER_MAX_ELEMENTS_PROP_NAME) == null) {
            String pageManagerMaxElements;
            String string = pageManagerMaxElements = this.defaultPageManagerMaxElements != null ? this.defaultPageManagerMaxElements : System.getProperty(EHCACHE_PAGE_MANAGER_MAX_ELEMENTS_LEGACY_PROP_NAME, EHCACHE_PAGE_MANAGER_MAX_ELEMENTS_DEFAULT);
            if (pageManagerMaxElements != null && Integer.parseInt(pageManagerMaxElements) < 0) {
                pageManagerMaxElements = EHCACHE_PAGE_MANAGER_MAX_ELEMENTS_DEFAULT;
            }
            System.setProperty(EHCACHE_PAGE_MANAGER_MAX_ELEMENTS_PROP_NAME, pageManagerMaxElements);
        }
        if (System.getProperty(EHCACHE_PAGE_MANAGER_ELEMENT_TTL_PROP_NAME) == null) {
            String pageManagerElementTTL;
            String string = pageManagerElementTTL = this.defaultPageManagerElementTTL != null ? this.defaultPageManagerElementTTL : System.getProperty(EHCACHE_PAGE_MANAGER_ELEMENT_TTL_LEGACY_PROP_NAME, EHCACHE_PAGE_MANAGER_ELEMENT_TTL_DEFAULT);
            if (pageManagerElementTTL != null && Integer.parseInt(pageManagerElementTTL) < 0) {
                pageManagerElementTTL = EHCACHE_PAGE_MANAGER_ELEMENT_TTL_DEFAULT;
            }
            System.setProperty(EHCACHE_PAGE_MANAGER_ELEMENT_TTL_PROP_NAME, pageManagerElementTTL);
        }
        String configResource = System.getProperty(EHCACHE_CONFIG_RESOURCE_PROP_NAME);
        log.info((Object)("Configured with resource: " + configResource));
        this.classPathResource = new ClassPathResource(configResource);
    }

    public Resource createRelative(String relativePath) throws IOException {
        return this.classPathResource.createRelative(relativePath);
    }

    public File getFile() throws IOException {
        return this.classPathResource.getFile();
    }

    public String getFilename() throws IllegalStateException {
        return this.classPathResource.getFilename();
    }

    public URL getURL() throws IOException {
        return this.classPathResource.getURL();
    }

    public String getDescription() {
        return this.classPathResource.getDescription();
    }

    public InputStream getInputStream() throws IOException {
        return this.classPathResource.getInputStream();
    }

    public void setConfiguration(PropertiesConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setDefaultConfigResource(String defaultConfigResource) {
        this.defaultConfigResource = defaultConfigResource;
    }

    public void setTest(boolean test) {
        this.test = test;
    }

    public void setDefaultGroupAddress(String defaultGroupAddress) {
        this.defaultGroupAddress = defaultGroupAddress;
    }

    public void setDefaultGroupPort(String defaultGroupPort) {
        this.defaultGroupPort = defaultGroupPort;
    }

    public void setDefaultGroupTTL(String defaultGroupTTL) {
        this.defaultGroupTTL = defaultGroupTTL;
    }

    public void setDefaultHostname(String defaultHostname) {
        this.defaultHostname = defaultHostname;
    }

    public void setDefaultPort(String defaultPort) {
        this.defaultPort = defaultPort;
    }

    public void setDefaultPageManagerMaxElements(String defaultPageManagerMaxElements) {
        this.defaultPageManagerMaxElements = defaultPageManagerMaxElements;
    }

    public void setDefaultPageManagerElementTTL(String defaultPageManagerElementTTL) {
        this.defaultPageManagerElementTTL = defaultPageManagerElementTTL;
    }
}

