/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.capabilities.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.jetspeed.capabilities.Capability;
import org.apache.jetspeed.capabilities.MediaType;
import org.apache.jetspeed.capabilities.MimeType;

public class MediaTypeImpl
implements MediaType {
    protected String characterSet;
    private Collection<Capability> capabilities;
    private Collection<MimeType> mimetypes;
    private int mediatypeId;
    private String title;
    private String description;
    private String name;

    public boolean equals(Object object) {
        if (!(object instanceof MediaType)) {
            return false;
        }
        MediaTypeImpl obj = (MediaTypeImpl)object;
        if (this.name != null ? !this.name.equals(obj.name) : obj.name != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(obj.description) : obj.description != null) {
            return false;
        }
        if (this.characterSet != null ? !this.characterSet.equals(obj.characterSet) : obj.characterSet != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(obj.title) : obj.title != null) {
            return false;
        }
        if (this.mimetypes != null ? !CollectionUtils.isEqualCollection(this.mimetypes, obj.mimetypes) : obj.mimetypes != null) {
            return false;
        }
        return !(this.capabilities != null ? !CollectionUtils.isEqualCollection(this.capabilities, obj.capabilities) : obj.capabilities != null);
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public void setCharacterSet(String charSet) {
        this.characterSet = charSet;
    }

    public Collection<Capability> getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(Collection<Capability> capabilities) {
        this.capabilities = capabilities;
    }

    public Collection<MimeType> getMimetypes() {
        return this.mimetypes;
    }

    public void setMimetypes(Collection<MimeType> mimetypes) {
        this.mimetypes = mimetypes;
    }

    public void addMimetype(MimeType mimeType) {
        if (this.mimetypes == null) {
            this.mimetypes = new ArrayList<MimeType>();
        }
        if (!this.mimetypes.contains(mimeType.getName())) {
            this.mimetypes.add(mimeType);
        }
    }

    public void addCapability(Capability capability) {
        if (this.capabilities == null) {
            this.capabilities = new ArrayList<Capability>();
        }
        if (!this.capabilities.contains(capability.getName())) {
            this.capabilities.add(capability);
        }
    }

    public void removeMimetype(String name) {
        this.mimetypes.remove(name);
    }

    public void setMediatypeId(int id) {
        this.mediatypeId = id;
    }

    public int getMediatypeId() {
        return this.mediatypeId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }
}

