/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.serializer;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jetspeed.capabilities.Capabilities;
import org.apache.jetspeed.capabilities.Capability;
import org.apache.jetspeed.capabilities.Client;
import org.apache.jetspeed.capabilities.MediaType;
import org.apache.jetspeed.capabilities.MimeType;
import org.apache.jetspeed.serializer.AbstractJetspeedComponentSerializer;
import org.apache.jetspeed.serializer.SerializerException;
import org.apache.jetspeed.serializer.objects.JSCapabilities;
import org.apache.jetspeed.serializer.objects.JSCapability;
import org.apache.jetspeed.serializer.objects.JSClient;
import org.apache.jetspeed.serializer.objects.JSClients;
import org.apache.jetspeed.serializer.objects.JSMediaType;
import org.apache.jetspeed.serializer.objects.JSMediaTypes;
import org.apache.jetspeed.serializer.objects.JSMimeType;
import org.apache.jetspeed.serializer.objects.JSMimeTypes;
import org.apache.jetspeed.serializer.objects.JSSnapshot;
import org.slf4j.Logger;

public class JetspeedCapabilitiesSerializer
extends AbstractJetspeedComponentSerializer {
    protected Capabilities caps;

    public JetspeedCapabilitiesSerializer(Capabilities caps) {
        this.caps = caps;
    }

    protected void processImport(JSSnapshot snapshot, Map settings, Logger log) throws SerializerException {
        if (JetspeedCapabilitiesSerializer.isSettingSet((Map)settings, (String)"process_capabilities")) {
            log.info("creating clients, mediatypes and mimetypes");
            log.debug("importCapabilitiesInfrastructure - processing");
            this.recreateCapabilities(snapshot, settings, log);
            this.recreateMimeTypes(snapshot, settings, log);
            this.recreateMediaTypes(snapshot, settings, log);
            this.recreateClients(snapshot, settings, log);
            log.debug("importCapabilitiesInfrastructure - processing done");
        }
    }

    protected void processExport(JSSnapshot snapshot, Map settings, Logger log) throws SerializerException {
        if (JetspeedCapabilitiesSerializer.isSettingSet((Map)settings, (String)"process_capabilities")) {
            log.debug("collecting clients, mediatypes and mimetypes");
            Refs refs = new Refs();
            this.exportClients(refs, snapshot, settings, log);
            this.exportMediaTypes(refs, snapshot, settings, log);
        }
    }

    protected void deleteData(Map settings, Logger log) throws SerializerException {
        if (JetspeedCapabilitiesSerializer.isSettingSet((Map)settings, (String)"process_capabilities")) {
            log.debug("deleting clients, mediatypes and mimetypes");
            try {
                Iterator _it = this.caps.getMediaTypes();
                while (_it != null && _it.hasNext()) {
                    this.caps.deleteMediaType((MediaType)_it.next());
                }
                _it = this.caps.getClients();
                while (_it != null && _it.hasNext()) {
                    this.caps.deleteClient((Client)_it.next());
                }
                _it = this.caps.getCapabilities();
                while (_it != null && _it.hasNext()) {
                    this.caps.deleteCapability((Capability)_it.next());
                }
                _it = this.caps.getMimeTypes();
                while (_it != null && _it.hasNext()) {
                    this.caps.deleteMimeType((MimeType)_it.next());
                }
            }
            catch (Exception e) {
                throw new SerializerException((Throwable)e);
            }
        }
    }

    private void recreateCapabilities(JSSnapshot snapshot, Map settings, Logger log) throws SerializerException {
        log.debug("recreateCapabilities - processing");
        JSCapabilities capabilities = snapshot.getCapabilities();
        if (capabilities != null && capabilities.size() > 0) {
            for (JSCapability _c : capabilities) {
                try {
                    Capability capability = this.caps.createCapability(_c.getName());
                    if (!JetspeedCapabilitiesSerializer.isSettingSet((Map)settings, (String)"overwrite_existing") && capability.getCapabilityId() != 0) continue;
                    this.caps.storeCapability(capability);
                }
                catch (Exception e) {
                    throw new SerializerException(SerializerException.CREATE_OBJECT_FAILED.create((Object)"org.apache.jetspeed.capabilities.Capabilities", (Object)e.getLocalizedMessage()));
                }
            }
        } else {
            log.debug("NO CAPABILITES?????");
        }
        log.debug("recreateCapabilities - done");
    }

    private void recreateMimeTypes(JSSnapshot snapshot, Map settings, Logger log) throws SerializerException {
        log.debug("recreateMimeTypes - processing");
        JSMimeTypes mimeTypes = snapshot.getMimeTypes();
        if (mimeTypes != null && mimeTypes.size() > 0) {
            for (JSMimeType _c : mimeTypes) {
                try {
                    MimeType mimeType = this.caps.createMimeType(_c.getName());
                    if (!JetspeedCapabilitiesSerializer.isSettingSet((Map)settings, (String)"overwrite_existing") && mimeType.getMimetypeId() != 0) continue;
                    this.caps.storeMimeType(mimeType);
                }
                catch (Exception e) {
                    throw new SerializerException(SerializerException.CREATE_OBJECT_FAILED.create((Object)"org.apache.jetspeed.capabilities.MimeType", (Object)e.getLocalizedMessage()));
                }
            }
        } else {
            log.debug("NO MIME TYPES?????");
        }
        log.debug("recreateMimeTypes - done");
    }

    private void recreateMediaTypes(JSSnapshot snapshot, Map settings, Logger log) throws SerializerException {
        log.debug("recreateMediaTypes - processing");
        JSMediaTypes mediaTypes = snapshot.getMediaTypes();
        if (mediaTypes != null && mediaTypes.size() > 0) {
            for (JSMediaType _c : mediaTypes) {
                try {
                    int added;
                    Iterator _it1;
                    List list;
                    String _line;
                    MediaType mediaType = this.caps.createMediaType(_c.getName());
                    if (!JetspeedCapabilitiesSerializer.isSettingSet((Map)settings, (String)"overwrite_existing") && mediaType.getMediatypeId() != 0) continue;
                    mediaType.setCharacterSet(_c.getCharacterSet());
                    mediaType.setTitle(_c.getTitle());
                    mediaType.setDescription(_c.getDescription());
                    try {
                        _line = _c.getMimeTypesString().toString();
                        list = JetspeedCapabilitiesSerializer.getTokens((String)_line);
                        if (list != null && list.size() > 0) {
                            _it1 = list.iterator();
                            added = 0;
                            while (_it1.hasNext()) {
                                MimeType _mt = this.caps.createMimeType((String)_it1.next());
                                if (_mt != null) {
                                    mediaType.addMimetype(_mt);
                                }
                                ++added;
                            }
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    try {
                        _line = _c.getCapabilitiesString().toString();
                        list = JetspeedCapabilitiesSerializer.getTokens((String)_line);
                        if (list != null && list.size() > 0) {
                            _it1 = list.iterator();
                            if (list != null && list.size() > 0) {
                                added = 0;
                                while (_it1.hasNext()) {
                                    Capability _ct = this.caps.createCapability((String)_it1.next());
                                    if (_ct != null) {
                                        mediaType.addCapability(_ct);
                                    }
                                    ++added;
                                }
                            }
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    this.caps.storeMediaType(mediaType);
                }
                catch (Exception e) {
                    throw new SerializerException(SerializerException.CREATE_OBJECT_FAILED.create((Object)"org.apache.jetspeed.capabilities.MediaType", (Object)e.getLocalizedMessage()));
                }
            }
        } else {
            log.debug("NO MEDIA TYPES?????");
        }
        log.debug("recreateMediaTypes - done");
    }

    private void recreateClients(JSSnapshot snapshot, Map settings, Logger log) throws SerializerException {
        log.debug("recreateClients - processing");
        JSClients clients = snapshot.getClients();
        if (clients != null && clients.size() > 0) {
            for (JSClient _c : clients) {
                try {
                    int added;
                    Iterator _it1;
                    List list;
                    String _line;
                    Client client = this.caps.createClient(_c.getName());
                    if (!JetspeedCapabilitiesSerializer.isSettingSet((Map)settings, (String)"overwrite_existing") && client.getClientId() != 0) continue;
                    client.setUserAgentPattern(_c.getUserAgentPattern());
                    client.setManufacturer(_c.getManufacturer());
                    client.setModel(_c.getModel());
                    client.setEvalOrder(_c.getEvalOrder());
                    String myPrefMimeType = _c.getPreferredMimeTypeID();
                    client.setVersion(_c.getVersion());
                    try {
                        _line = _c.getMimeTypesString().toString();
                        list = JetspeedCapabilitiesSerializer.getTokens((String)_line);
                        if (list != null && list.size() > 0) {
                            _it1 = list.iterator();
                            added = 0;
                            while (_it1.hasNext()) {
                                MimeType _mt = this.caps.createMimeType((String)_it1.next());
                                if (_mt != null) {
                                    client.getMimetypes().add(_mt);
                                    if (_mt.getMimetypeId() == 0) {
                                        this.caps.storeMimeType(_mt);
                                    }
                                    if (myPrefMimeType.equalsIgnoreCase(_mt.getName())) {
                                        client.setPreferredMimeTypeId(_mt.getMimetypeId());
                                    }
                                }
                                ++added;
                            }
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    try {
                        _line = _c.getCapabilitiesString().toString();
                        list = JetspeedCapabilitiesSerializer.getTokens((String)_line);
                        if (list != null && list.size() > 0) {
                            _it1 = list.iterator();
                            if (list != null && list.size() > 0) {
                                added = 0;
                                while (_it1.hasNext()) {
                                    Capability _ct = this.caps.createCapability((String)_it1.next());
                                    if (_ct != null) {
                                        client.getCapabilities().add(_ct);
                                    }
                                    ++added;
                                }
                            }
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    this.caps.storeClient(client);
                }
                catch (Exception e) {
                    throw new SerializerException(SerializerException.CREATE_OBJECT_FAILED.create((Object)"org.apache.jetspeed.capabilities.Client", (Object)e.getLocalizedMessage()));
                }
            }
        } else {
            log.debug("NO MEDIA TYPES?????");
        }
        log.debug("recreateClients - done");
    }

    private void exportCapabilites(Refs refs, JSSnapshot snapshot, Map settings, Logger log) throws SerializerException {
        Iterator list = this.caps.getCapabilities();
        while (list.hasNext()) {
            try {
                Capability _cp = (Capability)list.next();
                JSCapability _jsC = new JSCapability();
                _jsC.setName(_cp.getName());
                refs.capabilityMap.put(_jsC.getName(), _jsC);
                refs.capabilityMapInt.put(new Integer(_cp.getCapabilityId()), _jsC);
                snapshot.getCapabilities().add((Object)_jsC);
            }
            catch (Exception e) {
                throw new SerializerException(SerializerException.CREATE_SERIALIZED_OBJECT_FAILED.create((Object[])new String[]{"C", e.getMessage()}));
            }
        }
    }

    private void exportMimeTypes(Refs refs, JSSnapshot snapshot, Map settings, Logger log) throws SerializerException {
        Iterator list = this.caps.getMimeTypes();
        while (list.hasNext()) {
            try {
                MimeType _mt = (MimeType)list.next();
                JSMimeType _jsM = new JSMimeType();
                _jsM.setName(_mt.getName());
                refs.mimeMap.put(_jsM.getName(), _jsM);
                refs.mimeMapInt.put(new Integer(_mt.getMimetypeId()), _jsM);
                snapshot.getMimeTypes().add((Object)_jsM);
            }
            catch (Exception e) {
                throw new SerializerException(SerializerException.CREATE_SERIALIZED_OBJECT_FAILED.create((Object[])new String[]{"MimeType", e.getMessage()}));
            }
        }
    }

    private JSClient createJSClient(Refs refs, Client c) throws SerializerException {
        try {
            JSMimeType _mt;
            JSClient jsC = new JSClient(c);
            for (MimeType _m : c.getMimetypes()) {
                _mt = (JSMimeType)refs.mimeMap.get(_m.getName());
                if (_mt == null) continue;
                jsC.getMimeTypes().add(_mt);
            }
            Integer id = new Integer(c.getPreferredMimeTypeId());
            _mt = (JSMimeType)refs.mimeMapInt.get(id);
            if (_mt != null) {
                jsC.setPreferredMimeTypeID(_mt.getName());
            } else {
                jsC.setPreferredMimeTypeID("???");
            }
            for (Capability _c : c.getCapabilities()) {
                JSCapability _ct = (JSCapability)refs.capabilityMap.get(_c.getName());
                if (_ct == null) continue;
                jsC.getCapabilities().add(_ct);
            }
            return jsC;
        }
        catch (Exception e) {
            throw new SerializerException(SerializerException.CREATE_SERIALIZED_OBJECT_FAILED.create((Object[])new String[]{"Client", e.getMessage()}));
        }
    }

    private void exportClients(Refs refs, JSSnapshot snapshot, Map settings, Logger log) throws SerializerException {
        this.exportMimeTypes(refs, snapshot, settings, log);
        this.exportCapabilites(refs, snapshot, settings, log);
        Iterator _it = this.caps.getClients();
        while (_it.hasNext()) {
            Client c = (Client)_it.next();
            JSClient jsC = this.createJSClient(refs, c);
            if (jsC == null) {
                throw new SerializerException(SerializerException.CREATE_SERIALIZED_OBJECT_FAILED.create((Object[])new String[]{"Client", "createClient returned NULL"}));
            }
            refs.clientMap.put(jsC.getName(), jsC);
            snapshot.getClients().add((Object)jsC);
        }
    }

    private void exportMediaTypes(Refs refs, JSSnapshot snapshot, Map settings, Logger log) throws SerializerException {
        Iterator list = this.caps.getMediaTypes();
        while (list.hasNext()) {
            try {
                MediaType _mt = (MediaType)list.next();
                JSMediaType _jsM = new JSMediaType(_mt);
                for (MimeType _m : _mt.getMimetypes()) {
                    JSMimeType _mttype = (JSMimeType)refs.mimeMap.get(_m.getName());
                    if (_mttype == null) continue;
                    _jsM.getMimeTypes().add(_mttype);
                }
                for (Capability _c : _mt.getCapabilities()) {
                    JSCapability _ct = (JSCapability)refs.capabilityMap.get(_c.getName());
                    if (_ct == null) continue;
                    _jsM.getCapabilities().add(_ct);
                }
                refs.mediaMap.put(_jsM.getName(), _jsM);
                snapshot.getMediaTypes().add((Object)_jsM);
            }
            catch (Exception e) {
                throw new SerializerException(SerializerException.CREATE_SERIALIZED_OBJECT_FAILED.create((Object[])new String[]{"MediaType", e.getMessage()}));
            }
        }
    }

    private static class Refs {
        HashMap mimeMap = new HashMap();
        HashMap mimeMapInt = new HashMap();
        HashMap mediaMap = new HashMap();
        HashMap capabilityMap = new HashMap();
        HashMap capabilityMapInt = new HashMap();
        HashMap clientMap = new HashMap();

        private Refs() {
        }
    }
}

