/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.contentserver;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import org.apache.jetspeed.contentserver.AbstractContentLocator;
import org.apache.jetspeed.contentserver.ContentLocator;

public class SimpleContentLocator
extends AbstractContentLocator
implements ContentLocator {
    protected String realPath;

    public SimpleContentLocator(String rootPath, String[] URLHints, boolean useCachedLookup, String contextRoot, String URI2, List lookupPathes) throws FileNotFoundException {
        super(rootPath, URLHints, useCachedLookup, contextRoot, URI2, lookupPathes);
    }

    public String getRealPath() {
        if (this.realPath == null) {
            for (int j = 0; j < this.URLHints.length; ++j) {
                String URLHint = this.URLHints[j];
                int rootLen = URLHint.length();
                int rootStart = this.URI.lastIndexOf(URLHint);
                File fqFile = null;
                if (rootStart == -1) continue;
                String dir = null;
                dir = rootLen > 1 ? this.URI.substring(rootStart + rootLen) : this.URI.substring(this.contextRoot.length());
                for (int i = 0; i < this.lookupPathes.size(); ++i) {
                    if (this.useCachedLookup && fileCache.containsKey(this.lookupPathes.get(i) + ":" + this.URI)) {
                        this.realPath = (String)fileCache.get(this.lookupPathes.get(i) + ":" + this.URI);
                        log.debug((Object)("Found cached file for URI: " + this.URI));
                        return this.realPath;
                    }
                    String[] sep = new String[]{"", ""};
                    if (this.lookupPathes.get(i).toString().trim().length() > 1) {
                        sep[0] = "/";
                    }
                    if (!dir.startsWith("/")) {
                        sep[1] = "/";
                    }
                    String fqPath = this.rootPath + sep[0] + this.lookupPathes.get(i) + sep[1] + dir;
                    fqFile = new File(fqPath);
                    log.debug((Object)("Actual content located at: " + fqPath));
                    log.debug((Object)("Content exists? " + fqFile.exists()));
                    if (fqFile.exists()) {
                        if (this.useCachedLookup) {
                            fileCache.put(this.lookupPathes.get(i) + ":" + this.URI, fqPath);
                        }
                        this.realPath = fqPath;
                        return this.realPath;
                    }
                    fqFile = null;
                }
            }
        }
        return this.realPath;
    }
}

