/*
 * Decompiled with CFR 0.152.
 */
package com.google.step2.xmlsimplesign;

import com.google.step2.http.FetchException;
import com.google.step2.http.FetchRequest;
import com.google.step2.http.FetchResponse;
import com.google.step2.http.HttpFetcher;
import com.google.step2.util.EncodingUtil;
import com.google.step2.util.XmlUtil;
import com.google.step2.xmlsimplesign.CachedCertPathValidator;
import com.google.step2.xmlsimplesign.CertUtil;
import com.google.step2.xmlsimplesign.CertValidatorException;
import com.google.step2.xmlsimplesign.Constants;
import com.google.step2.xmlsimplesign.VerificationResult;
import com.google.step2.xmlsimplesign.XmlSimpleSignException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;

public class Verifier {
    private final CachedCertPathValidator validator;
    private final HttpFetcher fetcher;

    public Verifier(CachedCertPathValidator validator, HttpFetcher fetcher) {
        this.validator = validator;
        this.fetcher = fetcher;
    }

    public VerificationResult verify(byte[] document, String signature) throws XmlSimpleSignException {
        try {
            Document xml = XmlUtil.getJdomDocument(new ByteArrayInputStream(document));
            Element signatureElement = this.findDsig(xml.getRootElement(), "Signature");
            this.parseSignatureInfo(signatureElement);
            List<X509Certificate> docCerts = this.parseCerts(signatureElement);
            byte[] sig = signature == null ? this.parseSignatureValue(signatureElement) : EncodingUtil.decodeBase64(signature);
            return this.checkSignature(document, sig, docCerts);
        }
        catch (JDOMException e) {
            throw new XmlSimpleSignException("XML error", e);
        }
        catch (IOException e) {
            throw new XmlSimpleSignException("XML error", e);
        }
        catch (GeneralSecurityException e) {
            throw new XmlSimpleSignException("Signature verification error", e);
        }
        catch (CertValidatorException e) {
            throw new XmlSimpleSignException("Untrusted certificate", e);
        }
    }

    private void parseSignatureInfo(Element signature) throws XmlSimpleSignException {
        if (signature == null) {
            throw new XmlSimpleSignException("no Signature element");
        }
        Element signedInfo = this.findDsig(signature, "SignedInfo");
        if (signedInfo == null) {
            throw new XmlSimpleSignException("No SignedInfo element");
        }
        Element c14n = this.findDsig(signedInfo, "CanonicalizationMethod");
        if (c14n == null) {
            throw new XmlSimpleSignException("No CanonicalizationMethod element");
        }
        String c14nAlg = c14n.getAttributeValue("Algorithm");
        if (!"http://docs.oasis-open.org/xri/xrd/2009/01#canonicalize-raw-octets".equals(c14nAlg)) {
            throw new XmlSimpleSignException("Unknown canonicalization algorithm: " + c14nAlg);
        }
        Element sigMethod = this.findDsig(signedInfo, "SignatureMethod");
        if (sigMethod == null) {
            throw new XmlSimpleSignException("No SignatureMethod element");
        }
        String signingAlg = sigMethod.getAttributeValue("Algorithm");
        if (!"http://www.w3.org/2000/09/xmldsig#rsa-sha1".equals(signingAlg)) {
            throw new XmlSimpleSignException("Unknown signing algorithm: " + signingAlg);
        }
    }

    private byte[] parseSignatureValue(Element signature) throws XmlSimpleSignException {
        Element signatureLocation = this.findSimpleSig(signature, "SignatureLocation");
        if (signatureLocation == null) {
            throw new XmlSimpleSignException("No SignatureLocation element found");
        }
        String signatureHref = signatureLocation.getTextTrim();
        if (signatureHref == null) {
            throw new XmlSimpleSignException("No SignatureLocation text found");
        }
        FetchRequest request = FetchRequest.createGetRequest(URI.create(signatureHref));
        try {
            FetchResponse r = this.fetcher.fetch(request);
            return EncodingUtil.decodeBase64(r.getContentAsBytes());
        }
        catch (FetchException e) {
            throw new XmlSimpleSignException("couldn't fetch signature from " + signatureHref, e);
        }
    }

    private List<X509Certificate> parseCerts(Element signature) throws XmlSimpleSignException, GeneralSecurityException {
        Element keyInfo = this.findDsig(signature, "KeyInfo");
        if (keyInfo == null) {
            throw new XmlSimpleSignException("No KeyInfo element found");
        }
        Element x509Data = this.findDsig(keyInfo, "X509Data");
        if (x509Data == null) {
            throw new XmlSimpleSignException("No X509Data element found");
        }
        List<Element> certs = this.findElements(x509Data, "X509Certificate");
        if (certs.isEmpty()) {
            throw new XmlSimpleSignException("No X509Certificate elements found");
        }
        ArrayList<X509Certificate> docCerts = new ArrayList<X509Certificate>();
        for (Element i : certs) {
            docCerts.add(CertUtil.getCertFromBase64Bytes(i.getTextNormalize()));
        }
        return docCerts;
    }

    private VerificationResult checkSignature(byte[] document, byte[] sig, List<X509Certificate> docCerts) throws GeneralSecurityException, XmlSimpleSignException, CertValidatorException {
        Signature verifier = Signature.getInstance("SHA1withRSA");
        verifier.initVerify(docCerts.get(0).getPublicKey());
        verifier.update(document);
        boolean match = verifier.verify(sig);
        if (!match) {
            throw new XmlSimpleSignException("Signature is invalid");
        }
        this.validator.validate(docCerts);
        return new VerificationResult(docCerts);
    }

    private List<Element> findElements(Element parent, String name) {
        ArrayList<Element> els = new ArrayList<Element>();
        for (Element i : this.getChildren(parent)) {
            if (!name.equals(i.getName()) || !Constants.XML_DSIG_NS.equals((Object)i.getNamespace())) continue;
            els.add(i);
        }
        return els;
    }

    private Element findDsig(Element parent, String name) {
        return this.find(parent, name, Constants.XML_DSIG_NS);
    }

    private Element findSimpleSig(Element parent, String name) {
        return this.find(parent, name, Constants.SIMPLE_SIGN_NS);
    }

    private Element find(Element parent, String name, Namespace ns) {
        for (Element i : this.getChildren(parent)) {
            if (!name.equals(i.getName()) || !ns.equals((Object)i.getNamespace())) continue;
            return i;
        }
        return null;
    }

    private List<Element> getChildren(Element xml) {
        return xml.getChildren();
    }
}

