/*
 * Decompiled with CFR 0.152.
 */
package com.google.step2.discovery;

import com.google.step2.discovery.HostMeta;
import com.google.step2.discovery.HostMetaException;
import com.google.step2.discovery.HostMetaFetcher;
import com.google.step2.http.FetchException;
import com.google.step2.http.FetchRequest;
import com.google.step2.http.FetchResponse;
import com.google.step2.http.HttpFetcher;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.client.HttpResponseException;

public abstract class UrlHostMetaFetcher
implements HostMetaFetcher {
    private final HttpFetcher fetcher;

    protected UrlHostMetaFetcher(HttpFetcher fetcher) {
        this.fetcher = fetcher;
    }

    @Override
    public HostMeta getHostMeta(String host) throws HostMetaException {
        try {
            URI uri = this.getHostMetaUriForHost(host);
            FetchRequest request = FetchRequest.createGetRequest(uri);
            FetchResponse response = this.fetcher.fetch(request);
            int status = response.getStatusCode();
            if (status != 200) {
                throw new HttpResponseException(status, "fetching host-meta from " + host + " return status " + status);
            }
            return HostMeta.parseFromStream(response.getContentAsStream());
        }
        catch (FetchException e) {
            throw new HostMetaException(e);
        }
        catch (URISyntaxException e) {
            throw new HostMetaException(e);
        }
        catch (HttpResponseException e) {
            throw new HostMetaException(e);
        }
        catch (IOException e) {
            throw new HostMetaException(e);
        }
    }

    protected abstract URI getHostMetaUriForHost(String var1) throws URISyntaxException;
}

