/*
 * Decompiled with CFR 0.152.
 */
package com.google.step2.discovery;

import com.google.step2.discovery.LinkSyntaxException;
import com.google.step2.discovery.LinkValue;
import com.google.step2.discovery.RelTypes;

public abstract class LinkBase {
    private final LinkValue value;
    private final String prefix;

    protected LinkBase(String input, String prefix) throws LinkSyntaxException {
        this.value = LinkBase.getLinkValue(input, prefix);
        this.prefix = prefix.toLowerCase();
    }

    public LinkValue getLinkValue() {
        return this.value;
    }

    public RelTypes getRelationships() {
        return this.getLinkValue().getRelationships();
    }

    public String getMimeType() {
        return this.getLinkValue().getMimeType();
    }

    public String getParamater(String name) {
        return this.getLinkValue().getParameter(name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LinkBase other = (LinkBase)obj;
        if (this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    private static LinkValue getLinkValue(String input, String prefix) throws LinkSyntaxException {
        int colon = input.indexOf(58);
        if (colon < 0) {
            throw new LinkSyntaxException("missing colon:" + input);
        }
        String left = input.substring(0, colon).trim();
        String right = input.substring(colon + 1).trim();
        if (!left.equalsIgnoreCase(prefix)) {
            throw new LinkSyntaxException("missing " + prefix + " prefix: " + input);
        }
        return LinkValue.fromString(right);
    }
}

