/*
 * Decompiled with CFR 0.152.
 */
package com.google.step2.xmlsimplesign;

import com.google.step2.util.ExpiringLruCache;
import com.google.step2.util.TimeSource;
import com.google.step2.xmlsimplesign.CertValidatorException;
import com.google.step2.xmlsimplesign.TrustRootsProvider;
import java.security.GeneralSecurityException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedCertPathValidator {
    private static final Logger log = Logger.getLogger(CachedCertPathValidator.class.getName());
    private static final String VALIDATOR_TYPE = "PKIX";
    private static final String CERTIFICATE_TYPE = "X.509";
    private static final int VALIDATION_CACHE_SIZE = 1024;
    private static final long VALIDATION_CACHE_AGE_SECONDS = 600L;
    private final Set<TrustAnchor> trustRoots;
    private final ExpiringLruCache<List<X509Certificate>, Boolean> validationCache;
    private TimeSource timeSource = new TimeSource();

    public CachedCertPathValidator(TrustRootsProvider trustRoots) {
        this(trustRoots.getTrustRoots());
    }

    public CachedCertPathValidator(Collection<X509Certificate> trustRoots) {
        this.trustRoots = this.createTrustRoots(trustRoots);
        this.validationCache = new ExpiringLruCache(1024);
    }

    private Set<TrustAnchor> createTrustRoots(Collection<X509Certificate> trustRoots) {
        ArrayList<TrustAnchor> anchors = new ArrayList<TrustAnchor>();
        for (X509Certificate c : trustRoots) {
            anchors.add(new TrustAnchor(c, null));
        }
        return new HashSet<TrustAnchor>(anchors);
    }

    public void setTimeSource(TimeSource timeSource) {
        this.timeSource = timeSource;
        this.validationCache.setTimeSource(timeSource);
    }

    public void validate(List<X509Certificate> certs) throws CertValidatorException {
        if (this.validationCache.get(certs) != null) {
            return;
        }
        this.validateNoCache(certs);
        this.validationCache.put(certs, Boolean.TRUE, 600L);
    }

    private void validateNoCache(List<X509Certificate> certs) throws CertValidatorException {
        try {
            CertPathValidator validator = CertPathValidator.getInstance(VALIDATOR_TYPE);
            PKIXParameters params = new PKIXParameters(this.trustRoots);
            params.setDate(this.timeSource.now());
            params.setRevocationEnabled(false);
            CertificateFactory certFactory = CertificateFactory.getInstance(CERTIFICATE_TYPE);
            CertPath certPath = certFactory.generateCertPath(certs);
            validator.validate(certPath, params);
        }
        catch (GeneralSecurityException e) {
            log.log(Level.WARNING, "Certificate validation failed, certs were: " + certs, e);
            throw new CertValidatorException("Certificate validation failure", e);
        }
    }
}

