/*
 * Decompiled with CFR 0.152.
 */
package com.google.step2.discovery;

import com.google.step2.discovery.IdpIdentifier;
import com.google.step2.discovery.SecureDiscoveryInformation;
import com.google.step2.discovery.UriTemplate;
import com.google.step2.discovery.XrdDiscoveryResolver;
import com.google.step2.http.FetchException;
import com.google.step2.http.FetchRequest;
import com.google.step2.http.FetchResponse;
import com.google.step2.http.HttpFetcher;
import com.google.step2.util.XmlUtil;
import com.google.step2.xmlsimplesign.CertValidator;
import com.google.step2.xmlsimplesign.VerificationResult;
import com.google.step2.xmlsimplesign.Verifier;
import com.google.step2.xmlsimplesign.XmlSimpleSignException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.Identifier;
import org.openid4java.discovery.UrlIdentifier;
import org.openxri.xml.Service;
import org.openxri.xml.XRD;
import org.openxri.xml.XRDS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyXrdsResolver
implements XrdDiscoveryResolver {
    private static final Logger logger = Logger.getLogger(LegacyXrdsResolver.class.getName());
    private static final String XRDS_TYPE = "application/xrds+xml";
    private static final String URI_TEMPLATE_TYPE = "http://www.iana.org/assignments/relation/describedby";
    private static final String URI_TEMPLATE_TAG = "URITemplate";
    private static final String NEXT_AUTHORITY_TAG = "NextAuthority";
    private final HttpFetcher httpFetcher;
    private final Verifier verifier;
    private final CertValidator certValidator;

    public LegacyXrdsResolver(HttpFetcher httpFetcher, Verifier verifier, CertValidator validator) {
        this.httpFetcher = httpFetcher;
        this.verifier = verifier;
        this.certValidator = validator;
    }

    @Override
    public String getDiscoveryDocumentType() {
        return XRDS_TYPE;
    }

    @Override
    public List<SecureDiscoveryInformation> findOpEndpointsForSite(IdpIdentifier site, URI siteXrdsUri) throws DiscoveryException {
        return this.resolveXrds(this.getXrd(siteXrdsUri), "http://specs.openid.net/auth/2.0/server", site, null);
    }

    @Override
    public List<SecureDiscoveryInformation> findOpEndpointsForUser(UrlIdentifier claimedId, URI userXrdsUri) throws DiscoveryException {
        return this.resolveXrds(this.getXrd(userXrdsUri), "http://specs.openid.net/auth/2.0/signon", (Identifier)claimedId, null);
    }

    @Override
    public List<SecureDiscoveryInformation> findOpEndpointsForUserThroughSiteXrd(UrlIdentifier claimedId, URI siteXrdsUri) throws DiscoveryException {
        NextXrdLocation userXrdsLocation = this.mapClaimedIdToUserXrdsUri(this.getXrd(siteXrdsUri), claimedId);
        return this.resolveXrds(this.getXrd(userXrdsLocation.getUri()), "http://specs.openid.net/auth/2.0/signon", (Identifier)claimedId, userXrdsLocation.getNextAuthority());
    }

    NextXrdLocation mapClaimedIdToUserXrdsUri(XrdRepresentations siteXrd, UrlIdentifier claimedId) throws DiscoveryException {
        IdpIdentifier host = new IdpIdentifier(claimedId.getUrl().getHost());
        Service service = this.getServiceForType(siteXrd.getXrd(), URI_TEMPLATE_TYPE);
        if (service == null) {
            throw new DiscoveryException("could not find service of type http://www.iana.org/assignments/relation/describedby in XRDS at location " + claimedId.getIdentifier());
        }
        String nextAuthority = this.checkSecurity(siteXrd, host, null) ? this.getTagValue(service, NEXT_AUTHORITY_TAG) : null;
        String uriTemplate = this.getTagValue(service, URI_TEMPLATE_TAG);
        if (uriTemplate == null) {
            throw new DiscoveryException("missing URITemplate in service specification in XRDS at location " + claimedId.getIdentifier());
        }
        UriTemplate template = new UriTemplate(uriTemplate);
        URI newUri = template.map(URI.create(claimedId.getIdentifier()));
        return new NextXrdLocation(newUri, nextAuthority);
    }

    private String getTagValue(Service service, String tagName) {
        Vector tags = service.getOtherTagValues(tagName);
        if (tags == null || tags.size() == 0) {
            return null;
        }
        return ((Element)tags.get(0)).getTextContent();
    }

    private List<SecureDiscoveryInformation> resolveXrds(XrdRepresentations xrd, String version, Identifier id, String authority) throws DiscoveryException {
        boolean isSecure = this.checkSecurity(xrd, id, authority);
        List<Service> services = this.getServicesForType(xrd.getXrd(), version);
        if (services == null) {
            throw new DiscoveryException("could not find <Service> of type " + version + " in XRDS for " + xrd.getSource());
        }
        ArrayList<SecureDiscoveryInformation> result = new ArrayList<SecureDiscoveryInformation>(services.size());
        for (Service service : services) {
            try {
                if (version.equals("http://specs.openid.net/auth/2.0/signon")) {
                    result.add(this.createDiscoveryInfoForSignon(service, id, isSecure));
                    continue;
                }
                if (version.equals("http://specs.openid.net/auth/2.0/server")) {
                    result.add(this.createDiscoveryInfoForServer(service, isSecure));
                    continue;
                }
                throw new DiscoveryException("unkown OpenID version : " + version);
            }
            catch (MalformedURLException e) {
                logger.log(Level.WARNING, "found malformed URL in discovery document at " + xrd.getSource(), e);
            }
        }
        return result;
    }

    private boolean checkSecurity(XrdRepresentations xrd, Identifier id, String authority) {
        VerificationResult verificatioResult;
        String canonicalId = this.getCanonicalId(xrd.getXrd());
        if (canonicalId == null) {
            logger.warning("XRD from " + xrd.getSource() + "did not have canonical Id");
            return false;
        }
        if (!canonicalId.equals(id.getIdentifier())) {
            logger.warning("Canonical ID " + canonicalId + " in XRD from " + xrd.getSource() + " did not equal identifier " + id.getIdentifier());
            return false;
        }
        try {
            verificatioResult = this.verifier.verify(xrd.getDocument(), xrd.getSignature());
        }
        catch (XmlSimpleSignException e) {
            logger.log(Level.WARNING, "signature on XRD from " + xrd.getSource() + "did not verify", e);
            return false;
        }
        authority = authority == null ? canonicalId : authority;
        return this.certValidator.matches(verificatioResult.getCerts().get(0), authority);
    }

    private String getCanonicalId(XRD xrd) {
        if (xrd.getNumCanonicalids() != 1) {
            return null;
        }
        return xrd.getCanonicalidAt(0).getValue();
    }

    private SecureDiscoveryInformation createDiscoveryInfoForServer(Service service, boolean isSecure) throws DiscoveryException, MalformedURLException {
        SecureDiscoveryInformation result = new SecureDiscoveryInformation(service.getURIAt(0).getURI().toURL());
        result.setSecure(isSecure);
        return result;
    }

    private SecureDiscoveryInformation createDiscoveryInfoForSignon(Service service, Identifier claimedId, boolean isSecure) throws DiscoveryException, MalformedURLException {
        String localId = this.getLocalId(service);
        SecureDiscoveryInformation result = new SecureDiscoveryInformation(service.getURIAt(0).getURI().toURL(), claimedId, localId, "http://specs.openid.net/auth/2.0/signon");
        result.setSecure(isSecure);
        return result;
    }

    private String getLocalId(Service service) {
        int numLocalIds = service.getNumLocalIDs();
        if (numLocalIds == 0) {
            return null;
        }
        return service.getLocalIDAt(0).getValue();
    }

    private XrdRepresentations getXrd(URI uri) throws DiscoveryException {
        XrdRepresentations result;
        try {
            result = this.fetchXrd(uri);
        }
        catch (FetchException e) {
            throw new DiscoveryException("could not fetch XRDS from " + uri.toASCIIString(), (Throwable)e);
        }
        if (result == null) {
            throw new DiscoveryException("XRDS at " + uri.toASCIIString() + " did " + "not contain an XRD");
        }
        return result;
    }

    private XrdRepresentations fetchXrd(URI uri) throws FetchException {
        XRDS xrds;
        String signature;
        byte[] documentBytes;
        FetchRequest request = FetchRequest.createGetRequest(uri);
        try {
            FetchResponse response = this.httpFetcher.fetch(request);
            documentBytes = response.getContentAsBytes();
            signature = response.getFirstHeader("Signature");
            Document document = XmlUtil.getDocument(new ByteArrayInputStream(documentBytes));
            xrds = new XRDS(document.getDocumentElement(), false);
        }
        catch (ParserConfigurationException e) {
            throw new FetchException(e);
        }
        catch (SAXException e) {
            throw new FetchException(e);
        }
        catch (IOException e) {
            throw new FetchException(e);
        }
        catch (URISyntaxException e) {
            throw new FetchException(e);
        }
        catch (ParseException e) {
            throw new FetchException(e);
        }
        return new XrdRepresentations(xrds.getFinalXRD(), uri.toASCIIString(), documentBytes, signature);
    }

    private Service getServiceForType(XRD xrd, String type) {
        ArrayList allServices = xrd.getPrioritizedServices();
        if (allServices == null) {
            return null;
        }
        for (Service service : allServices) {
            if (!service.matchType(type)) continue;
            return service;
        }
        return null;
    }

    private List<Service> getServicesForType(XRD xrd, String type) {
        ArrayList allServices = xrd.getPrioritizedServices();
        ArrayList<Service> result = new ArrayList<Service>();
        if (allServices == null) {
            return null;
        }
        for (Service service : allServices) {
            if (!service.matchType(type)) continue;
            result.add(service);
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    private static class XrdRepresentations {
        private final XRD xrd;
        private final byte[] document;
        private final String source;
        private final String signature;

        public XrdRepresentations(XRD xrd, String source, byte[] document, String signature) {
            this.xrd = xrd;
            this.source = source;
            this.document = document;
            this.signature = signature;
        }

        public XRD getXrd() {
            return this.xrd;
        }

        public byte[] getDocument() {
            return this.document;
        }

        public String getSignature() {
            return this.signature;
        }

        public String getSource() {
            return this.source;
        }
    }

    private static class NextXrdLocation {
        private final URI uri;
        private final String nextAuthority;

        public NextXrdLocation(URI uri, String nextAuthority) {
            this.uri = uri;
            this.nextAuthority = nextAuthority;
        }

        public URI getUri() {
            return this.uri;
        }

        public String getNextAuthority() {
            return this.nextAuthority;
        }
    }
}

