/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.text.MessageFormat;
import org.apache.poi.util.HexDump;

public final class FieldDescriptor {
    public static final int FIELD_BEGIN_MARK = 19;
    public static final int FIELD_SEPARATOR_MARK = 20;
    public static final int FIELD_END_MARK = 21;
    private static final short BOUNDARY_MASK = 31;
    private static final short TYPE_MASK = 255;
    private static final short ZOMBIE_EMBED_MASK = 2;
    private static final short RESULT_DIRTY_MASK = 4;
    private static final short RESULT_EDITED_MASK = 8;
    private static final short LOCKED_MASK = 16;
    private static final short PRIVATE_RESULT_MASK = 32;
    private static final short NESTED_MASK = 64;
    private static final short HAS_SEP_MASK = 128;
    byte _fieldBoundaryType;
    byte _info;
    private int fieldType;
    private boolean zombieEmbed;
    private boolean resultDirty;
    private boolean resultEdited;
    private boolean locked;
    private boolean privateResult;
    private boolean nested;
    private boolean hasSep;

    public FieldDescriptor(byte[] data) {
        this._fieldBoundaryType = (byte)(data[0] & 0x1F);
        this._info = data[1];
        if (this._fieldBoundaryType == 19) {
            this.fieldType = this._info & 0xFF;
        } else if (this._fieldBoundaryType == 21) {
            this.zombieEmbed = (this._info & 2) == 1;
            this.resultDirty = (this._info & 4) == 1;
            this.resultEdited = (this._info & 8) == 1;
            this.locked = (this._info & 0x10) == 1;
            this.privateResult = (this._info & 0x20) == 1;
            this.nested = (this._info & 0x40) == 1;
            this.hasSep = (this._info & 0x80) == 1;
        }
    }

    public int getBoundaryType() {
        return this._fieldBoundaryType;
    }

    public int getFieldType() {
        if (this._fieldBoundaryType != 19) {
            throw new UnsupportedOperationException("This field is only defined for begin marks.");
        }
        return this.fieldType;
    }

    public boolean isZombieEmbed() {
        if (this._fieldBoundaryType != 21) {
            throw new UnsupportedOperationException("This field is only defined for end marks.");
        }
        return this.zombieEmbed;
    }

    public boolean isResultDirty() {
        if (this._fieldBoundaryType != 21) {
            throw new UnsupportedOperationException("This field is only defined for end marks.");
        }
        return this.resultDirty;
    }

    public boolean isResultEdited() {
        if (this._fieldBoundaryType != 21) {
            throw new UnsupportedOperationException("This field is only defined for end marks.");
        }
        return this.resultEdited;
    }

    public boolean isLocked() {
        if (this._fieldBoundaryType != 21) {
            throw new UnsupportedOperationException("This field is only defined for end marks.");
        }
        return this.locked;
    }

    public boolean isPrivateResult() {
        if (this._fieldBoundaryType != 21) {
            throw new UnsupportedOperationException("This field is only defined for end marks.");
        }
        return this.privateResult;
    }

    public boolean isNested() {
        if (this._fieldBoundaryType != 21) {
            throw new UnsupportedOperationException("This field is only defined for end marks.");
        }
        return this.nested;
    }

    public boolean isHasSep() {
        if (this._fieldBoundaryType != 21) {
            throw new UnsupportedOperationException("This field is only defined for end marks.");
        }
        return this.hasSep;
    }

    public String toString() {
        String details = new String();
        if (this._fieldBoundaryType == 19) {
            details = " type: " + this.fieldType;
        } else if (this._fieldBoundaryType == 21) {
            details = " flags: 0x" + HexDump.toHex((byte)this._info);
        }
        return MessageFormat.format("FLD - 0x{0}{1}", HexDump.toHex((byte)this._fieldBoundaryType), details);
    }
}

