/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hwpf.model.CPSplitCalculator;
import org.apache.poi.hwpf.model.GenericPropertyNode;
import org.apache.poi.hwpf.model.PlexOfCps;
import org.apache.poi.hwpf.model.SEPX;
import org.apache.poi.hwpf.model.SectionDescriptor;
import org.apache.poi.hwpf.model.TextPiece;
import org.apache.poi.hwpf.model.TextPieceTable;
import org.apache.poi.hwpf.model.io.HWPFFileSystem;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;
import org.apache.poi.util.LittleEndian;

public class SectionTable {
    private static final int SED_SIZE = 12;
    protected ArrayList _sections = new ArrayList();
    protected List _text;
    private TextPieceTable tpt;

    public SectionTable() {
    }

    public SectionTable(byte[] documentStream, byte[] tableStream, int offset, int size, int fcMin, TextPieceTable tpt, CPSplitCalculator cps) {
        int i;
        PlexOfCps sedPlex = new PlexOfCps(tableStream, offset, size, 12);
        this.tpt = tpt;
        this._text = tpt.getTextPieces();
        int length = sedPlex.length();
        for (int x = 0; x < length; ++x) {
            GenericPropertyNode node = sedPlex.getProperty(x);
            SectionDescriptor sed = new SectionDescriptor(node.getBytes(), 0);
            int fileOffset = sed.getFc();
            int startAt = this.CPtoFC(node.getStart());
            int endAt = this.CPtoFC(node.getEnd());
            boolean isUnicodeAtStart = tpt.isUnicodeAtByteOffset(startAt);
            if (fileOffset == -1) {
                this._sections.add(new SEPX(sed, startAt, endAt, new byte[0], isUnicodeAtStart));
                continue;
            }
            short sepxSize = LittleEndian.getShort((byte[])documentStream, (int)fileOffset);
            byte[] buf = new byte[sepxSize];
            System.arraycopy(documentStream, fileOffset += 2, buf, 0, buf.length);
            this._sections.add(new SEPX(sed, startAt, endAt, buf, isUnicodeAtStart));
        }
        int mainEndsAt = cps.getMainDocumentEnd();
        boolean matchAt = false;
        boolean matchHalf = false;
        for (i = 0; i < this._sections.size(); ++i) {
            SEPX s = (SEPX)this._sections.get(i);
            if (s.getEnd() == mainEndsAt) {
                matchAt = true;
                continue;
            }
            if (s.getEndBytes() != mainEndsAt && s.getEndBytes() != mainEndsAt - 1) continue;
            matchHalf = true;
        }
        if (!matchAt && matchHalf) {
            System.err.println("Your document seemed to be mostly unicode, but the section definition was in bytes! Trying anyway, but things may well go wrong!");
            for (i = 0; i < this._sections.size(); ++i) {
                SEPX s = (SEPX)this._sections.get(i);
                GenericPropertyNode node = sedPlex.getProperty(i);
                s.setStart(this.CPtoFC(node.getStart()));
                s.setEnd(this.CPtoFC(node.getEnd()));
            }
        }
    }

    public void adjustForInsert(int listIndex, int length) {
        int size = this._sections.size();
        SEPX sepx = (SEPX)this._sections.get(listIndex);
        sepx.setEnd(sepx.getEnd() + length);
        for (int x = listIndex + 1; x < size; ++x) {
            sepx = (SEPX)this._sections.get(x);
            sepx.setStart(sepx.getStart() + length);
            sepx.setEnd(sepx.getEnd() + length);
        }
    }

    private int CPtoFC(int CP) {
        TextPiece TP = null;
        for (int i = this._text.size() - 1; i > -1 && CP < (TP = (TextPiece)this._text.get(i)).getCP(); --i) {
        }
        int FC = TP.getPieceDescriptor().getFilePosition();
        int offset = CP - TP.getCP();
        FC = FC + offset - ((TextPiece)this._text.get(0)).getPieceDescriptor().getFilePosition();
        return FC;
    }

    private int FCtoCP(int fc) {
        int size = this._text.size();
        int cp = 0;
        for (int x = 0; x < size; ++x) {
            TextPiece piece = (TextPiece)this._text.get(x);
            if (fc <= piece.getEnd()) {
                cp += fc - piece.getStart();
                break;
            }
            cp += piece.getEnd() - piece.getStart();
        }
        return cp;
    }

    public ArrayList getSections() {
        return this._sections;
    }

    public void writeTo(HWPFFileSystem sys, int fcMin) throws IOException {
        HWPFOutputStream docStream = sys.getStream("WordDocument");
        HWPFOutputStream tableStream = sys.getStream("1Table");
        int offset = docStream.getOffset();
        int len = this._sections.size();
        PlexOfCps plex = new PlexOfCps(12);
        for (int x = 0; x < len; ++x) {
            SEPX sepx = (SEPX)this._sections.get(x);
            byte[] grpprl = sepx.getGrpprl();
            byte[] shortBuf = new byte[2];
            LittleEndian.putShort((byte[])shortBuf, (short)((short)grpprl.length));
            docStream.write(shortBuf);
            docStream.write(grpprl);
            SectionDescriptor sed = sepx.getSectionDescriptor();
            sed.setFc(offset);
            GenericPropertyNode property = new GenericPropertyNode(this.FCtoCP(sepx.getStartBytes()), this.FCtoCP(sepx.getEndBytes()), sed.toByteArray());
            plex.addProperty(property);
            offset = docStream.getOffset();
        }
        tableStream.write(plex.toByteArray());
    }
}

