/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

public class TextCharsAtom
extends RecordAtom {
    private byte[] _header;
    private static long _type = 4000L;
    private byte[] _text;

    public String getText() {
        return StringUtil.getFromUnicodeLE((byte[])this._text);
    }

    public void setText(String text) {
        this._text = new byte[text.length() * 2];
        StringUtil.putUnicodeLE((String)text, (byte[])this._text, (int)0);
        LittleEndian.putInt((byte[])this._header, (int)4, (int)this._text.length);
    }

    protected TextCharsAtom(byte[] source, int start, int len) {
        if (len < 8) {
            len = 8;
        }
        this._header = new byte[8];
        System.arraycopy(source, start, this._header, 0, 8);
        this._text = new byte[len - 8];
        System.arraycopy(source, start + 8, this._text, 0, len - 8);
    }

    public TextCharsAtom() {
        this._header = new byte[]{0, 0, -96, 15, 0, 0, 0, 0};
        this._text = new byte[0];
    }

    public long getRecordType() {
        return _type;
    }

    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        out.write(this._text);
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("TextCharsAtom:\n");
        out.append(HexDump.dump((byte[])this._text, (long)0L, (int)0));
        return out.toString();
    }
}

