/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.dev;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import org.apache.poi.ddf.DefaultEscherRecordFactory;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherRecordFactory;
import org.apache.poi.ddf.EscherTextboxRecord;
import org.apache.poi.hslf.HSLFSlideShow;
import org.apache.poi.hslf.record.EscherTextboxWrapper;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.StyleTextPropAtom;
import org.apache.poi.hslf.record.TextBytesAtom;
import org.apache.poi.hslf.record.TextCharsAtom;
import org.apache.poi.util.HexDump;

public final class SlideShowRecordDumper {
    private boolean optVerbose;
    private boolean optEscher;
    private HSLFSlideShow doc;

    public static void main(String[] args) throws IOException {
        int ndx;
        String filename = "";
        boolean verbose = false;
        boolean escher = false;
        for (ndx = 0; ndx < args.length && args[ndx].substring(0, 1).equals("-"); ++ndx) {
            if (args[ndx].equals("-escher")) {
                escher = true;
                continue;
            }
            if (args[ndx].equals("-verbose")) {
                verbose = true;
                continue;
            }
            SlideShowRecordDumper.printUsage();
            return;
        }
        if (ndx != args.length - 1) {
            SlideShowRecordDumper.printUsage();
            return;
        }
        filename = args[ndx];
        SlideShowRecordDumper foo = new SlideShowRecordDumper(filename, verbose, escher);
        foo.printDump();
    }

    public static void printUsage() {
        System.err.println("Usage: SlideShowRecordDumper [-escher] [-verbose] <filename>");
        System.err.println("Valid Options:");
        System.err.println("-escher\t\t: dump contents of escher records");
        System.err.println("-verbose\t: dump binary contents of each record");
    }

    public SlideShowRecordDumper(String fileName, boolean verbose, boolean escher) throws IOException {
        this.optVerbose = verbose;
        this.optEscher = escher;
        this.doc = new HSLFSlideShow(fileName);
    }

    public void printDump() throws IOException {
        this.walkTree(0, 0, this.doc.getRecords());
    }

    public String makeHex(int number, int padding) {
        String hex = Integer.toHexString(number).toUpperCase();
        while (hex.length() < padding) {
            hex = "0" + hex;
        }
        return hex;
    }

    public String reverseHex(String s) {
        StringBuffer ret = new StringBuffer();
        if (s.length() / 2 * 2 != s.length()) {
            s = "0" + s;
        }
        char[] c = s.toCharArray();
        for (int i = c.length; i > 0; i -= 2) {
            ret.append(c[i - 2]);
            ret.append(c[i - 1]);
            if (i == 2) continue;
            ret.append(' ');
        }
        return ret.toString();
    }

    public int getDiskLen(Record r) throws IOException {
        if (r == null) {
            return 0;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        r.writeOut(baos);
        byte[] b = baos.toByteArray();
        return b.length;
    }

    public String getPrintableRecordContents(Record r) throws IOException {
        if (r == null) {
            return "<<null>>";
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        r.writeOut(baos);
        byte[] b = baos.toByteArray();
        return HexDump.dump((byte[])b, (long)0L, (int)0);
    }

    public String printEscherRecord(EscherRecord er) {
        String nl = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        if (er instanceof EscherContainerRecord) {
            buf.append(this.printEscherContainerRecord((EscherContainerRecord)er));
        } else if (er instanceof EscherTextboxRecord) {
            buf.append("EscherTextboxRecord:" + nl);
            EscherTextboxWrapper etw = new EscherTextboxWrapper((EscherTextboxRecord)er);
            Record[] children = etw.getChildRecords();
            for (int j = 0; j < children.length; ++j) {
                if (children[j] instanceof StyleTextPropAtom) {
                    if (j > 0 && (children[j - 1] instanceof TextCharsAtom || children[j - 1] instanceof TextBytesAtom)) {
                        int size = children[j - 1] instanceof TextCharsAtom ? ((TextCharsAtom)children[j - 1]).getText().length() : ((TextBytesAtom)children[j - 1]).getText().length();
                        StyleTextPropAtom tsp = (StyleTextPropAtom)children[j];
                        tsp.setParentTextSize(size);
                    } else {
                        buf.append("Error! Couldn't find preceding TextAtom for style\n");
                    }
                    buf.append(children[j].toString() + nl);
                    continue;
                }
                buf.append(children[j].toString() + nl);
            }
        } else {
            buf.append(er.toString());
        }
        return buf.toString();
    }

    public String printEscherContainerRecord(EscherContainerRecord ecr) {
        String indent = "";
        String nl = System.getProperty("line.separator");
        StringBuffer children = new StringBuffer();
        if (ecr.getChildRecords().size() > 0) {
            children.append("  children: " + nl);
            int count = 0;
            Iterator iterator = ecr.getChildRecords().iterator();
            while (iterator.hasNext()) {
                String newIndent = "   ";
                EscherRecord record = (EscherRecord)iterator.next();
                children.append(newIndent + "Child " + count + ":" + nl);
                children.append(this.printEscherRecord(record));
                ++count;
            }
        }
        return indent + ecr.getClass().getName() + " (" + ecr.getRecordName() + "):" + nl + indent + "  isContainer: " + ecr.isContainerRecord() + nl + indent + "  options: 0x" + HexDump.toHex((short)ecr.getOptions()) + nl + indent + "  recordId: 0x" + HexDump.toHex((short)ecr.getRecordId()) + nl + indent + "  numchildren: " + ecr.getChildRecords().size() + nl + indent + children.toString();
    }

    public void walkTree(int depth, int pos, Record[] records) throws IOException {
        int i;
        int indent = depth;
        String ind = "";
        for (i = 0; i < indent; ++i) {
            ind = ind + " ";
        }
        for (i = 0; i < records.length; ++i) {
            Record r = records[i];
            if (r == null) {
                System.out.println(ind + "At position " + pos + " (" + this.makeHex(pos, 6) + "):");
                System.out.println(ind + "Warning! Null record found.");
                continue;
            }
            int len = this.getDiskLen(r);
            String hexType = this.makeHex((int)r.getRecordType(), 4);
            String rHexType = this.reverseHex(hexType);
            Class<?> c = r.getClass();
            String cname = c.toString();
            if (cname.startsWith("class ")) {
                cname = cname.substring(6);
            }
            if (cname.startsWith("org.apache.poi.hslf.record.")) {
                cname = cname.substring(27);
            }
            System.out.println(ind + "At position " + pos + " (" + this.makeHex(pos, 6) + "):");
            System.out.println(ind + " Record is of type " + cname);
            System.out.println(ind + " Type is " + r.getRecordType() + " (" + hexType + " -> " + rHexType + " )");
            System.out.println(ind + " Len is " + (len - 8) + " (" + this.makeHex(len - 8, 8) + "), on disk len is " + len);
            if (this.optEscher && cname.equals("PPDrawing")) {
                DefaultEscherRecordFactory factory = new DefaultEscherRecordFactory();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                r.writeOut(baos);
                byte[] b = baos.toByteArray();
                EscherRecord er = factory.createRecord(b, 0);
                er.fillFields(b, 0, (EscherRecordFactory)factory);
                System.out.println(this.printEscherRecord(er));
            } else if (this.optVerbose && r.getChildRecords() == null) {
                String recData = this.getPrintableRecordContents(r);
                System.out.println(ind + recData);
            }
            System.out.println();
            if (r.getChildRecords() != null) {
                this.walkTree(depth + 3, pos + 8, r.getChildRecords());
            }
            pos += len;
        }
    }
}

