/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ddf.EscherChildAnchorRecord;
import org.apache.poi.ddf.EscherClientAnchorRecord;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherOptRecord;
import org.apache.poi.ddf.EscherProperty;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherSimpleProperty;
import org.apache.poi.ddf.EscherSpRecord;
import org.apache.poi.hslf.model.Fill;
import org.apache.poi.hslf.model.Hyperlink;
import org.apache.poi.hslf.model.ShapeTypes;
import org.apache.poi.hslf.model.Sheet;
import org.apache.poi.hslf.record.ColorSchemeAtom;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public abstract class Shape {
    protected POILogger logger = POILogFactory.getLogger(this.getClass());
    public static final int EMU_PER_INCH = 914400;
    public static final int EMU_PER_POINT = 12700;
    public static final int EMU_PER_CENTIMETER = 360000;
    public static final int MASTER_DPI = 576;
    public static final int PIXEL_DPI = 96;
    public static final int POINT_DPI = 72;
    protected EscherContainerRecord _escherContainer;
    protected Shape _parent;
    protected Sheet _sheet;

    protected Shape(EscherContainerRecord escherRecord, Shape parent) {
        this._escherContainer = escherRecord;
        this._parent = parent;
    }

    protected abstract EscherContainerRecord createSpContainer(boolean var1);

    public Shape getParent() {
        return this._parent;
    }

    public String getShapeName() {
        return ShapeTypes.typeName(this.getShapeType());
    }

    public int getShapeType() {
        EscherSpRecord spRecord = this._escherContainer.getChildById((short)-4086);
        return spRecord.getOptions() >> 4;
    }

    public void setShapeType(int type) {
        EscherSpRecord spRecord = this._escherContainer.getChildById((short)-4086);
        spRecord.setOptions((short)(type << 4 | 2));
    }

    public Rectangle getAnchor() {
        EscherSpRecord spRecord = this._escherContainer.getChildById((short)-4086);
        int flags = spRecord.getFlags();
        Rectangle anchor = null;
        if ((flags & 2) != 0) {
            EscherChildAnchorRecord rec = (EscherChildAnchorRecord)Shape.getEscherChild(this._escherContainer, -4081);
            anchor = new Rectangle();
            anchor.x = rec.getDx1() * 72 / 576;
            anchor.y = rec.getDy1() * 72 / 576;
            anchor.width = rec.getDx2() * 72 / 576 - anchor.x;
            anchor.height = rec.getDy2() * 72 / 576 - anchor.y;
        } else {
            EscherClientAnchorRecord rec = (EscherClientAnchorRecord)Shape.getEscherChild(this._escherContainer, -4080);
            anchor = new Rectangle();
            anchor.y = rec.getFlag() * 72 / 576;
            anchor.x = rec.getCol1() * 72 / 576;
            anchor.width = (rec.getDx1() - rec.getCol1()) * 72 / 576;
            anchor.height = (rec.getRow1() - rec.getFlag()) * 72 / 576;
        }
        return anchor;
    }

    public void setAnchor(Rectangle anchor) {
        EscherSpRecord spRecord = this._escherContainer.getChildById((short)-4086);
        int flags = spRecord.getFlags();
        if ((flags & 2) != 0) {
            EscherChildAnchorRecord rec = (EscherChildAnchorRecord)Shape.getEscherChild(this._escherContainer, -4081);
            rec.setDx1(anchor.x * 576 / 72);
            rec.setDy1(anchor.y * 576 / 72);
            rec.setDx2((anchor.width + anchor.x) * 576 / 72);
            rec.setDy2((anchor.height + anchor.y) * 576 / 72);
        } else {
            EscherClientAnchorRecord rec = (EscherClientAnchorRecord)Shape.getEscherChild(this._escherContainer, -4080);
            rec.setFlag((short)(anchor.y * 576 / 72));
            rec.setCol1((short)(anchor.x * 576 / 72));
            rec.setDx1((short)((anchor.width + anchor.x) * 576 / 72));
            rec.setRow1((short)((anchor.height + anchor.y) * 576 / 72));
        }
    }

    public void moveTo(int x, int y) {
        Rectangle anchor = this.getAnchor();
        anchor.setLocation(x, y);
        this.setAnchor(anchor);
    }

    public static EscherRecord getEscherChild(EscherContainerRecord owner, int recordId) {
        Iterator iterator = owner.getChildRecords().iterator();
        while (iterator.hasNext()) {
            EscherRecord escherRecord = (EscherRecord)iterator.next();
            if (escherRecord.getRecordId() != recordId) continue;
            return escherRecord;
        }
        return null;
    }

    public static EscherProperty getEscherProperty(EscherOptRecord opt, int propId) {
        Iterator iterator = opt.getEscherProperties().iterator();
        while (iterator.hasNext()) {
            EscherProperty prop = (EscherProperty)iterator.next();
            if (prop.getId() != propId) continue;
            return prop;
        }
        return null;
    }

    public static void setEscherProperty(EscherOptRecord opt, short propId, int value) {
        List props = opt.getEscherProperties();
        Iterator iterator = props.iterator();
        while (iterator.hasNext()) {
            EscherProperty prop = (EscherProperty)iterator.next();
            if (prop.getId() != propId) continue;
            iterator.remove();
        }
        if (value != -1) {
            opt.addEscherProperty((EscherProperty)new EscherSimpleProperty(propId, value));
            opt.sortProperties();
        }
    }

    public EscherContainerRecord getSpContainer() {
        return this._escherContainer;
    }

    protected void afterInsert(Sheet sh) {
    }

    public Sheet getSheet() {
        return this._sheet;
    }

    public void setSheet(Sheet sheet) {
        this._sheet = sheet;
    }

    protected Color getColor(int rgb) {
        if (rgb >= 0x8000000) {
            int idx = rgb - 0x8000000;
            ColorSchemeAtom ca = this.getSheet().getColorScheme();
            if (idx >= 0 && idx <= 7) {
                rgb = ca.getColor(idx);
            }
        }
        Color tmp = new Color(rgb, true);
        return new Color(tmp.getBlue(), tmp.getGreen(), tmp.getRed());
    }

    public Fill getFill() {
        return new Fill(this);
    }

    public Hyperlink getHyperlink() {
        return Hyperlink.find(this);
    }
}

