/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.examples.html;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.examples.html.HSSFHtmlHelper;
import org.apache.poi.ss.examples.html.HtmlHelper;
import org.apache.poi.ss.examples.html.XSSFHtmlHelper;
import org.apache.poi.ss.format.CellFormat;
import org.apache.poi.ss.format.CellFormatResult;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ToHtml {
    private final Workbook wb;
    private final Appendable output;
    private boolean completeHTML;
    private Formatter out;
    private boolean gotBounds;
    private int firstColumn;
    private int endColumn;
    private HtmlHelper helper;
    private static final String DEFAULTS_CLASS = "excelDefaults";
    private static final String COL_HEAD_CLASS = "colHeader";
    private static final String ROW_HEAD_CLASS = "rowHeader";
    private static final Map<Short, String> ALIGN = ToHtml.mapFor((short)1, "left", (short)2, "center", (short)3, "right", (short)4, "left", (short)5, "left", (short)6, "center");
    private static final Map<Short, String> VERTICAL_ALIGN = ToHtml.mapFor((short)2, "bottom", (short)1, "middle", (short)0, "top");
    private static final Map<Short, String> BORDER = ToHtml.mapFor((short)9, "dashed 1pt", (short)11, "dashed 1pt", (short)3, "dashed 1pt", (short)4, "dotted 1pt", (short)6, "double 3pt", (short)7, "solid 1px", (short)2, "solid 2pt", (short)10, "dashed 2pt", (short)12, "dashed 2pt", (short)8, "dashed 2pt", (short)0, "none", (short)13, "dashed 2pt", (short)5, "solid 3pt", (short)1, "dashed 1pt");

    private static <K, V> Map<K, V> mapFor(Object ... mapping) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < mapping.length; i += 2) {
            map.put(mapping[i], mapping[i + 1]);
        }
        return map;
    }

    public static ToHtml create(Workbook wb, Appendable output) {
        return new ToHtml(wb, output);
    }

    public static ToHtml create(String path, Appendable output) throws IOException {
        return ToHtml.create(new FileInputStream(path), output);
    }

    public static ToHtml create(InputStream in, Appendable output) throws IOException {
        try {
            Workbook wb = WorkbookFactory.create((InputStream)in);
            return ToHtml.create(wb, output);
        }
        catch (InvalidFormatException e) {
            throw new IllegalArgumentException("Cannot create workbook from stream", e);
        }
    }

    private ToHtml(Workbook wb, Appendable output) {
        if (wb == null) {
            throw new NullPointerException("wb");
        }
        if (output == null) {
            throw new NullPointerException("output");
        }
        this.wb = wb;
        this.output = output;
        this.setupColorMap();
    }

    private void setupColorMap() {
        if (this.wb instanceof HSSFWorkbook) {
            this.helper = new HSSFHtmlHelper((HSSFWorkbook)this.wb);
        } else if (this.wb instanceof XSSFWorkbook) {
            this.helper = new XSSFHtmlHelper((XSSFWorkbook)this.wb);
        } else {
            throw new IllegalArgumentException("unknown workbook type: " + this.wb.getClass().getSimpleName());
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("usage: ToHtml inputWorkbook outputHtmlFile");
            return;
        }
        ToHtml toHtml = ToHtml.create(args[0], (Appendable)new PrintWriter(new FileWriter(args[1])));
        toHtml.setCompleteHTML(true);
        toHtml.printPage();
    }

    public void setCompleteHTML(boolean completeHTML) {
        this.completeHTML = completeHTML;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printPage() throws IOException {
        try {
            this.ensureOut();
            if (this.completeHTML) {
                this.out.format("<?xml version=\"1.0\" encoding=\"iso-8859-1\" ?>%n", new Object[0]);
                this.out.format("<html>%n", new Object[0]);
                this.out.format("<head>%n", new Object[0]);
                this.out.format("</head>%n", new Object[0]);
                this.out.format("<body>%n", new Object[0]);
            }
            this.print();
            if (this.completeHTML) {
                this.out.format("</body>%n", new Object[0]);
                this.out.format("</html>%n", new Object[0]);
            }
        }
        finally {
            if (this.out != null) {
                this.out.close();
            }
            if (this.output instanceof Closeable) {
                Closeable closeable = (Closeable)((Object)this.output);
                closeable.close();
            }
        }
    }

    public void print() {
        this.printInlineStyle();
        this.printSheets();
    }

    private void printInlineStyle() {
        this.out.format("<style type=\"text/css\">%n", new Object[0]);
        this.printStyles();
        this.out.format("</style>%n", new Object[0]);
    }

    private void ensureOut() {
        if (this.out == null) {
            this.out = new Formatter(this.output);
        }
    }

    public void printStyles() {
        this.ensureOut();
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("excelStyle.css")));
            while ((line = in.readLine()) != null) {
                this.out.format("%s%n", line);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Reading standard css", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Reading standard css", e);
                }
            }
        }
        HashSet<CellStyle> seen = new HashSet<CellStyle>();
        for (int i = 0; i < this.wb.getNumberOfSheets(); ++i) {
            Sheet sheet = this.wb.getSheetAt(i);
            Iterator rows = sheet.rowIterator();
            while (rows.hasNext()) {
                Row row = (Row)rows.next();
                for (Cell cell : row) {
                    CellStyle style = cell.getCellStyle();
                    if (seen.contains(style)) continue;
                    this.printStyle(style);
                    seen.add(style);
                }
            }
        }
    }

    private void printStyle(CellStyle style) {
        this.out.format(".%s .%s {%n", DEFAULTS_CLASS, this.styleName(style));
        this.styleContents(style);
        this.out.format("}%n", new Object[0]);
    }

    private void styleContents(CellStyle style) {
        this.styleOut("text-align", style.getAlignment(), ALIGN);
        this.styleOut("vertical-align", style.getAlignment(), VERTICAL_ALIGN);
        this.fontStyle(style);
        this.borderStyles(style);
        this.helper.colorStyles(style, this.out);
    }

    private void borderStyles(CellStyle style) {
        this.styleOut("border-left", style.getBorderLeft(), BORDER);
        this.styleOut("border-right", style.getBorderRight(), BORDER);
        this.styleOut("border-top", style.getBorderTop(), BORDER);
        this.styleOut("border-bottom", style.getBorderBottom(), BORDER);
    }

    private void fontStyle(CellStyle style) {
        int fontheight;
        Font font = this.wb.getFontAt(style.getFontIndex());
        if (font.getBoldweight() >= 700) {
            this.out.format("  font-weight: bold;%n", new Object[0]);
        }
        if (font.getItalic()) {
            this.out.format("  font-style: italic;%n", new Object[0]);
        }
        if ((fontheight = font.getFontHeightInPoints()) == 9) {
            fontheight = 10;
        }
        this.out.format("  font-size: %dpt;%n", fontheight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String styleName(CellStyle style) {
        if (style == null) {
            style = this.wb.getCellStyleAt((short)0);
        }
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb);
        try {
            fmt.format("style_%02x", style.getIndex());
            String string = fmt.toString();
            return string;
        }
        finally {
            fmt.close();
        }
    }

    private <K> void styleOut(String attr, K key, Map<K, String> mapping) {
        String value = mapping.get(key);
        if (value != null) {
            this.out.format("  %s: %s;%n", attr, value);
        }
    }

    private static int ultimateCellType(Cell c) {
        int type = c.getCellType();
        if (type == 2) {
            type = c.getCachedFormulaResultType();
        }
        return type;
    }

    private void printSheets() {
        this.ensureOut();
        Sheet sheet = this.wb.getSheetAt(0);
        this.printSheet(sheet);
    }

    public void printSheet(Sheet sheet) {
        this.ensureOut();
        this.out.format("<table class=%s>%n", DEFAULTS_CLASS);
        this.printCols(sheet);
        this.printSheetContent(sheet);
        this.out.format("</table>%n", new Object[0]);
    }

    private void printCols(Sheet sheet) {
        this.out.format("<col/>%n", new Object[0]);
        this.ensureColumnBounds(sheet);
        for (int i = this.firstColumn; i < this.endColumn; ++i) {
            this.out.format("<col/>%n", new Object[0]);
        }
    }

    private void ensureColumnBounds(Sheet sheet) {
        if (this.gotBounds) {
            return;
        }
        Iterator iter = sheet.rowIterator();
        this.firstColumn = iter.hasNext() ? Integer.MAX_VALUE : 0;
        this.endColumn = 0;
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            short firstCell = row.getFirstCellNum();
            if (firstCell < 0) continue;
            this.firstColumn = Math.min(this.firstColumn, firstCell);
            this.endColumn = Math.max(this.endColumn, row.getLastCellNum());
        }
        this.gotBounds = true;
    }

    private void printColumnHeads() {
        this.out.format("<thead>%n", new Object[0]);
        this.out.format("  <tr class=%s>%n", COL_HEAD_CLASS);
        this.out.format("    <th class=%s>&#x25CA;</th>%n", COL_HEAD_CLASS);
        StringBuilder colName = new StringBuilder();
        for (int i = this.firstColumn; i < this.endColumn; ++i) {
            colName.setLength(0);
            int cnum = i;
            do {
                colName.insert(0, (char)(65 + cnum % 26));
            } while ((cnum /= 26) > 0);
            this.out.format("    <th class=%s>%s</th>%n", COL_HEAD_CLASS, colName);
        }
        this.out.format("  </tr>%n", new Object[0]);
        this.out.format("</thead>%n", new Object[0]);
    }

    private void printSheetContent(Sheet sheet) {
        this.printColumnHeads();
        this.out.format("<tbody>%n", new Object[0]);
        Iterator rows = sheet.rowIterator();
        while (rows.hasNext()) {
            Row row = (Row)rows.next();
            this.out.format("  <tr>%n", new Object[0]);
            this.out.format("    <td class=%s>%d</td>%n", ROW_HEAD_CLASS, row.getRowNum() + 1);
            for (int i = this.firstColumn; i < this.endColumn; ++i) {
                Cell cell;
                String content = "&nbsp;";
                String attrs = "";
                CellStyle style = null;
                if (i >= row.getFirstCellNum() && i < row.getLastCellNum() && (cell = row.getCell(i)) != null) {
                    style = cell.getCellStyle();
                    attrs = this.tagStyle(cell, style);
                    CellFormat cf = CellFormat.getInstance((String)style.getDataFormatString());
                    CellFormatResult result = cf.apply(cell);
                    content = result.text;
                    if (content.equals("")) {
                        content = "&nbsp;";
                    }
                }
                this.out.format("    <td class=%s %s>%s</td>%n", this.styleName(style), attrs, content);
            }
            this.out.format("  </tr>%n", new Object[0]);
        }
        this.out.format("</tbody>%n", new Object[0]);
    }

    private String tagStyle(Cell cell, CellStyle style) {
        if (style.getAlignment() == 0) {
            switch (ToHtml.ultimateCellType(cell)) {
                case 1: {
                    return "style=\"text-align: left;\"";
                }
                case 4: 
                case 5: {
                    return "style=\"text-align: center;\"";
                }
            }
        }
        return "";
    }
}

