/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.Graphics2D;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.TextPane;
import org.apache.pivot.wtk.skin.TextPaneSkin;
import org.apache.pivot.wtk.skin.TextPaneSkinElementView;
import org.apache.pivot.wtk.text.Element;
import org.apache.pivot.wtk.text.Node;
import org.apache.pivot.wtk.text.NodeListener;

abstract class TextPaneSkinNodeView
implements NodeListener {
    private Node node = null;
    private TextPaneSkinElementView parent = null;
    private int width = 0;
    private int height = 0;
    private int x = 0;
    private int y = 0;
    private int previousBreakWidth = -1;
    private boolean valid = false;

    public TextPaneSkinNodeView(Node node) {
        this.node = node;
    }

    public Node getNode() {
        return this.node;
    }

    public TextPaneSkinElementView getParent() {
        return this.parent;
    }

    protected void setParent(TextPaneSkinElementView parent) {
        this.parent = parent;
    }

    protected TextPaneSkin getTextPaneSkin() {
        return this.getParent().getTextPaneSkin();
    }

    protected void attach() {
        this.node.getNodeListeners().add((Object)this);
    }

    protected void detach() {
        this.node.getNodeListeners().remove((Object)this);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public abstract int getBaseline();

    public abstract void paint(Graphics2D var1);

    public Dimensions getSize() {
        return new Dimensions(this.width, this.height);
    }

    protected void setSize(int width, int height) {
        assert (width >= 0);
        assert (height >= 0);
        this.repaint();
        this.width = width;
        this.height = height;
        this.repaint();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    protected void setLocation(int x, int y) {
        this.repaint();
        this.x = x;
        this.y = y;
        this.repaint();
    }

    protected abstract void setSkinLocation(int var1, int var2);

    public Bounds getBounds() {
        return new Bounds(this.x, this.y, this.width, this.height);
    }

    public void repaint() {
        this.repaint(0, 0, this.width, this.height);
    }

    public void repaint(int xArgument, int yArgument, int widthArgument, int heightArgument) {
        assert (widthArgument >= 0);
        assert (heightArgument >= 0);
        if (this.parent != null) {
            this.parent.repaint(xArgument + this.x, yArgument + this.y, widthArgument, heightArgument);
        }
    }

    public final boolean isValid() {
        return this.valid;
    }

    public void invalidateUpTree() {
        this.valid = false;
        if (this.parent != null) {
            this.parent.invalidateUpTree();
        }
    }

    public void invalidateDownTree() {
        this.valid = false;
    }

    public final void layout(int breakWidth) {
        if (!this.valid || this.previousBreakWidth != breakWidth) {
            this.childLayout(breakWidth);
            this.valid = true;
            this.previousBreakWidth = breakWidth;
        }
    }

    public abstract Dimensions getPreferredSize(int var1);

    protected abstract void childLayout(int var1);

    public int getOffset() {
        return this.node.getOffset();
    }

    public int getDocumentOffset() {
        return this.parent == null ? 0 : this.parent.getDocumentOffset() + this.getOffset();
    }

    public int getCharacterCount() {
        return this.node.getCharacterCount();
    }

    public abstract int getInsertionPoint(int var1, int var2);

    public abstract int getNextInsertionPoint(int var1, int var2, TextPane.ScrollDirection var3);

    public abstract int getRowAt(int var1);

    public abstract int getRowCount();

    public abstract Bounds getCharacterBounds(int var1);

    @Override
    public void parentChanged(Node nodeArgument, Element previousParent) {
    }

    @Override
    public void offsetChanged(Node nodeArgument, int previousOffset) {
    }

    @Override
    public void rangeInserted(Node nodeArgument, int offset, int span) {
    }

    @Override
    public void rangeRemoved(Node nodeArgument, int offset, int characterCount) {
    }

    @Override
    public void nodesRemoved(Node nodeArgument, Sequence<Node> removed, int offset) {
    }

    @Override
    public void nodeInserted(Node nodeArgument, int offset) {
    }
}

