/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.Graphics2D;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.TextPane;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.media.ImageListener;
import org.apache.pivot.wtk.skin.TextPaneSkinNodeView;
import org.apache.pivot.wtk.text.ImageNode;
import org.apache.pivot.wtk.text.ImageNodeListener;

class TextPaneSkinImageNodeView
extends TextPaneSkinNodeView
implements ImageNodeListener,
ImageListener {
    public TextPaneSkinImageNodeView(ImageNode imageNode) {
        super(imageNode);
    }

    @Override
    protected void attach() {
        super.attach();
        ImageNode imageNode = (ImageNode)this.getNode();
        imageNode.getImageNodeListeners().add((Object)this);
        Image image = imageNode.getImage();
        if (image != null) {
            image.getImageListeners().add((Object)this);
        }
    }

    @Override
    protected void detach() {
        super.detach();
        ImageNode imageNode = (ImageNode)this.getNode();
        imageNode.getImageNodeListeners().remove((Object)this);
    }

    @Override
    protected void childLayout(int breakWidth) {
        ImageNode imageNode = (ImageNode)this.getNode();
        Image image = imageNode.getImage();
        if (image == null) {
            this.setSize(0, 0);
        } else {
            this.setSize(image.getWidth(), image.getHeight());
        }
    }

    @Override
    public Dimensions getPreferredSize(int breakWidth) {
        ImageNode imageNode = (ImageNode)this.getNode();
        Image image = imageNode.getImage();
        if (image == null) {
            return new Dimensions(0, 0);
        }
        return new Dimensions(image.getWidth(), image.getHeight());
    }

    @Override
    protected void setSkinLocation(int skinX, int skinY) {
    }

    @Override
    public int getBaseline() {
        ImageNode imageNode = (ImageNode)this.getNode();
        Image image = imageNode.getImage();
        int baseline = -1;
        if (image != null) {
            baseline = image.getBaseline();
        }
        return baseline;
    }

    @Override
    public void paint(Graphics2D graphics) {
        ImageNode imageNode = (ImageNode)this.getNode();
        Image image = imageNode.getImage();
        if (image != null) {
            image.paint(graphics);
        }
    }

    @Override
    public int getInsertionPoint(int x, int y) {
        return 0;
    }

    @Override
    public int getNextInsertionPoint(int x, int from, TextPane.ScrollDirection direction) {
        return from == -1 ? 0 : -1;
    }

    @Override
    public int getRowAt(int offset) {
        return -1;
    }

    @Override
    public int getRowCount() {
        return 0;
    }

    @Override
    public Bounds getCharacterBounds(int offset) {
        return new Bounds(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public void imageChanged(ImageNode imageNode, Image previousImage) {
        this.invalidateUpTree();
        Image image = imageNode.getImage();
        if (image != null) {
            image.getImageListeners().add((Object)this);
        }
        if (previousImage != null) {
            previousImage.getImageListeners().remove((Object)this);
        }
    }

    @Override
    public void sizeChanged(Image image, int previousWidth, int previousHeight) {
        this.invalidateUpTree();
    }

    @Override
    public void baselineChanged(Image image, int previousBaseline) {
    }

    @Override
    public void regionUpdated(Image image, int x, int y, int width, int height) {
        this.repaint(x, y, width, height);
    }
}

