/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.Color;
import java.awt.Graphics2D;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.MovieView;
import org.apache.pivot.wtk.MovieViewListener;
import org.apache.pivot.wtk.VerticalAlignment;
import org.apache.pivot.wtk.media.Movie;
import org.apache.pivot.wtk.media.MovieListener;
import org.apache.pivot.wtk.skin.ComponentSkin;

public class MovieViewSkin
extends ComponentSkin
implements MovieViewListener {
    private Color backgroundColor = null;
    private float scale = 1.0f;
    private HorizontalAlignment horizontalAlignment = HorizontalAlignment.CENTER;
    private VerticalAlignment verticalAlignment = VerticalAlignment.CENTER;
    private int movieX = 0;
    private int movieY = 0;
    private MovieListener movieListener = new MovieListener.Adapter(){

        @Override
        public void sizeChanged(Movie movie, int previousWidth, int previousHeight) {
            MovieViewSkin.this.invalidateComponent();
        }

        @Override
        public void regionUpdated(Movie movie, int x, int y, int width, int height) {
            MovieViewSkin.this.repaintComponent(MovieViewSkin.this.movieX + (int)Math.floor((float)x * MovieViewSkin.this.scale), MovieViewSkin.this.movieY + (int)Math.floor((float)y * MovieViewSkin.this.scale), (int)Math.ceil((float)width * MovieViewSkin.this.scale) + 1, (int)Math.ceil((float)height * MovieViewSkin.this.scale) + 1);
        }
    };

    @Override
    public void install(Component component) {
        super.install(component);
        MovieView movieView = (MovieView)component;
        movieView.getMovieViewListeners().add((Object)this);
        Movie movie = movieView.getMovie();
        if (movie != null) {
            movie.getMovieListeners().add((Object)this.movieListener);
        }
    }

    @Override
    public int getPreferredWidth(int height) {
        MovieView movieView = (MovieView)this.getComponent();
        Movie movie = movieView.getMovie();
        return movie == null ? 0 : Math.round((float)movie.getWidth() * this.scale);
    }

    @Override
    public int getPreferredHeight(int width) {
        MovieView movieView = (MovieView)this.getComponent();
        Movie movie = movieView.getMovie();
        return movie == null ? 0 : Math.round((float)movie.getHeight() * this.scale);
    }

    @Override
    public Dimensions getPreferredSize() {
        MovieView movieView = (MovieView)this.getComponent();
        Movie movie = movieView.getMovie();
        return movie == null ? new Dimensions(0, 0) : new Dimensions(Math.round((float)movie.getWidth() * this.scale), Math.round((float)movie.getHeight() * this.scale));
    }

    @Override
    public void layout() {
        MovieView movieView = (MovieView)this.getComponent();
        Movie movie = movieView.getMovie();
        if (movie != null) {
            int width = this.getWidth();
            int height = this.getHeight();
            int movieWidth = movie.getWidth();
            int movieHeight = movie.getHeight();
            switch (this.horizontalAlignment) {
                case CENTER: {
                    this.movieX = (width - movieWidth) / 2;
                    break;
                }
                case RIGHT: {
                    this.movieX = width - movieWidth;
                    break;
                }
                default: {
                    this.movieX = 0;
                }
            }
            switch (this.verticalAlignment) {
                case CENTER: {
                    this.movieY = (height - movieHeight) / 2;
                    break;
                }
                case BOTTOM: {
                    this.movieY = height - movieHeight;
                    break;
                }
                default: {
                    this.movieY = 0;
                }
            }
        }
    }

    @Override
    public void paint(Graphics2D graphics) {
        MovieView movieView = (MovieView)this.getComponent();
        Movie movie = movieView.getMovie();
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.backgroundColor != null) {
            graphics.setPaint(this.backgroundColor);
            graphics.fillRect(0, 0, width, height);
        }
        if (movie != null) {
            if (this.scale != 1.0f) {
                graphics.scale(this.scale, this.scale);
            }
            graphics.translate(this.movieX, this.movieY);
            movie.paint(graphics);
        }
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public boolean isOpaque() {
        return this.backgroundColor != null && this.backgroundColor.getTransparency() == 1;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.repaintComponent();
    }

    public final void setBackgroundColor(String backgroundColor) {
        if (backgroundColor == null) {
            throw new IllegalArgumentException("backgroundColor is null.");
        }
        this.setBackgroundColor(GraphicsUtilities.decodeColor(backgroundColor));
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        if (scale <= 0.0f) {
            throw new IllegalArgumentException("scale must be positive.");
        }
        this.scale = scale;
        this.invalidateComponent();
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        if (horizontalAlignment == null) {
            throw new IllegalArgumentException("horizontalAlignment is null.");
        }
        if (this.horizontalAlignment != horizontalAlignment) {
            this.horizontalAlignment = horizontalAlignment;
            this.layout();
            this.repaintComponent();
        }
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        if (verticalAlignment == null) {
            throw new IllegalArgumentException("verticalAlignment is null.");
        }
        if (this.verticalAlignment != verticalAlignment) {
            this.verticalAlignment = verticalAlignment;
            this.layout();
            this.repaintComponent();
        }
    }

    @Override
    public void movieChanged(MovieView movieView, Movie previousMovie) {
        Movie movie;
        if (previousMovie != null) {
            previousMovie.getMovieListeners().remove((Object)this.movieListener);
        }
        if ((movie = movieView.getMovie()) != null) {
            movie.getMovieListeners().add((Object)this.movieListener);
        }
        this.invalidateComponent();
    }
}

