/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import org.apache.pivot.wtk.Action;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ButtonGroup;
import org.apache.pivot.wtk.ButtonListener;
import org.apache.pivot.wtk.ButtonPressListener;
import org.apache.pivot.wtk.ButtonStateListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Cursor;
import org.apache.pivot.wtk.skin.ComponentSkin;

public abstract class ButtonSkin
extends ComponentSkin
implements ButtonListener,
ButtonStateListener,
ButtonPressListener {
    protected boolean highlighted = false;

    @Override
    public void install(Component component) {
        super.install(component);
        Button button = (Button)component;
        button.getButtonListeners().add((Object)this);
        button.getButtonStateListeners().add((Object)this);
        button.getButtonPressListeners().add((Object)this);
        button.setCursor(Cursor.HAND);
    }

    @Override
    public void layout() {
    }

    @Override
    public void enabledChanged(Component component) {
        super.enabledChanged(component);
        this.highlighted = false;
        this.repaintComponent();
    }

    @Override
    public void focusedChanged(Component component, Component obverseComponent) {
        super.focusedChanged(component, obverseComponent);
        this.repaintComponent();
    }

    @Override
    public void mouseOver(Component component) {
        super.mouseOver(component);
        this.highlighted = true;
        this.repaintComponent();
    }

    @Override
    public void mouseOut(Component component) {
        super.mouseOut(component);
        this.highlighted = false;
        this.repaintComponent();
    }

    @Override
    public void buttonDataChanged(Button button, Object previousButtonData) {
        this.invalidateComponent();
    }

    @Override
    public void dataRendererChanged(Button button, Button.DataRenderer previousDataRenderer) {
        this.invalidateComponent();
    }

    @Override
    public void actionChanged(Button button, Action previousAction) {
    }

    @Override
    public void toggleButtonChanged(Button button) {
    }

    @Override
    public void triStateChanged(Button button) {
    }

    @Override
    public void buttonGroupChanged(Button button, ButtonGroup previousButtonGroup) {
    }

    @Override
    public void stateChanged(Button button, Button.State previousState) {
        this.repaintComponent();
    }

    @Override
    public void buttonPressed(Button button) {
    }
}

