/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.media;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.serialization.Serializer;

public class BufferedImageSerializer
implements Serializer<BufferedImage> {
    private Format outputFormat;

    public BufferedImageSerializer() {
        this(Format.PNG);
    }

    public BufferedImageSerializer(Format outputFormat) {
        this.setOutputFormat(outputFormat);
    }

    public Format getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(Format outputFormat) {
        if (outputFormat == null) {
            throw new IllegalArgumentException("Output format is null.");
        }
        this.outputFormat = outputFormat;
    }

    public BufferedImage readObject(InputStream inputStream) throws IOException, SerializationException {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream is null.");
        }
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        return bufferedImage;
    }

    public void writeObject(BufferedImage bufferedImage, OutputStream outputStream) throws IOException, SerializationException {
        if (bufferedImage == null) {
            throw new IllegalArgumentException("bufferedImage is null.");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream is null.");
        }
        ImageIO.write((RenderedImage)bufferedImage, this.outputFormat.getName(), outputStream);
    }

    public String getMIMEType(BufferedImage bufferedImage) {
        return this.outputFormat.getMIMEType();
    }

    public static enum Format {
        PNG("png", "image/png"),
        JPEG("jpeg", "image/jpeg"),
        BMP("bmp", "image/bmp"),
        WBMP("wbmp", "image/vnd.wap.wbmp"),
        GIF("gif", "image/gif");

        private String name;
        private String mimeType;

        private Format(String name, String mimeType) {
            this.name = name;
            this.mimeType = mimeType;
        }

        public String getName() {
            return this.name;
        }

        public String getMIMEType() {
            return this.mimeType;
        }
    }
}

