/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.effects;

import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.effects.TransitionListener;

public abstract class Transition {
    private int duration;
    private int rate;
    private boolean repeating;
    private boolean reversed = false;
    private TransitionListener transitionListener;
    private long startTime = 0L;
    private long currentTime = 0L;
    private ApplicationContext.ScheduledCallback transitionCallback = null;
    private final Runnable updateCallback = new Runnable(){

        @Override
        public void run() {
            Transition.this.currentTime = System.currentTimeMillis();
            long endTime = Transition.this.startTime + (long)Transition.this.duration;
            if (Transition.this.currentTime >= endTime) {
                if (Transition.this.repeating) {
                    Transition.this.startTime = endTime;
                } else {
                    Transition.this.currentTime = endTime;
                    Transition.this.stop();
                    if (Transition.this.transitionListener != null) {
                        Transition.this.transitionListener.transitionCompleted(Transition.this);
                    }
                }
            }
            Transition.this.update();
        }
    };

    public Transition(int duration, int rate) {
        this(duration, rate, false);
    }

    public Transition(int duration, int rate, boolean repeating) {
        this(duration, rate, repeating, false);
    }

    public Transition(int duration, int rate, boolean repeating, boolean reversed) {
        if (duration <= 0) {
            throw new IllegalArgumentException("duration must be positive.");
        }
        this.duration = duration;
        this.rate = rate;
        this.repeating = repeating;
        this.reversed = reversed;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        if (duration < 0) {
            throw new IllegalArgumentException("duration is negative.");
        }
        if (this.transitionCallback != null) {
            throw new IllegalStateException("Transition is currently running.");
        }
        this.duration = duration;
    }

    public int getRate() {
        return this.rate;
    }

    public void setRate(int rate) {
        if (rate < 0) {
            throw new IllegalArgumentException("rate is negative.");
        }
        if (this.transitionCallback != null) {
            throw new IllegalStateException("Transition is currently running.");
        }
        this.rate = rate;
    }

    public int getInterval() {
        return (int)(1.0f / (float)this.rate * 1000.0f);
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getCurrentTime() {
        return this.currentTime;
    }

    public int getElapsedTime() {
        long endTime = this.startTime + (long)this.duration;
        int elapsedTime = this.reversed ? (int)(endTime - this.currentTime) : (int)(this.currentTime - this.startTime);
        return elapsedTime;
    }

    public float getPercentComplete() {
        float percentComplete = (float)(this.currentTime - this.startTime) / (float)this.duration;
        if (this.reversed) {
            percentComplete = 1.0f - percentComplete;
        }
        return percentComplete;
    }

    public boolean isRunning() {
        return this.transitionCallback != null;
    }

    public final void start() {
        this.start(null);
    }

    public void start(TransitionListener transitionListenerArgument) {
        if (this.transitionCallback != null) {
            throw new IllegalStateException("Transition is currently running.");
        }
        this.transitionListener = transitionListenerArgument;
        this.currentTime = this.startTime = System.currentTimeMillis();
        this.transitionCallback = ApplicationContext.scheduleRecurringCallback(this.updateCallback, this.getInterval());
        this.update();
    }

    public void stop() {
        if (this.transitionCallback != null) {
            this.transitionCallback.cancel();
        }
        this.transitionCallback = null;
    }

    public void end() {
        if (this.transitionCallback != null) {
            this.currentTime = this.startTime + (long)this.duration;
            this.stop();
            this.update();
            this.transitionListener.transitionCompleted(this);
        }
    }

    protected abstract void update();

    public boolean isRepeating() {
        return this.repeating;
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    public void reverse() {
        if (this.isRunning()) {
            long repeatDuration = this.currentTime - this.startTime;
            long endTime = this.currentTime + repeatDuration;
            this.startTime = endTime - (long)this.duration;
        }
        this.setReversed(!this.isReversed());
    }
}

