/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.effects;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.VerticalAlignment;
import org.apache.pivot.wtk.Visual;
import org.apache.pivot.wtk.effects.Decorator;

public class TagDecorator
implements Decorator {
    private Visual tag;
    private HorizontalAlignment horizontalAlignment;
    private VerticalAlignment verticalAlignment;
    private int xOffset;
    private int yOffset;
    private Graphics2D graphics = null;
    private Bounds bounds = null;

    public TagDecorator() {
        this(null);
    }

    public TagDecorator(Visual tag) {
        this(tag, HorizontalAlignment.RIGHT, VerticalAlignment.TOP, 0, 0);
    }

    public TagDecorator(Visual tag, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, int xOffset, int yOffset) {
        if (horizontalAlignment == null) {
            throw new IllegalArgumentException("horizontalAlignment is null.");
        }
        if (verticalAlignment == null) {
            throw new IllegalArgumentException("verticalAlignment is null.");
        }
        this.tag = tag;
        this.horizontalAlignment = horizontalAlignment;
        this.verticalAlignment = verticalAlignment;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public Visual getTag() {
        return this.tag;
    }

    public void setTag(Visual tag) {
        this.tag = tag;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        if (horizontalAlignment == null) {
            throw new IllegalArgumentException("horizontalAlignment is null.");
        }
        this.horizontalAlignment = horizontalAlignment;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        if (verticalAlignment == null) {
            throw new IllegalArgumentException("verticalAlignment is null.");
        }
        this.verticalAlignment = verticalAlignment;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public void setXOffset(int xOffset) {
        this.xOffset = xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public void setYOffset(int yOffset) {
        this.yOffset = yOffset;
    }

    @Override
    public Graphics2D prepare(Component component, Graphics2D graphicsArgument) {
        if (this.tag != null) {
            this.bounds = this.getBounds(component);
            this.graphics = graphicsArgument;
        }
        return graphicsArgument;
    }

    @Override
    public void update() {
        if (this.tag != null) {
            this.graphics.translate(this.bounds.x, this.bounds.y);
            this.tag.paint(this.graphics);
        }
        this.graphics = null;
    }

    @Override
    public Bounds getBounds(Component component) {
        Bounds boundsLocal;
        if (this.tag == null) {
            boundsLocal = null;
        } else {
            int y;
            int x;
            switch (this.horizontalAlignment) {
                case LEFT: {
                    x = this.xOffset;
                    break;
                }
                case RIGHT: {
                    x = component.getWidth() - this.tag.getWidth() + this.xOffset;
                    break;
                }
                case CENTER: {
                    x = (component.getWidth() - this.tag.getWidth()) / 2 + this.xOffset;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            switch (this.verticalAlignment) {
                case TOP: {
                    y = this.yOffset;
                    break;
                }
                case BOTTOM: {
                    y = component.getHeight() - this.tag.getHeight() + this.yOffset;
                    break;
                }
                case CENTER: {
                    y = (component.getHeight() - this.tag.getHeight()) / 2 + this.yOffset;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            boundsLocal = new Bounds(x, y, this.tag.getWidth(), this.tag.getHeight());
        }
        return boundsLocal;
    }

    @Override
    public AffineTransform getTransform(Component component) {
        return new AffineTransform();
    }
}

