/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.effects;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.WritableRaster;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.effects.Decorator;

public class GrayscaleDecorator
implements Decorator {
    private Graphics2D graphics = null;
    private BufferedImage bufferedImage = null;
    private Graphics2D bufferedImageGraphics = null;

    @Override
    public Graphics2D prepare(Component component, Graphics2D graphicsArgument) {
        this.graphics = graphicsArgument;
        int width = component.getWidth();
        int height = component.getHeight();
        if (this.bufferedImage == null || this.bufferedImage.getWidth() < width || this.bufferedImage.getHeight() < height) {
            ColorSpace gsColorSpace = ColorSpace.getInstance(1003);
            ComponentColorModel ccm = new ComponentColorModel(gsColorSpace, true, false, 3, 0);
            WritableRaster raster = ccm.createCompatibleWritableRaster(width, height);
            this.bufferedImage = new BufferedImage(ccm, raster, ccm.isAlphaPremultiplied(), null);
        }
        this.bufferedImageGraphics = this.bufferedImage.createGraphics();
        this.bufferedImageGraphics.setClip(graphicsArgument.getClip());
        return this.bufferedImageGraphics;
    }

    @Override
    public void update() {
        this.bufferedImageGraphics.dispose();
        this.bufferedImageGraphics = null;
        this.bufferedImage.flush();
        this.graphics.drawImage((Image)this.bufferedImage, 0, 0, null);
        this.bufferedImage = null;
        this.graphics = null;
    }

    @Override
    public Bounds getBounds(Component component) {
        return new Bounds(0, 0, component.getWidth(), component.getHeight());
    }

    @Override
    public AffineTransform getTransform(Component component) {
        return new AffineTransform();
    }
}

