/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.effects;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.effects.Decorator;

public class FadeDecorator
implements Decorator {
    private float opacity;

    public FadeDecorator() {
        this(0.5f);
    }

    public FadeDecorator(float opacity) {
        this.opacity = opacity;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setOpacity(float opacity) {
        if (opacity < 0.0f || opacity > 1.0f) {
            throw new IllegalArgumentException("opacity must be a value between 0 and 1, inclusive.");
        }
        this.opacity = opacity;
    }

    @Override
    public Graphics2D prepare(Component component, Graphics2D graphics) {
        graphics.setComposite(AlphaComposite.getInstance(3, this.opacity));
        return graphics;
    }

    @Override
    public void update() {
    }

    @Override
    public Bounds getBounds(Component component) {
        return new Bounds(0, 0, component.getWidth(), component.getHeight());
    }

    @Override
    public AffineTransform getTransform(Component component) {
        return new AffineTransform();
    }
}

