/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.apache.pivot.json.JSON;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.content.TableViewCellRenderer;

public class TableViewNumberCellRenderer
extends TableViewCellRenderer {
    private NumberFormat numberFormat = DEFAULT_NUMBER_FORMAT;
    public static final NumberFormat DEFAULT_NUMBER_FORMAT = NumberFormat.getNumberInstance();

    public TableViewNumberCellRenderer() {
        this.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.RIGHT);
        this.getStyles().put("padding", (Object)new Insets(2, 2, 2, 6));
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        if (numberFormat == null) {
            throw new IllegalArgumentException("numberFormat is null.");
        }
        this.numberFormat = numberFormat;
    }

    public void setNumberFormat(String numberFormat) {
        this.setNumberFormat(new DecimalFormat(numberFormat));
    }

    @Override
    public String toString(Object row, String columnName) {
        Object cellData = JSON.get((Object)row, (String)columnName);
        String string = cellData instanceof Number ? this.numberFormat.format(cellData) : (cellData == null ? null : cellData.toString());
        return string;
    }
}

