/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Iterator;
import org.apache.pivot.beans.DefaultProperty;
import org.apache.pivot.collections.LinkedList;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Clipboard;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.LocalManifest;
import org.apache.pivot.wtk.Manifest;
import org.apache.pivot.wtk.Span;
import org.apache.pivot.wtk.TextPaneCharacterListener;
import org.apache.pivot.wtk.TextPaneListener;
import org.apache.pivot.wtk.TextPaneSelectionListener;
import org.apache.pivot.wtk.WTKListenerList;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.text.ComponentNode;
import org.apache.pivot.wtk.text.ComponentNodeListener;
import org.apache.pivot.wtk.text.Document;
import org.apache.pivot.wtk.text.Element;
import org.apache.pivot.wtk.text.Node;
import org.apache.pivot.wtk.text.NodeListener;
import org.apache.pivot.wtk.text.Paragraph;
import org.apache.pivot.wtk.text.PlainTextSerializer;
import org.apache.pivot.wtk.text.TextNode;

@DefaultProperty(value="document")
public class TextPane
extends Container {
    private Document document = null;
    private int selectionStart = 0;
    private int selectionLength = 0;
    private boolean editable = true;
    private boolean undoingHistory = false;
    private boolean bulkOperation = false;
    private ComponentNodeListener componentNodeListener = new ComponentNodeListener(){

        @Override
        public void componentChanged(ComponentNode componentNode, Component previousComponent) {
            TextPane.super.remove(previousComponent);
            TextPane.super.add(componentNode.getComponent());
        }
    };
    private NodeListener documentListener = new NodeListener.Adapter(){

        @Override
        public void rangeInserted(Node node, int offset, int characterCount) {
            if (TextPane.this.selectionStart + TextPane.this.selectionLength > offset) {
                if (TextPane.this.selectionStart > offset) {
                    TextPane.this.selectionStart += characterCount;
                } else {
                    TextPane.this.selectionLength += characterCount;
                }
            }
            if (!TextPane.this.undoingHistory) {
                TextPane.this.addHistoryItem(new RangeInsertedEdit(node, offset, characterCount));
            }
            if (!TextPane.this.bulkOperation) {
                TextPane.this.textPaneCharacterListeners.charactersInserted(TextPane.this, offset, characterCount);
            }
        }

        @Override
        public void nodesRemoved(Node node, Sequence<Node> removed, int offset) {
            for (int i = 0; i < removed.getLength(); ++i) {
                Node descendant = (Node)removed.get(i);
                if (!(descendant instanceof ComponentNode)) continue;
                ComponentNode componentNode = (ComponentNode)descendant;
                componentNode.getComponentNodeListeners().remove((Object)TextPane.this.componentNodeListener);
                TextPane.super.remove(componentNode.getComponent());
            }
            if (!TextPane.this.undoingHistory) {
                TextPane.this.addHistoryItem(new RangeRemovedEdit(node, removed, offset));
            }
        }

        @Override
        public void nodeInserted(Node node, int offset) {
            Node descendant = TextPane.this.document.getDescendantAt(offset);
            if (descendant instanceof ComponentNode) {
                ComponentNode componentNode = (ComponentNode)descendant;
                componentNode.getComponentNodeListeners().add((Object)TextPane.this.componentNodeListener);
                TextPane.super.add(componentNode.getComponent());
            }
        }

        @Override
        public void rangeRemoved(Node node, int offset, int characterCount) {
            if (TextPane.this.selectionStart + TextPane.this.selectionLength > offset) {
                if (TextPane.this.selectionStart > offset) {
                    TextPane.this.selectionStart -= characterCount;
                    if (TextPane.this.selectionStart < offset) {
                        TextPane.this.selectionStart = offset;
                    }
                } else {
                    TextPane.this.selectionLength -= characterCount;
                    if (TextPane.this.selectionLength < 0) {
                        TextPane.this.selectionLength = 0;
                    }
                }
            }
            if (!TextPane.this.bulkOperation) {
                TextPane.this.textPaneCharacterListeners.charactersRemoved(TextPane.this, offset, characterCount);
            }
        }
    };
    private LinkedList<Edit> editHistory = new LinkedList();
    private TextPaneListenerList textPaneListeners = new TextPaneListenerList();
    private TextPaneCharacterListenerList textPaneCharacterListeners = new TextPaneCharacterListenerList();
    private TextPaneSelectionListenerList textPaneSelectionListeners = new TextPaneSelectionListenerList();
    private static final int MAXIMUM_EDIT_HISTORY_LENGTH = 30;

    public TextPane() {
        this.installSkin(TextPane.class);
    }

    @Override
    protected void setSkin(org.apache.pivot.wtk.Skin skin) {
        if (!(skin instanceof Skin)) {
            throw new IllegalArgumentException("Skin class must implement " + Skin.class.getName());
        }
        super.setSkin(skin);
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        Document previousDocument = this.document;
        if (previousDocument != document) {
            if (previousDocument != null) {
                previousDocument.getNodeListeners().remove((Object)this.documentListener);
                this.removeComponentNodes(previousDocument);
            }
            if (document != null) {
                document.getNodeListeners().add((Object)this.documentListener);
                this.addComponentNodes(document);
            }
            this.editHistory.clear();
            this.document = document;
            this.selectionStart = 0;
            this.selectionLength = 0;
            this.textPaneListeners.documentChanged(this, previousDocument);
        }
    }

    private void removeComponentNodes(Element element) {
        for (Node childNode : element) {
            if (childNode instanceof Element) {
                this.removeComponentNodes((Element)childNode);
            }
            if (!(childNode instanceof ComponentNode)) continue;
            this.remove(((ComponentNode)childNode).getComponent());
        }
    }

    private void addComponentNodes(Element element) {
        for (Node childNode : element) {
            if (childNode instanceof Element) {
                this.addComponentNodes((Element)childNode);
            }
            if (!(childNode instanceof ComponentNode)) continue;
            this.add(((ComponentNode)childNode).getComponent());
        }
    }

    private Node getRightmostDescendant(Element element) {
        int n = element.getLength();
        if (n > 0) {
            Node node = element.get(n - 1);
            if (node instanceof Element) {
                return this.getRightmostDescendant((Element)node);
            }
            return node;
        }
        return element;
    }

    private Node removeDocumentRange(int start, int count) {
        this.bulkOperation = true;
        Node node = this.document.removeRange(start, count);
        this.bulkOperation = false;
        this.textPaneCharacterListeners.charactersRemoved(this, start, count);
        return node;
    }

    public void insert(char character) {
        this.insert(Character.toString(character));
    }

    public void insert(String text) {
        if (text == null) {
            throw new IllegalArgumentException("text is null.");
        }
        if (this.document == null) {
            throw new IllegalStateException();
        }
        if (this.selectionLength > 0) {
            this.delete(false);
        }
        if (this.document.getCharacterCount() == 0) {
            Paragraph paragraph = new Paragraph();
            paragraph.add(text);
            this.document.insert(paragraph, 0);
        } else {
            Node descendant = this.document.getDescendantAt(this.selectionStart);
            int offset = this.selectionStart - descendant.getDocumentOffset();
            if (descendant instanceof TextNode) {
                TextNode textNode = (TextNode)descendant;
                textNode.insertText(text, offset);
            } else if (descendant instanceof Paragraph) {
                Paragraph paragraph = (Paragraph)descendant;
                Node node = this.getRightmostDescendant(paragraph);
                if (node instanceof TextNode) {
                    TextNode textNode = (TextNode)node;
                    textNode.insertText(text, this.selectionStart - textNode.getDocumentOffset());
                } else if (node instanceof Element) {
                    Element element = (Element)node;
                    element.add(new TextNode(text));
                } else {
                    paragraph.add(new TextNode(text));
                }
            } else {
                Element parent = descendant.getParent();
                int index = parent.indexOf(descendant);
                parent.insert(new TextNode(text), index);
            }
        }
        this.setSelection(this.selectionStart + text.length(), 0);
    }

    public void insertImage(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("image is null.");
        }
        if (this.document == null || this.document.getCharacterCount() == 0) {
            throw new IllegalStateException();
        }
        if (this.selectionLength > 0) {
            this.removeDocumentRange(this.selectionStart, this.selectionLength);
        }
        this.setSelection(this.selectionStart + 1, this.selectionLength);
    }

    public void insertParagraph() {
        if (this.document == null || this.document.getCharacterCount() == 0) {
            throw new IllegalStateException();
        }
        if (this.selectionLength > 0) {
            this.removeDocumentRange(this.selectionStart, this.selectionLength);
        }
        Node descendant = this.document.getDescendantAt(this.selectionStart);
        while (!(descendant instanceof Paragraph)) {
            descendant = descendant.getParent();
        }
        Paragraph leadingSegment = (Paragraph)descendant;
        int offset = this.selectionStart - leadingSegment.getDocumentOffset();
        int characterCount = leadingSegment.getCharacterCount() - offset;
        Paragraph trailingSegment = (Paragraph)leadingSegment.removeRange(offset, characterCount);
        Element parent = leadingSegment.getParent();
        int index = parent.indexOf(leadingSegment);
        parent.insert(trailingSegment, index + 1);
        this.setSelection(this.selectionStart + 1, this.selectionLength);
    }

    public int getCharacterCount() {
        return this.document == null ? 0 : this.document.getCharacterCount();
    }

    public void delete(boolean backspace) {
        int characterCount;
        if (this.document == null || this.document.getCharacterCount() == 0) {
            throw new IllegalStateException();
        }
        int offset = this.selectionStart;
        if (this.selectionLength > 0) {
            characterCount = this.selectionLength;
        } else {
            if (backspace) {
                --offset;
            }
            characterCount = 1;
        }
        if (offset >= 0 && offset < this.document.getCharacterCount()) {
            Node descendant = this.document.getDescendantAt(offset);
            if (this.selectionLength == 0 && descendant instanceof Paragraph) {
                Paragraph paragraph = (Paragraph)descendant;
                Element parent = paragraph.getParent();
                int index = parent.indexOf(paragraph);
                if (index < parent.getLength() - 1) {
                    Sequence<Node> removed = parent.remove(index + 1, 1);
                    Paragraph nextParagraph = (Paragraph)removed.get(0);
                    paragraph.insertRange(nextParagraph, paragraph.getCharacterCount() - 1);
                }
            } else {
                this.removeDocumentRange(offset, characterCount);
            }
        }
        if (this.document.getCharacterCount() == 0) {
            this.document.add(new Paragraph(""));
        }
        if (offset >= 0) {
            this.setSelection(offset, 0);
        }
    }

    public void cut() {
        if (this.document == null || this.document.getCharacterCount() == 0) {
            throw new IllegalStateException();
        }
        if (this.selectionLength > 0) {
            Document selection = (Document)this.removeDocumentRange(this.selectionStart, this.selectionLength);
            String selectedText = null;
            try {
                PlainTextSerializer serializer = new PlainTextSerializer();
                StringWriter writer = new StringWriter();
                serializer.writeObject(selection, writer);
                selectedText = writer.toString();
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
            if (selectedText != null) {
                LocalManifest clipboardContent = new LocalManifest();
                clipboardContent.putText(selectedText);
                Clipboard.setContent(clipboardContent);
            }
        }
        this.setSelection(this.selectionStart, 0);
    }

    public void copy() {
        if (this.document == null || this.document.getCharacterCount() == 0) {
            throw new IllegalStateException();
        }
        String selectedText = this.getSelectedText();
        if (selectedText != null) {
            LocalManifest clipboardContent = new LocalManifest();
            clipboardContent.putText(selectedText);
            Clipboard.setContent(clipboardContent);
        }
    }

    public void paste() {
        if (this.document == null || this.document.getCharacterCount() == 0) {
            throw new IllegalStateException();
        }
        Manifest clipboardContent = Clipboard.getContent();
        if (clipboardContent != null && clipboardContent.containsText()) {
            String text = null;
            try {
                text = clipboardContent.getText();
            }
            catch (IOException exception) {
                // empty catch block
            }
            if (text != null && text.length() > 0) {
                int n;
                if (this.selectionLength > 0) {
                    this.delete(true);
                }
                try {
                    PlainTextSerializer serializer = new PlainTextSerializer();
                    StringReader reader = new StringReader(text);
                    Document documentLocal = serializer.readObject(reader);
                    n = documentLocal.getCharacterCount();
                    this.bulkOperation = true;
                    int start = this.selectionStart;
                    this.document.insertRange(documentLocal, start);
                    this.bulkOperation = false;
                    this.textPaneCharacterListeners.charactersInserted(this, start, n);
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
                this.setSelection(this.selectionStart + n, 0);
            }
        }
    }

    public void undo() {
        int n = this.editHistory.getLength();
        if (n > 0) {
            this.undoingHistory = true;
            Edit edit = (Edit)this.editHistory.remove(n - 1, 1).get(0);
            edit.undo();
            this.undoingHistory = false;
        }
    }

    private void addHistoryItem(Edit edit) {
        this.editHistory.add((Object)edit);
        if (this.editHistory.getLength() > 30) {
            this.editHistory.remove(0, 1);
        }
    }

    public void redo() {
    }

    private void addToText(StringBuilder text, Element element) {
        for (Node node : element) {
            if (node instanceof TextNode) {
                text.append(((TextNode)node).getCharacters());
                continue;
            }
            if (!(node instanceof Element)) continue;
            this.addToText(text, (Element)node);
        }
        if (element instanceof Paragraph) {
            text.append('\n');
        }
    }

    public String getText() {
        Document doc = this.getDocument();
        if (doc != null && this.getCharacterCount() != 0) {
            StringBuilder text = new StringBuilder(this.getCharacterCount());
            this.addToText(text, doc);
            return text.toString();
        }
        return null;
    }

    public void setText(String text) {
        Document doc = new Document();
        String[] lines = text.split("\r?\n");
        for (int i = 0; i < lines.length; ++i) {
            Paragraph paragraph = new Paragraph(lines[i]);
            doc.add(paragraph);
        }
        this.setDocument(doc);
    }

    public int getSelectionStart() {
        return this.selectionStart;
    }

    public int getSelectionLength() {
        return this.selectionLength;
    }

    public Span getSelection() {
        return this.selectionLength == 0 ? null : new Span(this.selectionStart, this.selectionStart + this.selectionLength - 1);
    }

    public void setSelection(int selectionStart, int selectionLength) {
        if (this.document == null || this.document.getCharacterCount() == 0) {
            throw new IllegalStateException();
        }
        if (selectionLength < 0) {
            throw new IllegalArgumentException("selectionLength is negative, selectionLength=" + selectionLength);
        }
        TextPane.indexBoundsCheck("selectionStart", selectionStart, 0, this.document.getCharacterCount() - 1);
        if (selectionStart + selectionLength > this.document.getCharacterCount()) {
            throw new IndexOutOfBoundsException("selectionStart=" + selectionStart + ", selectionLength=" + selectionLength + ", document.characterCount=" + this.document.getCharacterCount());
        }
        int previousSelectionStart = this.selectionStart;
        int previousSelectionLength = this.selectionLength;
        if (previousSelectionStart != selectionStart || previousSelectionLength != selectionLength) {
            this.selectionStart = selectionStart;
            this.selectionLength = selectionLength;
            this.textPaneSelectionListeners.selectionChanged(this, previousSelectionStart, previousSelectionLength);
        }
    }

    public final void setSelection(Span selection) {
        if (selection == null) {
            throw new IllegalArgumentException("selection is null.");
        }
        this.setSelection(Math.min(selection.start, selection.end), (int)selection.getLength());
    }

    public void selectAll() {
        if (this.document == null) {
            throw new IllegalStateException();
        }
        this.setSelection(0, this.document.getCharacterCount());
    }

    public void clearSelection() {
        this.setSelection(0, 0);
    }

    public String getSelectedText() {
        String selectedText = null;
        if (this.selectionLength > 0) {
            Document selection = (Document)this.document.getRange(this.selectionStart, this.selectionLength);
            try {
                PlainTextSerializer serializer = new PlainTextSerializer();
                StringWriter writer = new StringWriter();
                serializer.writeObject(selection, writer);
                selectedText = writer.toString();
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        }
        return selectedText;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        if (this.editable != editable) {
            if (!editable && this.isFocused()) {
                TextPane.clearFocus();
            }
            this.editable = editable;
            this.textPaneListeners.editableChanged(this);
        }
    }

    public int getInsertionPoint(int x, int y) {
        Skin textPaneSkin = (Skin)((Object)this.getSkin());
        return textPaneSkin.getInsertionPoint(x, y);
    }

    public int getNextInsertionPoint(int x, int from, ScrollDirection direction) {
        Skin textPaneSkin = (Skin)((Object)this.getSkin());
        return textPaneSkin.getNextInsertionPoint(x, from, direction);
    }

    public int getRowAt(int offset) {
        Skin textPaneSkin = (Skin)((Object)this.getSkin());
        return textPaneSkin.getRowAt(offset);
    }

    public int getRowCount() {
        Skin textPaneSkin = (Skin)((Object)this.getSkin());
        return textPaneSkin.getRowCount();
    }

    public Bounds getCharacterBounds(int offset) {
        this.validate();
        Skin textPaneSkin = (Skin)((Object)this.getSkin());
        return textPaneSkin.getCharacterBounds(offset);
    }

    public ListenerList<TextPaneListener> getTextPaneListeners() {
        return this.textPaneListeners;
    }

    public ListenerList<TextPaneCharacterListener> getTextPaneCharacterListeners() {
        return this.textPaneCharacterListeners;
    }

    public ListenerList<TextPaneSelectionListener> getTextPaneSelectionListeners() {
        return this.textPaneSelectionListeners;
    }

    private static class TextPaneSelectionListenerList
    extends WTKListenerList<TextPaneSelectionListener>
    implements TextPaneSelectionListener {
        private TextPaneSelectionListenerList() {
        }

        @Override
        public void selectionChanged(TextPane textPane, int previousSelectionStart, int previousSelectionLength) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TextPaneSelectionListener listener = (TextPaneSelectionListener)i$.next();
                listener.selectionChanged(textPane, previousSelectionStart, previousSelectionLength);
            }
        }
    }

    private static class TextPaneCharacterListenerList
    extends WTKListenerList<TextPaneCharacterListener>
    implements TextPaneCharacterListener {
        private TextPaneCharacterListenerList() {
        }

        @Override
        public void charactersInserted(TextPane textPane, int index, int count) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TextPaneCharacterListener listener = (TextPaneCharacterListener)i$.next();
                listener.charactersInserted(textPane, index, count);
            }
        }

        @Override
        public void charactersRemoved(TextPane textPane, int index, int count) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TextPaneCharacterListener listener = (TextPaneCharacterListener)i$.next();
                listener.charactersRemoved(textPane, index, count);
            }
        }
    }

    private static class TextPaneListenerList
    extends WTKListenerList<TextPaneListener>
    implements TextPaneListener {
        private TextPaneListenerList() {
        }

        @Override
        public void documentChanged(TextPane textPane, Document previousText) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TextPaneListener listener = (TextPaneListener)i$.next();
                listener.documentChanged(textPane, previousText);
            }
        }

        @Override
        public void editableChanged(TextPane textPane) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TextPaneListener listener = (TextPaneListener)i$.next();
                listener.editableChanged(textPane);
            }
        }
    }

    private class RangeInsertedEdit
    implements Edit {
        private final Node node;
        private final int offset;
        private final int characterCount;

        public RangeInsertedEdit(Node node, int offset, int characterCount) {
            this.node = node;
            this.offset = offset;
            this.characterCount = characterCount;
        }

        @Override
        public void undo() {
            this.node.removeRange(this.offset, this.characterCount);
            int newSelectionStart = TextPane.this.selectionStart;
            int newSelectionLength = TextPane.this.selectionLength;
            if (newSelectionStart >= TextPane.this.document.getCharacterCount()) {
                newSelectionStart = TextPane.this.document.getCharacterCount() - 1;
            }
            if (newSelectionStart + newSelectionLength > TextPane.this.document.getCharacterCount()) {
                newSelectionLength = TextPane.this.document.getCharacterCount() - newSelectionStart;
            }
            TextPane.this.setSelection(newSelectionStart, newSelectionLength);
        }
    }

    private static class RangeRemovedEdit
    implements Edit {
        private final Node node;
        private final int offset;
        private final Sequence<Node> removed;

        public RangeRemovedEdit(Node node, Sequence<Node> removed, int offset) {
            this.node = node;
            this.offset = offset;
            this.removed = removed;
        }

        @Override
        public void undo() {
            Document tmp = new Document();
            for (int i = 0; i < this.removed.getLength(); ++i) {
                tmp.add((Node)this.removed.get(i));
            }
            this.node.insertRange(tmp, this.offset);
        }
    }

    private static interface Edit {
        public void undo();
    }

    public static interface Skin {
        public int getInsertionPoint(int var1, int var2);

        public int getNextInsertionPoint(int var1, int var2, ScrollDirection var3);

        public int getRowAt(int var1);

        public int getRowCount();

        public Bounds getCharacterBounds(int var1);
    }

    public static enum ScrollDirection {
        UP,
        DOWN;

    }
}

