/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Comparator;
import java.util.Iterator;
import org.apache.pivot.beans.DefaultProperty;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.ListListener;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.collections.immutable.ImmutableList;
import org.apache.pivot.json.JSON;
import org.apache.pivot.json.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.BindType;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Renderer;
import org.apache.pivot.wtk.SpinnerBindingListener;
import org.apache.pivot.wtk.SpinnerItemListener;
import org.apache.pivot.wtk.SpinnerListener;
import org.apache.pivot.wtk.SpinnerSelectionListener;
import org.apache.pivot.wtk.WTKListenerList;
import org.apache.pivot.wtk.content.SpinnerItemRenderer;

@DefaultProperty(value="spinnerData")
public class Spinner
extends Container {
    private List<?> spinnerData = null;
    private ItemRenderer itemRenderer = null;
    private boolean circular = false;
    private int selectedIndex = -1;
    private String spinnerDataKey = null;
    private BindType spinnerDataBindType = BindType.BOTH;
    private SpinnerDataBindMapping spinnerDataBindMapping = null;
    private String selectedItemKey = null;
    private BindType selectedItemBindType = BindType.BOTH;
    private ItemBindMapping selectedItemBindMapping = null;
    private ListListener<Object> spinnerDataListener = new ListListener<Object>(){

        public void itemInserted(List<Object> list, int index) {
            int previousSelectedIndex = Spinner.this.selectedIndex;
            if (index <= Spinner.this.selectedIndex) {
                Spinner.this.selectedIndex++;
            }
            Spinner.this.spinnerItemListeners.itemInserted(Spinner.this, index);
            if (Spinner.this.selectedIndex != previousSelectedIndex) {
                Spinner.this.spinnerSelectionListeners.selectedIndexChanged(Spinner.this, Spinner.this.selectedIndex);
            }
        }

        public void itemsRemoved(List<Object> list, int index, Sequence<Object> items) {
            int count = items.getLength();
            int previousSelectedIndex = Spinner.this.selectedIndex;
            if (Spinner.this.selectedIndex >= index) {
                if (Spinner.this.selectedIndex < index + count) {
                    Spinner.this.selectedIndex = -1;
                } else {
                    Spinner.this.selectedIndex -= count;
                }
            }
            Spinner.this.spinnerItemListeners.itemsRemoved(Spinner.this, index, count);
            if (Spinner.this.selectedIndex != previousSelectedIndex) {
                Spinner.this.spinnerSelectionListeners.selectedIndexChanged(Spinner.this, Spinner.this.selectedIndex);
                if (Spinner.this.selectedIndex == -1) {
                    Spinner.this.spinnerSelectionListeners.selectedItemChanged(Spinner.this, null);
                }
            }
        }

        public void itemUpdated(List<Object> list, int index, Object previousItem) {
            Spinner.this.spinnerItemListeners.itemUpdated(Spinner.this, index);
        }

        public void listCleared(List<Object> list) {
            int previousSelectedIndex = Spinner.this.selectedIndex;
            Spinner.this.selectedIndex = -1;
            Spinner.this.spinnerItemListeners.itemsCleared(Spinner.this);
            if (previousSelectedIndex != Spinner.this.selectedIndex) {
                Spinner.this.spinnerSelectionListeners.selectedIndexChanged(Spinner.this, Spinner.this.selectedIndex);
                Spinner.this.spinnerSelectionListeners.selectedItemChanged(Spinner.this, Spinner.this.getSelectedItem());
            }
        }

        public void comparatorChanged(List<Object> list, Comparator<Object> previousComparator) {
            if (list.getComparator() != null) {
                int previousSelectedIndex = Spinner.this.selectedIndex;
                Spinner.this.selectedIndex = -1;
                Spinner.this.spinnerItemListeners.itemsSorted(Spinner.this);
                if (previousSelectedIndex != Spinner.this.selectedIndex) {
                    Spinner.this.spinnerSelectionListeners.selectedIndexChanged(Spinner.this, Spinner.this.selectedIndex);
                    Spinner.this.spinnerSelectionListeners.selectedItemChanged(Spinner.this, Spinner.this.getSelectedItem());
                }
            }
        }
    };
    private SpinnerListenerList spinnerListeners = new SpinnerListenerList();
    private SpinnerItemListenerList spinnerItemListeners = new SpinnerItemListenerList();
    private SpinnerSelectionListenerList spinnerSelectionListeners = new SpinnerSelectionListenerList();
    private SpinnerBindingListenerList spinnerBindingListeners = new SpinnerBindingListenerList();
    private static final ItemRenderer DEFAULT_ITEM_RENDERER = new SpinnerItemRenderer();

    public Spinner() {
        this((List<?>)new ImmutableList((List)new ArrayList()));
    }

    public Spinner(List<?> spinnerData) {
        this.setItemRenderer(DEFAULT_ITEM_RENDERER);
        this.setSpinnerData(spinnerData);
        this.installSkin(Spinner.class);
    }

    public List<?> getSpinnerData() {
        return this.spinnerData;
    }

    public void setSpinnerData(List<?> spinnerData) {
        if (spinnerData == null) {
            throw new IllegalArgumentException("spinnerData is null.");
        }
        List<?> previousSpinnerData = this.spinnerData;
        if (previousSpinnerData != spinnerData) {
            int previousSelectedIndex = this.selectedIndex;
            if (previousSpinnerData != null) {
                this.selectedIndex = -1;
                previousSpinnerData.getListListeners().remove(this.spinnerDataListener);
            }
            spinnerData.getListListeners().add(this.spinnerDataListener);
            this.spinnerData = spinnerData;
            this.spinnerListeners.spinnerDataChanged(this, previousSpinnerData);
            if (this.selectedIndex != previousSelectedIndex) {
                this.spinnerSelectionListeners.selectedIndexChanged(this, this.selectedIndex);
                this.spinnerSelectionListeners.selectedItemChanged(this, null);
            }
        }
    }

    public final void setSpinnerData(String spinnerData) {
        if (spinnerData == null) {
            throw new IllegalArgumentException("spinnerData is null.");
        }
        try {
            this.setSpinnerData(JSONSerializer.parseList((String)spinnerData));
        }
        catch (SerializationException exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    @Override
    protected void setSkin(org.apache.pivot.wtk.Skin skin) {
        if (!(skin instanceof Skin)) {
            throw new IllegalArgumentException("Skin class must implement " + Skin.class.getName());
        }
        super.setSkin(skin);
    }

    public ItemRenderer getItemRenderer() {
        return this.itemRenderer;
    }

    public void setItemRenderer(ItemRenderer itemRenderer) {
        if (itemRenderer == null) {
            throw new IllegalArgumentException("itemRenderer is null.");
        }
        ItemRenderer previousItemRenderer = this.itemRenderer;
        if (previousItemRenderer != itemRenderer) {
            this.itemRenderer = itemRenderer;
            this.spinnerListeners.itemRendererChanged(this, previousItemRenderer);
        }
    }

    public boolean isCircular() {
        return this.circular;
    }

    public void setCircular(boolean circular) {
        if (circular != this.circular) {
            this.circular = circular;
            this.spinnerListeners.circularChanged(this);
        }
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int selectedIndex) {
        Spinner.indexBoundsCheck("selectedIndex", selectedIndex, -1, this.spinnerData.getLength() - 1);
        int previousSelectedIndex = this.selectedIndex;
        if (previousSelectedIndex != selectedIndex) {
            this.selectedIndex = selectedIndex;
            this.spinnerSelectionListeners.selectedIndexChanged(this, previousSelectedIndex);
            this.spinnerSelectionListeners.selectedItemChanged(this, previousSelectedIndex == -1 ? null : this.spinnerData.get(previousSelectedIndex));
        }
    }

    public Object getSelectedItem() {
        int index = this.getSelectedIndex();
        Object item = null;
        if (index >= 0) {
            item = this.spinnerData.get(index);
        }
        return item;
    }

    public void setSelectedItem(Object item) {
        this.setSelectedIndex(item == null ? -1 : this.spinnerData.indexOf(item));
    }

    public String getSpinnerDataKey() {
        return this.spinnerDataKey;
    }

    public void setSpinnerDataKey(String spinnerDataKey) {
        String previousSpinnerDataKey = this.spinnerDataKey;
        if (previousSpinnerDataKey != spinnerDataKey) {
            this.spinnerDataKey = spinnerDataKey;
            this.spinnerBindingListeners.spinnerDataKeyChanged(this, previousSpinnerDataKey);
        }
    }

    public BindType getSpinnerDataBindType() {
        return this.spinnerDataBindType;
    }

    public void setSpinnerDataBindType(BindType spinnerDataBindType) {
        if (spinnerDataBindType == null) {
            throw new IllegalArgumentException();
        }
        BindType previousSpinnerDataBindType = this.spinnerDataBindType;
        if (previousSpinnerDataBindType != spinnerDataBindType) {
            this.spinnerDataBindType = spinnerDataBindType;
            this.spinnerBindingListeners.spinnerDataBindTypeChanged(this, previousSpinnerDataBindType);
        }
    }

    public SpinnerDataBindMapping getSpinnerDataBindMapping() {
        return this.spinnerDataBindMapping;
    }

    public void setSpinnerDataBindMapping(SpinnerDataBindMapping spinnerDataBindMapping) {
        SpinnerDataBindMapping previousSpinnerDataBindMapping = this.spinnerDataBindMapping;
        if (previousSpinnerDataBindMapping != spinnerDataBindMapping) {
            this.spinnerDataBindMapping = spinnerDataBindMapping;
            this.spinnerBindingListeners.spinnerDataBindMappingChanged(this, previousSpinnerDataBindMapping);
        }
    }

    public String getSelectedItemKey() {
        return this.selectedItemKey;
    }

    public void setSelectedItemKey(String selectedItemKey) {
        String previousSelectedItemKey = this.selectedItemKey;
        if (previousSelectedItemKey != selectedItemKey) {
            this.selectedItemKey = selectedItemKey;
            this.spinnerBindingListeners.selectedItemKeyChanged(this, previousSelectedItemKey);
        }
    }

    public BindType getSelectedItemBindType() {
        return this.selectedItemBindType;
    }

    public void setSelectedItemBindType(BindType selectedItemBindType) {
        if (selectedItemBindType == null) {
            throw new IllegalArgumentException();
        }
        BindType previousSelectedItemBindType = this.selectedItemBindType;
        if (previousSelectedItemBindType != selectedItemBindType) {
            this.selectedItemBindType = selectedItemBindType;
            this.spinnerBindingListeners.selectedItemBindTypeChanged(this, previousSelectedItemBindType);
        }
    }

    public ItemBindMapping getSelectedItemBindMapping() {
        return this.selectedItemBindMapping;
    }

    public void setSelectedItemBindMapping(ItemBindMapping selectedItemBindMapping) {
        ItemBindMapping previousSelectedItemBindMapping = this.selectedItemBindMapping;
        if (previousSelectedItemBindMapping != selectedItemBindMapping) {
            this.selectedItemBindMapping = selectedItemBindMapping;
            this.spinnerBindingListeners.selectedItemBindMappingChanged(this, previousSelectedItemBindMapping);
        }
    }

    @Override
    public void load(Object context) {
        if (this.spinnerDataKey != null && this.spinnerDataBindType != BindType.STORE && JSON.containsKey((Object)context, (String)this.spinnerDataKey)) {
            Object value = JSON.get((Object)context, (String)this.spinnerDataKey);
            List<?> spinnerDataLocal = this.spinnerDataBindMapping == null ? (List<?>)value : this.spinnerDataBindMapping.toSpinnerData(value);
            this.setSpinnerData(spinnerDataLocal);
        }
        if (this.selectedItemKey != null && JSON.containsKey((Object)context, (String)this.selectedItemKey) && this.selectedItemBindType != BindType.STORE) {
            Object item = JSON.get((Object)context, (String)this.selectedItemKey);
            int index = this.selectedItemBindMapping == null ? this.spinnerData.indexOf(item) : this.selectedItemBindMapping.indexOf(this.spinnerData, item);
            this.setSelectedIndex(index);
        }
    }

    @Override
    public void store(Object context) {
        if (this.spinnerDataKey != null && this.spinnerDataBindType != BindType.LOAD) {
            Object value = this.spinnerDataBindMapping == null ? this.spinnerData : this.spinnerDataBindMapping.valueOf(this.spinnerData);
            JSON.put((Object)context, (String)this.spinnerDataKey, value);
        }
        if (this.selectedItemKey != null && this.selectedItemBindType != BindType.LOAD) {
            Object item = this.selectedIndex == -1 ? null : (this.selectedItemBindMapping == null ? this.spinnerData.get(this.selectedIndex) : this.selectedItemBindMapping.get(this.spinnerData, this.selectedIndex));
            JSON.put((Object)context, (String)this.selectedItemKey, item);
        }
    }

    @Override
    public void clear() {
        if (this.spinnerDataKey != null) {
            this.setSpinnerData((List<?>)new ArrayList());
        }
        if (this.selectedItemKey != null) {
            this.setSelectedItem(null);
        }
    }

    public void clearSelection() {
        this.setSelectedItem(null);
    }

    public Bounds getContentBounds() {
        Skin spinnerSkin = (Skin)((Object)this.getSkin());
        return spinnerSkin.getContentBounds();
    }

    public ListenerList<SpinnerListener> getSpinnerListeners() {
        return this.spinnerListeners;
    }

    public ListenerList<SpinnerItemListener> getSpinnerItemListeners() {
        return this.spinnerItemListeners;
    }

    public ListenerList<SpinnerSelectionListener> getSpinnerSelectionListeners() {
        return this.spinnerSelectionListeners;
    }

    public ListenerList<SpinnerBindingListener> getSpinnerBindingListeners() {
        return this.spinnerBindingListeners;
    }

    private static class SpinnerBindingListenerList
    extends WTKListenerList<SpinnerBindingListener>
    implements SpinnerBindingListener {
        private SpinnerBindingListenerList() {
        }

        @Override
        public void spinnerDataKeyChanged(Spinner spinner, String previousSpinnerDataKey) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SpinnerBindingListener listener = (SpinnerBindingListener)i$.next();
                listener.spinnerDataKeyChanged(spinner, previousSpinnerDataKey);
            }
        }

        @Override
        public void spinnerDataBindTypeChanged(Spinner spinner, BindType previousSpinnerDataBindType) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SpinnerBindingListener listener = (SpinnerBindingListener)i$.next();
                listener.spinnerDataBindTypeChanged(spinner, previousSpinnerDataBindType);
            }
        }

        @Override
        public void spinnerDataBindMappingChanged(Spinner spinner, SpinnerDataBindMapping previousSpinnerDataBindMapping) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SpinnerBindingListener listener = (SpinnerBindingListener)i$.next();
                listener.spinnerDataBindMappingChanged(spinner, previousSpinnerDataBindMapping);
            }
        }

        @Override
        public void selectedItemKeyChanged(Spinner spinner, String previousSelectedItemKey) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SpinnerBindingListener listener = (SpinnerBindingListener)i$.next();
                listener.selectedItemKeyChanged(spinner, previousSelectedItemKey);
            }
        }

        @Override
        public void selectedItemBindTypeChanged(Spinner spinner, BindType previousSelectedItemBindType) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SpinnerBindingListener listener = (SpinnerBindingListener)i$.next();
                listener.selectedItemBindTypeChanged(spinner, previousSelectedItemBindType);
            }
        }

        @Override
        public void selectedItemBindMappingChanged(Spinner spinner, ItemBindMapping previousSelectedItemBindMapping) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SpinnerBindingListener listener = (SpinnerBindingListener)i$.next();
                listener.selectedItemBindMappingChanged(spinner, previousSelectedItemBindMapping);
            }
        }
    }

    private static class SpinnerSelectionListenerList
    extends WTKListenerList<SpinnerSelectionListener>
    implements SpinnerSelectionListener {
        private SpinnerSelectionListenerList() {
        }

        @Override
        public void selectedIndexChanged(Spinner spinner, int previousSelectedIndex) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SpinnerSelectionListener listener = (SpinnerSelectionListener)i$.next();
                listener.selectedIndexChanged(spinner, previousSelectedIndex);
            }
        }

        @Override
        public void selectedItemChanged(Spinner spinner, Object previousSelectedItem) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SpinnerSelectionListener listener = (SpinnerSelectionListener)i$.next();
                listener.selectedItemChanged(spinner, previousSelectedItem);
            }
        }
    }

    private static class SpinnerItemListenerList
    extends WTKListenerList<SpinnerItemListener>
    implements SpinnerItemListener {
        private SpinnerItemListenerList() {
        }

        @Override
        public void itemInserted(Spinner spinner, int index) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SpinnerItemListener listener = (SpinnerItemListener)i$.next();
                listener.itemInserted(spinner, index);
            }
        }

        @Override
        public void itemsRemoved(Spinner spinner, int index, int count) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SpinnerItemListener listener = (SpinnerItemListener)i$.next();
                listener.itemsRemoved(spinner, index, count);
            }
        }

        @Override
        public void itemUpdated(Spinner spinner, int index) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SpinnerItemListener listener = (SpinnerItemListener)i$.next();
                listener.itemUpdated(spinner, index);
            }
        }

        @Override
        public void itemsCleared(Spinner spinner) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SpinnerItemListener listener = (SpinnerItemListener)i$.next();
                listener.itemsCleared(spinner);
            }
        }

        @Override
        public void itemsSorted(Spinner spinner) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SpinnerItemListener listener = (SpinnerItemListener)i$.next();
                listener.itemsSorted(spinner);
            }
        }
    }

    private static class SpinnerListenerList
    extends WTKListenerList<SpinnerListener>
    implements SpinnerListener {
        private SpinnerListenerList() {
        }

        @Override
        public void spinnerDataChanged(Spinner spinner, List<?> previousSpinnerData) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SpinnerListener listener = (SpinnerListener)i$.next();
                listener.spinnerDataChanged(spinner, previousSpinnerData);
            }
        }

        @Override
        public void itemRendererChanged(Spinner spinner, ItemRenderer previousItemRenderer) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SpinnerListener listener = (SpinnerListener)i$.next();
                listener.itemRendererChanged(spinner, previousItemRenderer);
            }
        }

        @Override
        public void circularChanged(Spinner spinner) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SpinnerListener listener = (SpinnerListener)i$.next();
                listener.circularChanged(spinner);
            }
        }
    }

    public static interface ItemBindMapping {
        public int indexOf(List<?> var1, Object var2);

        public Object get(List<?> var1, int var2);
    }

    public static interface Skin {
        public Bounds getContentBounds();
    }

    public static interface SpinnerDataBindMapping {
        public List<?> toSpinnerData(Object var1);

        public Object valueOf(List<?> var1);
    }

    public static interface ItemRenderer
    extends Renderer {
        public void render(Object var1, Spinner var2);

        public String toString(Object var1);
    }
}

