/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.json.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;

public final class Span {
    public final int start;
    public final int end;
    public static final String START_KEY = "start";
    public static final String END_KEY = "end";

    public Span(int index) {
        this.start = index;
        this.end = index;
    }

    public Span(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public Span(Span span) {
        if (span == null) {
            throw new IllegalArgumentException("span is null.");
        }
        this.start = span.start;
        this.end = span.end;
    }

    public Span(Dictionary<String, ?> span) {
        if (span == null) {
            throw new IllegalArgumentException("span is null.");
        }
        if (!span.containsKey((Object)START_KEY)) {
            throw new IllegalArgumentException("start is required.");
        }
        if (!span.containsKey((Object)END_KEY)) {
            throw new IllegalArgumentException("end is required.");
        }
        this.start = (Integer)span.get((Object)START_KEY);
        this.end = (Integer)span.get((Object)END_KEY);
    }

    public long getLength() {
        return Math.abs((long)this.end - (long)this.start) + 1L;
    }

    public boolean contains(Span span) {
        if (span == null) {
            throw new IllegalArgumentException("span is null.");
        }
        Span normalizedSpan = span.normalize();
        boolean contains = this.start < this.end ? this.start <= normalizedSpan.start && this.end >= normalizedSpan.end : this.end <= normalizedSpan.start && this.start >= normalizedSpan.end;
        return contains;
    }

    public boolean intersects(Span span) {
        if (span == null) {
            throw new IllegalArgumentException("span is null.");
        }
        Span normalizedSpan = span.normalize();
        boolean intersects = this.start < this.end ? this.start <= normalizedSpan.end && this.end >= normalizedSpan.start : this.end <= normalizedSpan.end && this.start >= normalizedSpan.start;
        return intersects;
    }

    public Span intersect(Span span) {
        if (span == null) {
            throw new IllegalArgumentException("span is null.");
        }
        Span intersection = null;
        if (this.intersects(span)) {
            intersection = new Span(Math.max(this.start, span.start), Math.min(this.end, span.end));
        }
        return intersection;
    }

    public Span union(Span span) {
        if (span == null) {
            throw new IllegalArgumentException("span is null.");
        }
        return new Span(Math.min(this.start, span.start), Math.max(this.end, span.end));
    }

    public Span normalize() {
        return new Span(Math.min(this.start, this.end), Math.max(this.start, this.end));
    }

    public boolean equals(Object o) {
        boolean equal = false;
        if (o instanceof Span) {
            Span span = (Span)o;
            equal = this.start == span.start && this.end == span.end;
        }
        return equal;
    }

    public int hashCode() {
        return 31 * this.start + this.end;
    }

    public String toString() {
        return "{start: " + this.start + ", end: " + this.end + "}";
    }

    public static Span decode(String value) {
        Span span;
        if (value == null) {
            throw new IllegalArgumentException();
        }
        if (value.startsWith("{")) {
            try {
                span = new Span((Dictionary<String, ?>)JSONSerializer.parseMap((String)value));
            }
            catch (SerializationException exception) {
                throw new IllegalArgumentException(exception);
            }
        } else {
            span = new Span(Integer.parseInt(value));
        }
        return span;
    }
}

