/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.io.Serializable;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.json.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;

public final class Point
implements Serializable {
    private static final long serialVersionUID = 5193175754909343769L;
    public final int x;
    public final int y;
    public static final String X_KEY = "x";
    public static final String Y_KEY = "y";

    public Point(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Point(Point point) {
        if (point == null) {
            throw new IllegalArgumentException("point is null.");
        }
        this.x = point.x;
        this.y = point.y;
    }

    public Point(Dictionary<String, ?> point) {
        if (point == null) {
            throw new IllegalArgumentException("point is null.");
        }
        this.x = point.containsKey((Object)X_KEY) ? (Integer)point.get((Object)X_KEY) : 0;
        this.y = point.containsKey((Object)Y_KEY) ? (Integer)point.get((Object)Y_KEY) : 0;
    }

    public Point translate(int dx, int dy) {
        return new Point(this.x + dx, this.y + dy);
    }

    public boolean equals(Object object) {
        boolean equals = false;
        if (object instanceof Point) {
            Point point = (Point)object;
            equals = this.x == point.x && this.y == point.y;
        }
        return equals;
    }

    public int hashCode() {
        return 31 * this.x + this.y;
    }

    public String toString() {
        return this.getClass().getName() + " [" + this.x + "," + this.y + "]";
    }

    public static Point decode(String value) {
        Point point;
        if (value == null) {
            throw new IllegalArgumentException();
        }
        try {
            point = new Point((Dictionary<String, ?>)JSONSerializer.parseMap((String)value));
        }
        catch (SerializationException exception) {
            throw new IllegalArgumentException(exception);
        }
        return point;
    }
}

